/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrockagentruntime.model.BedrockAgentRuntimeResponse;
import software.amazon.awssdk.services.bedrockagentruntime.model.Citation;
import software.amazon.awssdk.services.bedrockagentruntime.model.CitationsCopier;
import software.amazon.awssdk.services.bedrockagentruntime.model.GuadrailAction;
import software.amazon.awssdk.services.bedrockagentruntime.model.RetrieveAndGenerateOutput;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RetrieveAndGenerateResponse
extends BedrockAgentRuntimeResponse
implements ToCopyableBuilder<Builder, RetrieveAndGenerateResponse> {
    private static final SdkField<String> SESSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sessionId").getter(RetrieveAndGenerateResponse.getter(RetrieveAndGenerateResponse::sessionId)).setter(RetrieveAndGenerateResponse.setter(Builder::sessionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionId").build()}).build();
    private static final SdkField<RetrieveAndGenerateOutput> OUTPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("output").getter(RetrieveAndGenerateResponse.getter(RetrieveAndGenerateResponse::output)).setter(RetrieveAndGenerateResponse.setter(Builder::output)).constructor(RetrieveAndGenerateOutput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("output").build()}).build();
    private static final SdkField<List<Citation>> CITATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("citations").getter(RetrieveAndGenerateResponse.getter(RetrieveAndGenerateResponse::citations)).setter(RetrieveAndGenerateResponse.setter(Builder::citations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("citations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Citation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> GUARDRAIL_ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("guardrailAction").getter(RetrieveAndGenerateResponse.getter(RetrieveAndGenerateResponse::guardrailActionAsString)).setter(RetrieveAndGenerateResponse.setter(Builder::guardrailAction)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("guardrailAction").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SESSION_ID_FIELD, OUTPUT_FIELD, CITATIONS_FIELD, GUARDRAIL_ACTION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RetrieveAndGenerateResponse.memberNameToFieldInitializer();
    private final String sessionId;
    private final RetrieveAndGenerateOutput output;
    private final List<Citation> citations;
    private final String guardrailAction;

    private RetrieveAndGenerateResponse(BuilderImpl builder) {
        super(builder);
        this.sessionId = builder.sessionId;
        this.output = builder.output;
        this.citations = builder.citations;
        this.guardrailAction = builder.guardrailAction;
    }

    public final String sessionId() {
        return this.sessionId;
    }

    public final RetrieveAndGenerateOutput output() {
        return this.output;
    }

    public final boolean hasCitations() {
        return this.citations != null && !(this.citations instanceof SdkAutoConstructList);
    }

    public final List<Citation> citations() {
        return this.citations;
    }

    public final GuadrailAction guardrailAction() {
        return GuadrailAction.fromValue(this.guardrailAction);
    }

    public final String guardrailActionAsString() {
        return this.guardrailAction;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.output());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCitations() ? this.citations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.guardrailActionAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RetrieveAndGenerateResponse)) {
            return false;
        }
        RetrieveAndGenerateResponse other = (RetrieveAndGenerateResponse)((Object)obj);
        return Objects.equals(this.sessionId(), other.sessionId()) && Objects.equals(this.output(), other.output()) && this.hasCitations() == other.hasCitations() && Objects.equals(this.citations(), other.citations()) && Objects.equals(this.guardrailActionAsString(), other.guardrailActionAsString());
    }

    public final String toString() {
        return ToString.builder((String)"RetrieveAndGenerateResponse").add("SessionId", (Object)this.sessionId()).add("Output", (Object)(this.output() == null ? null : "*** Sensitive Data Redacted ***")).add("Citations", this.hasCitations() ? this.citations() : null).add("GuardrailAction", (Object)this.guardrailActionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "sessionId": {
                return Optional.ofNullable(clazz.cast(this.sessionId()));
            }
            case "output": {
                return Optional.ofNullable(clazz.cast(this.output()));
            }
            case "citations": {
                return Optional.ofNullable(clazz.cast(this.citations()));
            }
            case "guardrailAction": {
                return Optional.ofNullable(clazz.cast(this.guardrailActionAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("sessionId", SESSION_ID_FIELD);
        map.put("output", OUTPUT_FIELD);
        map.put("citations", CITATIONS_FIELD);
        map.put("guardrailAction", GUARDRAIL_ACTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RetrieveAndGenerateResponse, T> g) {
        return obj -> g.apply((RetrieveAndGenerateResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockAgentRuntimeResponse.BuilderImpl
    implements Builder {
        private String sessionId;
        private RetrieveAndGenerateOutput output;
        private List<Citation> citations = DefaultSdkAutoConstructList.getInstance();
        private String guardrailAction;

        private BuilderImpl() {
        }

        private BuilderImpl(RetrieveAndGenerateResponse model) {
            super(model);
            this.sessionId(model.sessionId);
            this.output(model.output);
            this.citations(model.citations);
            this.guardrailAction(model.guardrailAction);
        }

        public final String getSessionId() {
            return this.sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final RetrieveAndGenerateOutput.Builder getOutput() {
            return this.output != null ? this.output.toBuilder() : null;
        }

        public final void setOutput(RetrieveAndGenerateOutput.BuilderImpl output) {
            this.output = output != null ? output.build() : null;
        }

        @Override
        public final Builder output(RetrieveAndGenerateOutput output) {
            this.output = output;
            return this;
        }

        public final List<Citation.Builder> getCitations() {
            List<Citation.Builder> result = CitationsCopier.copyToBuilder(this.citations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCitations(Collection<Citation.BuilderImpl> citations) {
            this.citations = CitationsCopier.copyFromBuilder(citations);
        }

        @Override
        public final Builder citations(Collection<Citation> citations) {
            this.citations = CitationsCopier.copy(citations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder citations(Citation ... citations) {
            this.citations(Arrays.asList(citations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder citations(Consumer<Citation.Builder> ... citations) {
            this.citations(Stream.of(citations).map(c -> (Citation)((Citation.Builder)Citation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getGuardrailAction() {
            return this.guardrailAction;
        }

        public final void setGuardrailAction(String guardrailAction) {
            this.guardrailAction = guardrailAction;
        }

        @Override
        public final Builder guardrailAction(String guardrailAction) {
            this.guardrailAction = guardrailAction;
            return this;
        }

        @Override
        public final Builder guardrailAction(GuadrailAction guardrailAction) {
            this.guardrailAction(guardrailAction == null ? null : guardrailAction.toString());
            return this;
        }

        @Override
        public RetrieveAndGenerateResponse build() {
            return new RetrieveAndGenerateResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BedrockAgentRuntimeResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RetrieveAndGenerateResponse> {
        public Builder sessionId(String var1);

        public Builder output(RetrieveAndGenerateOutput var1);

        default public Builder output(Consumer<RetrieveAndGenerateOutput.Builder> output) {
            return this.output((RetrieveAndGenerateOutput)((RetrieveAndGenerateOutput.Builder)RetrieveAndGenerateOutput.builder().applyMutation(output)).build());
        }

        public Builder citations(Collection<Citation> var1);

        public Builder citations(Citation ... var1);

        public Builder citations(Consumer<Citation.Builder> ... var1);

        public Builder guardrailAction(String var1);

        public Builder guardrailAction(GuadrailAction var1);
    }
}

