/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagentruntime.model.BedrockAgentRuntimeRequest;
import software.amazon.awssdk.services.bedrockagentruntime.model.InputPrompt;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OptimizePromptRequest
extends BedrockAgentRuntimeRequest
implements ToCopyableBuilder<Builder, OptimizePromptRequest> {
    private static final SdkField<InputPrompt> INPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("input").getter(OptimizePromptRequest.getter(OptimizePromptRequest::input)).setter(OptimizePromptRequest.setter(Builder::input)).constructor(InputPrompt::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("input").build()}).build();
    private static final SdkField<String> TARGET_MODEL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("targetModelId").getter(OptimizePromptRequest.getter(OptimizePromptRequest::targetModelId)).setter(OptimizePromptRequest.setter(Builder::targetModelId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetModelId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INPUT_FIELD, TARGET_MODEL_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = OptimizePromptRequest.memberNameToFieldInitializer();
    private final InputPrompt input;
    private final String targetModelId;

    private OptimizePromptRequest(BuilderImpl builder) {
        super(builder);
        this.input = builder.input;
        this.targetModelId = builder.targetModelId;
    }

    public final InputPrompt input() {
        return this.input;
    }

    public final String targetModelId() {
        return this.targetModelId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.input());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetModelId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OptimizePromptRequest)) {
            return false;
        }
        OptimizePromptRequest other = (OptimizePromptRequest)((Object)obj);
        return Objects.equals(this.input(), other.input()) && Objects.equals(this.targetModelId(), other.targetModelId());
    }

    public final String toString() {
        return ToString.builder((String)"OptimizePromptRequest").add("Input", (Object)this.input()).add("TargetModelId", (Object)this.targetModelId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "input": {
                return Optional.ofNullable(clazz.cast(this.input()));
            }
            case "targetModelId": {
                return Optional.ofNullable(clazz.cast(this.targetModelId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("input", INPUT_FIELD);
        map.put("targetModelId", TARGET_MODEL_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OptimizePromptRequest, T> g) {
        return obj -> g.apply((OptimizePromptRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockAgentRuntimeRequest.BuilderImpl
    implements Builder {
        private InputPrompt input;
        private String targetModelId;

        private BuilderImpl() {
        }

        private BuilderImpl(OptimizePromptRequest model) {
            super(model);
            this.input(model.input);
            this.targetModelId(model.targetModelId);
        }

        public final InputPrompt.Builder getInput() {
            return this.input != null ? this.input.toBuilder() : null;
        }

        public final void setInput(InputPrompt.BuilderImpl input) {
            this.input = input != null ? input.build() : null;
        }

        @Override
        public final Builder input(InputPrompt input) {
            this.input = input;
            return this;
        }

        public final String getTargetModelId() {
            return this.targetModelId;
        }

        public final void setTargetModelId(String targetModelId) {
            this.targetModelId = targetModelId;
        }

        @Override
        public final Builder targetModelId(String targetModelId) {
            this.targetModelId = targetModelId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public OptimizePromptRequest build() {
            return new OptimizePromptRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BedrockAgentRuntimeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, OptimizePromptRequest> {
        public Builder input(InputPrompt var1);

        default public Builder input(Consumer<InputPrompt.Builder> input) {
            return this.input((InputPrompt)((InputPrompt.Builder)InputPrompt.builder().applyMutation(input)).build());
        }

        public Builder targetModelId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

