/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrockagentruntime.model.FlowNodeIODataType;
import software.amazon.awssdk.services.bedrockagentruntime.model.FlowNodeInputCategory;
import software.amazon.awssdk.services.bedrockagentruntime.model.NodeExecutionContent;
import software.amazon.awssdk.services.bedrockagentruntime.model.NodeInputExecutionChainCopier;
import software.amazon.awssdk.services.bedrockagentruntime.model.NodeInputExecutionChainItem;
import software.amazon.awssdk.services.bedrockagentruntime.model.NodeInputSource;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NodeInputField
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NodeInputField> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(NodeInputField.getter(NodeInputField::name)).setter(NodeInputField.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<NodeExecutionContent> CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("content").getter(NodeInputField.getter(NodeInputField::content)).setter(NodeInputField.setter(Builder::content)).constructor(NodeExecutionContent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("content").build()}).build();
    private static final SdkField<NodeInputSource> SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("source").getter(NodeInputField.getter(NodeInputField::source)).setter(NodeInputField.setter(Builder::source)).constructor(NodeInputSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("source").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(NodeInputField.getter(NodeInputField::typeAsString)).setter(NodeInputField.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<String> CATEGORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("category").getter(NodeInputField.getter(NodeInputField::categoryAsString)).setter(NodeInputField.setter(Builder::category)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("category").build()}).build();
    private static final SdkField<List<NodeInputExecutionChainItem>> EXECUTION_CHAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("executionChain").getter(NodeInputField.getter(NodeInputField::executionChain)).setter(NodeInputField.setter(Builder::executionChain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionChain").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(NodeInputExecutionChainItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, CONTENT_FIELD, SOURCE_FIELD, TYPE_FIELD, CATEGORY_FIELD, EXECUTION_CHAIN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = NodeInputField.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String name;
    private final NodeExecutionContent content;
    private final NodeInputSource source;
    private final String type;
    private final String category;
    private final List<NodeInputExecutionChainItem> executionChain;

    private NodeInputField(BuilderImpl builder) {
        this.name = builder.name;
        this.content = builder.content;
        this.source = builder.source;
        this.type = builder.type;
        this.category = builder.category;
        this.executionChain = builder.executionChain;
    }

    public final String name() {
        return this.name;
    }

    public final NodeExecutionContent content() {
        return this.content;
    }

    public final NodeInputSource source() {
        return this.source;
    }

    public final FlowNodeIODataType type() {
        return FlowNodeIODataType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final FlowNodeInputCategory category() {
        return FlowNodeInputCategory.fromValue(this.category);
    }

    public final String categoryAsString() {
        return this.category;
    }

    public final boolean hasExecutionChain() {
        return this.executionChain != null && !(this.executionChain instanceof SdkAutoConstructList);
    }

    public final List<NodeInputExecutionChainItem> executionChain() {
        return this.executionChain;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.content());
        hashCode = 31 * hashCode + Objects.hashCode(this.source());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.categoryAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExecutionChain() ? this.executionChain() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NodeInputField)) {
            return false;
        }
        NodeInputField other = (NodeInputField)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.content(), other.content()) && Objects.equals(this.source(), other.source()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.categoryAsString(), other.categoryAsString()) && this.hasExecutionChain() == other.hasExecutionChain() && Objects.equals(this.executionChain(), other.executionChain());
    }

    public final String toString() {
        return ToString.builder((String)"NodeInputField").add("Name", (Object)this.name()).add("Content", (Object)(this.content() == null ? null : "*** Sensitive Data Redacted ***")).add("Source", (Object)this.source()).add("Type", (Object)this.typeAsString()).add("Category", (Object)this.categoryAsString()).add("ExecutionChain", this.hasExecutionChain() ? this.executionChain() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "content": {
                return Optional.ofNullable(clazz.cast(this.content()));
            }
            case "source": {
                return Optional.ofNullable(clazz.cast(this.source()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "category": {
                return Optional.ofNullable(clazz.cast(this.categoryAsString()));
            }
            case "executionChain": {
                return Optional.ofNullable(clazz.cast(this.executionChain()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", NAME_FIELD);
        map.put("content", CONTENT_FIELD);
        map.put("source", SOURCE_FIELD);
        map.put("type", TYPE_FIELD);
        map.put("category", CATEGORY_FIELD);
        map.put("executionChain", EXECUTION_CHAIN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NodeInputField, T> g) {
        return obj -> g.apply((NodeInputField)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private NodeExecutionContent content;
        private NodeInputSource source;
        private String type;
        private String category;
        private List<NodeInputExecutionChainItem> executionChain = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(NodeInputField model) {
            this.name(model.name);
            this.content(model.content);
            this.source(model.source);
            this.type(model.type);
            this.category(model.category);
            this.executionChain(model.executionChain);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final NodeExecutionContent.Builder getContent() {
            return this.content != null ? this.content.toBuilder() : null;
        }

        public final void setContent(NodeExecutionContent.BuilderImpl content) {
            this.content = content != null ? content.build() : null;
        }

        @Override
        public final Builder content(NodeExecutionContent content) {
            this.content = content;
            return this;
        }

        public final NodeInputSource.Builder getSource() {
            return this.source != null ? this.source.toBuilder() : null;
        }

        public final void setSource(NodeInputSource.BuilderImpl source) {
            this.source = source != null ? source.build() : null;
        }

        @Override
        public final Builder source(NodeInputSource source) {
            this.source = source;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(FlowNodeIODataType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getCategory() {
            return this.category;
        }

        public final void setCategory(String category) {
            this.category = category;
        }

        @Override
        public final Builder category(String category) {
            this.category = category;
            return this;
        }

        @Override
        public final Builder category(FlowNodeInputCategory category) {
            this.category(category == null ? null : category.toString());
            return this;
        }

        public final List<NodeInputExecutionChainItem.Builder> getExecutionChain() {
            List<NodeInputExecutionChainItem.Builder> result = NodeInputExecutionChainCopier.copyToBuilder(this.executionChain);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setExecutionChain(Collection<NodeInputExecutionChainItem.BuilderImpl> executionChain) {
            this.executionChain = NodeInputExecutionChainCopier.copyFromBuilder(executionChain);
        }

        @Override
        public final Builder executionChain(Collection<NodeInputExecutionChainItem> executionChain) {
            this.executionChain = NodeInputExecutionChainCopier.copy(executionChain);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder executionChain(NodeInputExecutionChainItem ... executionChain) {
            this.executionChain(Arrays.asList(executionChain));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder executionChain(Consumer<NodeInputExecutionChainItem.Builder> ... executionChain) {
            this.executionChain(Stream.of(executionChain).map(c -> (NodeInputExecutionChainItem)((NodeInputExecutionChainItem.Builder)NodeInputExecutionChainItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public NodeInputField build() {
            return new NodeInputField(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NodeInputField> {
        public Builder name(String var1);

        public Builder content(NodeExecutionContent var1);

        default public Builder content(Consumer<NodeExecutionContent.Builder> content) {
            return this.content((NodeExecutionContent)((NodeExecutionContent.Builder)NodeExecutionContent.builder().applyMutation(content)).build());
        }

        public Builder source(NodeInputSource var1);

        default public Builder source(Consumer<NodeInputSource.Builder> source) {
            return this.source((NodeInputSource)((NodeInputSource.Builder)NodeInputSource.builder().applyMutation(source)).build());
        }

        public Builder type(String var1);

        public Builder type(FlowNodeIODataType var1);

        public Builder category(String var1);

        public Builder category(FlowNodeInputCategory var1);

        public Builder executionChain(Collection<NodeInputExecutionChainItem> var1);

        public Builder executionChain(NodeInputExecutionChainItem ... var1);

        public Builder executionChain(Consumer<NodeInputExecutionChainItem.Builder> ... var1);
    }
}

