/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagentruntime.model.NodeTraceElements;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NodeDependencyEvent
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NodeDependencyEvent> {
    private static final SdkField<String> NODE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nodeName").getter(NodeDependencyEvent.getter(NodeDependencyEvent::nodeName)).setter(NodeDependencyEvent.setter(Builder::nodeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nodeName").build()}).build();
    private static final SdkField<Instant> TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("timestamp").getter(NodeDependencyEvent.getter(NodeDependencyEvent::timestamp)).setter(NodeDependencyEvent.setter(Builder::timestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timestamp").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<NodeTraceElements> TRACE_ELEMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("traceElements").getter(NodeDependencyEvent.getter(NodeDependencyEvent::traceElements)).setter(NodeDependencyEvent.setter(Builder::traceElements)).constructor(NodeTraceElements::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("traceElements").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NODE_NAME_FIELD, TIMESTAMP_FIELD, TRACE_ELEMENTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = NodeDependencyEvent.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String nodeName;
    private final Instant timestamp;
    private final NodeTraceElements traceElements;

    private NodeDependencyEvent(BuilderImpl builder) {
        this.nodeName = builder.nodeName;
        this.timestamp = builder.timestamp;
        this.traceElements = builder.traceElements;
    }

    public final String nodeName() {
        return this.nodeName;
    }

    public final Instant timestamp() {
        return this.timestamp;
    }

    public final NodeTraceElements traceElements() {
        return this.traceElements;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.timestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.traceElements());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NodeDependencyEvent)) {
            return false;
        }
        NodeDependencyEvent other = (NodeDependencyEvent)obj;
        return Objects.equals(this.nodeName(), other.nodeName()) && Objects.equals(this.timestamp(), other.timestamp()) && Objects.equals(this.traceElements(), other.traceElements());
    }

    public final String toString() {
        return ToString.builder((String)"NodeDependencyEvent").add("NodeName", (Object)this.nodeName()).add("Timestamp", (Object)this.timestamp()).add("TraceElements", (Object)(this.traceElements() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nodeName": {
                return Optional.ofNullable(clazz.cast(this.nodeName()));
            }
            case "timestamp": {
                return Optional.ofNullable(clazz.cast(this.timestamp()));
            }
            case "traceElements": {
                return Optional.ofNullable(clazz.cast(this.traceElements()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("nodeName", NODE_NAME_FIELD);
        map.put("timestamp", TIMESTAMP_FIELD);
        map.put("traceElements", TRACE_ELEMENTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NodeDependencyEvent, T> g) {
        return obj -> g.apply((NodeDependencyEvent)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String nodeName;
        private Instant timestamp;
        private NodeTraceElements traceElements;

        private BuilderImpl() {
        }

        private BuilderImpl(NodeDependencyEvent model) {
            this.nodeName(model.nodeName);
            this.timestamp(model.timestamp);
            this.traceElements(model.traceElements);
        }

        public final String getNodeName() {
            return this.nodeName;
        }

        public final void setNodeName(String nodeName) {
            this.nodeName = nodeName;
        }

        @Override
        public final Builder nodeName(String nodeName) {
            this.nodeName = nodeName;
            return this;
        }

        public final Instant getTimestamp() {
            return this.timestamp;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final NodeTraceElements.Builder getTraceElements() {
            return this.traceElements != null ? this.traceElements.toBuilder() : null;
        }

        public final void setTraceElements(NodeTraceElements.BuilderImpl traceElements) {
            this.traceElements = traceElements != null ? traceElements.build() : null;
        }

        @Override
        public final Builder traceElements(NodeTraceElements traceElements) {
            this.traceElements = traceElements;
            return this;
        }

        public NodeDependencyEvent build() {
            return new NodeDependencyEvent(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NodeDependencyEvent> {
        public Builder nodeName(String var1);

        public Builder timestamp(Instant var1);

        public Builder traceElements(NodeTraceElements var1);

        default public Builder traceElements(Consumer<NodeTraceElements.Builder> traceElements) {
            return this.traceElements((NodeTraceElements)((NodeTraceElements.Builder)NodeTraceElements.builder().applyMutation(traceElements)).build());
        }
    }
}

