/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ImageInputFormat {
    PNG("png"),
    JPEG("jpeg"),
    GIF("gif"),
    WEBP("webp"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ImageInputFormat> VALUE_MAP;
    private final String value;

    private ImageInputFormat(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ImageInputFormat fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ImageInputFormat> knownValues() {
        EnumSet<ImageInputFormat> knownValues = EnumSet.allOf(ImageInputFormat.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ImageInputFormat.class, ImageInputFormat::toString);
    }
}

