/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.bedrockagentruntime.model.CustomControlMethod;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ActionGroupExecutor
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ActionGroupExecutor> {
    private static final SdkField<String> LAMBDA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("lambda").getter(ActionGroupExecutor.getter(ActionGroupExecutor::lambda)).setter(ActionGroupExecutor.setter(Builder::lambda)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lambda").build()}).build();
    private static final SdkField<String> CUSTOM_CONTROL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("customControl").getter(ActionGroupExecutor.getter(ActionGroupExecutor::customControlAsString)).setter(ActionGroupExecutor.setter(Builder::customControl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customControl").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAMBDA_FIELD, CUSTOM_CONTROL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ActionGroupExecutor.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String lambda;
    private final String customControl;
    private final Type type;

    private ActionGroupExecutor(BuilderImpl builder) {
        this.lambda = builder.lambda;
        this.customControl = builder.customControl;
        this.type = builder.type;
    }

    public final String lambda() {
        return this.lambda;
    }

    public final CustomControlMethod customControl() {
        return CustomControlMethod.fromValue(this.customControl);
    }

    public final String customControlAsString() {
        return this.customControl;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.lambda());
        hashCode = 31 * hashCode + Objects.hashCode(this.customControlAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActionGroupExecutor)) {
            return false;
        }
        ActionGroupExecutor other = (ActionGroupExecutor)obj;
        return Objects.equals(this.lambda(), other.lambda()) && Objects.equals(this.customControlAsString(), other.customControlAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ActionGroupExecutor").add("Lambda", (Object)this.lambda()).add("CustomControl", (Object)this.customControlAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "lambda": {
                return Optional.ofNullable(clazz.cast(this.lambda()));
            }
            case "customControl": {
                return Optional.ofNullable(clazz.cast(this.customControlAsString()));
            }
        }
        return Optional.empty();
    }

    public static ActionGroupExecutor fromLambda(String lambda) {
        return (ActionGroupExecutor)ActionGroupExecutor.builder().lambda(lambda).build();
    }

    public static ActionGroupExecutor fromCustomControl(String customControl) {
        return (ActionGroupExecutor)ActionGroupExecutor.builder().customControl(customControl).build();
    }

    public static ActionGroupExecutor fromCustomControl(CustomControlMethod customControl) {
        return (ActionGroupExecutor)ActionGroupExecutor.builder().customControl(customControl).build();
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("lambda", LAMBDA_FIELD);
        map.put("customControl", CUSTOM_CONTROL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ActionGroupExecutor, T> g) {
        return obj -> g.apply((ActionGroupExecutor)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        LAMBDA,
        CUSTOM_CONTROL,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private String lambda;
        private String customControl;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ActionGroupExecutor model) {
            this.lambda(model.lambda);
            this.customControl(model.customControl);
        }

        public final String getLambda() {
            return this.lambda;
        }

        public final void setLambda(String lambda) {
            String oldValue = this.lambda;
            this.lambda = lambda;
            this.handleUnionValueChange(Type.LAMBDA, oldValue, this.lambda);
        }

        @Override
        public final Builder lambda(String lambda) {
            String oldValue = this.lambda;
            this.lambda = lambda;
            this.handleUnionValueChange(Type.LAMBDA, oldValue, this.lambda);
            return this;
        }

        public final String getCustomControl() {
            return this.customControl;
        }

        public final void setCustomControl(String customControl) {
            String oldValue = this.customControl;
            this.customControl = customControl;
            this.handleUnionValueChange(Type.CUSTOM_CONTROL, oldValue, this.customControl);
        }

        @Override
        public final Builder customControl(String customControl) {
            String oldValue = this.customControl;
            this.customControl = customControl;
            this.handleUnionValueChange(Type.CUSTOM_CONTROL, oldValue, this.customControl);
            return this;
        }

        @Override
        public final Builder customControl(CustomControlMethod customControl) {
            this.customControl(customControl == null ? null : customControl.toString());
            return this;
        }

        public ActionGroupExecutor build() {
            return new ActionGroupExecutor(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ActionGroupExecutor> {
        public Builder lambda(String var1);

        public Builder customControl(String var1);

        public Builder customControl(CustomControlMethod var1);
    }
}

