/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.bedrockagentruntime.model.FailureTrace;
import software.amazon.awssdk.services.bedrockagentruntime.model.GuardrailTrace;
import software.amazon.awssdk.services.bedrockagentruntime.model.OrchestrationTrace;
import software.amazon.awssdk.services.bedrockagentruntime.model.PostProcessingTrace;
import software.amazon.awssdk.services.bedrockagentruntime.model.PreProcessingTrace;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Trace
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Trace> {
    private static final SdkField<FailureTrace> FAILURE_TRACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("failureTrace").getter(Trace.getter(Trace::failureTrace)).setter(Trace.setter(Builder::failureTrace)).constructor(FailureTrace::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureTrace").build()}).build();
    private static final SdkField<GuardrailTrace> GUARDRAIL_TRACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("guardrailTrace").getter(Trace.getter(Trace::guardrailTrace)).setter(Trace.setter(Builder::guardrailTrace)).constructor(GuardrailTrace::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("guardrailTrace").build()}).build();
    private static final SdkField<OrchestrationTrace> ORCHESTRATION_TRACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("orchestrationTrace").getter(Trace.getter(Trace::orchestrationTrace)).setter(Trace.setter(Builder::orchestrationTrace)).constructor(OrchestrationTrace::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("orchestrationTrace").build()}).build();
    private static final SdkField<PostProcessingTrace> POST_PROCESSING_TRACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("postProcessingTrace").getter(Trace.getter(Trace::postProcessingTrace)).setter(Trace.setter(Builder::postProcessingTrace)).constructor(PostProcessingTrace::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("postProcessingTrace").build()}).build();
    private static final SdkField<PreProcessingTrace> PRE_PROCESSING_TRACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("preProcessingTrace").getter(Trace.getter(Trace::preProcessingTrace)).setter(Trace.setter(Builder::preProcessingTrace)).constructor(PreProcessingTrace::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("preProcessingTrace").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FAILURE_TRACE_FIELD, GUARDRAIL_TRACE_FIELD, ORCHESTRATION_TRACE_FIELD, POST_PROCESSING_TRACE_FIELD, PRE_PROCESSING_TRACE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("failureTrace", FAILURE_TRACE_FIELD);
            this.put("guardrailTrace", GUARDRAIL_TRACE_FIELD);
            this.put("orchestrationTrace", ORCHESTRATION_TRACE_FIELD);
            this.put("postProcessingTrace", POST_PROCESSING_TRACE_FIELD);
            this.put("preProcessingTrace", PRE_PROCESSING_TRACE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final FailureTrace failureTrace;
    private final GuardrailTrace guardrailTrace;
    private final OrchestrationTrace orchestrationTrace;
    private final PostProcessingTrace postProcessingTrace;
    private final PreProcessingTrace preProcessingTrace;
    private final Type type;

    private Trace(BuilderImpl builder) {
        this.failureTrace = builder.failureTrace;
        this.guardrailTrace = builder.guardrailTrace;
        this.orchestrationTrace = builder.orchestrationTrace;
        this.postProcessingTrace = builder.postProcessingTrace;
        this.preProcessingTrace = builder.preProcessingTrace;
        this.type = builder.type;
    }

    public final FailureTrace failureTrace() {
        return this.failureTrace;
    }

    public final GuardrailTrace guardrailTrace() {
        return this.guardrailTrace;
    }

    public final OrchestrationTrace orchestrationTrace() {
        return this.orchestrationTrace;
    }

    public final PostProcessingTrace postProcessingTrace() {
        return this.postProcessingTrace;
    }

    public final PreProcessingTrace preProcessingTrace() {
        return this.preProcessingTrace;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.failureTrace());
        hashCode = 31 * hashCode + Objects.hashCode(this.guardrailTrace());
        hashCode = 31 * hashCode + Objects.hashCode(this.orchestrationTrace());
        hashCode = 31 * hashCode + Objects.hashCode(this.postProcessingTrace());
        hashCode = 31 * hashCode + Objects.hashCode(this.preProcessingTrace());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Trace)) {
            return false;
        }
        Trace other = (Trace)obj;
        return Objects.equals(this.failureTrace(), other.failureTrace()) && Objects.equals(this.guardrailTrace(), other.guardrailTrace()) && Objects.equals(this.orchestrationTrace(), other.orchestrationTrace()) && Objects.equals(this.postProcessingTrace(), other.postProcessingTrace()) && Objects.equals(this.preProcessingTrace(), other.preProcessingTrace());
    }

    public final String toString() {
        return ToString.builder((String)"Trace").add("FailureTrace", (Object)(this.failureTrace() == null ? null : "*** Sensitive Data Redacted ***")).add("GuardrailTrace", (Object)(this.guardrailTrace() == null ? null : "*** Sensitive Data Redacted ***")).add("OrchestrationTrace", (Object)(this.orchestrationTrace() == null ? null : "*** Sensitive Data Redacted ***")).add("PostProcessingTrace", (Object)(this.postProcessingTrace() == null ? null : "*** Sensitive Data Redacted ***")).add("PreProcessingTrace", (Object)(this.preProcessingTrace() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "failureTrace": {
                return Optional.ofNullable(clazz.cast(this.failureTrace()));
            }
            case "guardrailTrace": {
                return Optional.ofNullable(clazz.cast(this.guardrailTrace()));
            }
            case "orchestrationTrace": {
                return Optional.ofNullable(clazz.cast(this.orchestrationTrace()));
            }
            case "postProcessingTrace": {
                return Optional.ofNullable(clazz.cast(this.postProcessingTrace()));
            }
            case "preProcessingTrace": {
                return Optional.ofNullable(clazz.cast(this.preProcessingTrace()));
            }
        }
        return Optional.empty();
    }

    public static Trace fromFailureTrace(FailureTrace failureTrace) {
        return (Trace)Trace.builder().failureTrace(failureTrace).build();
    }

    public static Trace fromFailureTrace(Consumer<FailureTrace.Builder> failureTrace) {
        FailureTrace.Builder builder = FailureTrace.builder();
        failureTrace.accept(builder);
        return Trace.fromFailureTrace((FailureTrace)builder.build());
    }

    public static Trace fromGuardrailTrace(GuardrailTrace guardrailTrace) {
        return (Trace)Trace.builder().guardrailTrace(guardrailTrace).build();
    }

    public static Trace fromGuardrailTrace(Consumer<GuardrailTrace.Builder> guardrailTrace) {
        GuardrailTrace.Builder builder = GuardrailTrace.builder();
        guardrailTrace.accept(builder);
        return Trace.fromGuardrailTrace((GuardrailTrace)builder.build());
    }

    public static Trace fromOrchestrationTrace(OrchestrationTrace orchestrationTrace) {
        return (Trace)Trace.builder().orchestrationTrace(orchestrationTrace).build();
    }

    public static Trace fromOrchestrationTrace(Consumer<OrchestrationTrace.Builder> orchestrationTrace) {
        OrchestrationTrace.Builder builder = OrchestrationTrace.builder();
        orchestrationTrace.accept(builder);
        return Trace.fromOrchestrationTrace((OrchestrationTrace)builder.build());
    }

    public static Trace fromPostProcessingTrace(PostProcessingTrace postProcessingTrace) {
        return (Trace)Trace.builder().postProcessingTrace(postProcessingTrace).build();
    }

    public static Trace fromPostProcessingTrace(Consumer<PostProcessingTrace.Builder> postProcessingTrace) {
        PostProcessingTrace.Builder builder = PostProcessingTrace.builder();
        postProcessingTrace.accept(builder);
        return Trace.fromPostProcessingTrace((PostProcessingTrace)builder.build());
    }

    public static Trace fromPreProcessingTrace(PreProcessingTrace preProcessingTrace) {
        return (Trace)Trace.builder().preProcessingTrace(preProcessingTrace).build();
    }

    public static Trace fromPreProcessingTrace(Consumer<PreProcessingTrace.Builder> preProcessingTrace) {
        PreProcessingTrace.Builder builder = PreProcessingTrace.builder();
        preProcessingTrace.accept(builder);
        return Trace.fromPreProcessingTrace((PreProcessingTrace)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Trace, T> g) {
        return obj -> g.apply((Trace)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        FAILURE_TRACE,
        GUARDRAIL_TRACE,
        ORCHESTRATION_TRACE,
        POST_PROCESSING_TRACE,
        PRE_PROCESSING_TRACE,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private FailureTrace failureTrace;
        private GuardrailTrace guardrailTrace;
        private OrchestrationTrace orchestrationTrace;
        private PostProcessingTrace postProcessingTrace;
        private PreProcessingTrace preProcessingTrace;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(Trace model) {
            this.failureTrace(model.failureTrace);
            this.guardrailTrace(model.guardrailTrace);
            this.orchestrationTrace(model.orchestrationTrace);
            this.postProcessingTrace(model.postProcessingTrace);
            this.preProcessingTrace(model.preProcessingTrace);
        }

        public final FailureTrace.Builder getFailureTrace() {
            return this.failureTrace != null ? this.failureTrace.toBuilder() : null;
        }

        public final void setFailureTrace(FailureTrace.BuilderImpl failureTrace) {
            FailureTrace oldValue = this.failureTrace;
            this.failureTrace = failureTrace != null ? failureTrace.build() : null;
            this.handleUnionValueChange(Type.FAILURE_TRACE, oldValue, this.failureTrace);
        }

        @Override
        public final Builder failureTrace(FailureTrace failureTrace) {
            FailureTrace oldValue = this.failureTrace;
            this.failureTrace = failureTrace;
            this.handleUnionValueChange(Type.FAILURE_TRACE, oldValue, this.failureTrace);
            return this;
        }

        public final GuardrailTrace.Builder getGuardrailTrace() {
            return this.guardrailTrace != null ? this.guardrailTrace.toBuilder() : null;
        }

        public final void setGuardrailTrace(GuardrailTrace.BuilderImpl guardrailTrace) {
            GuardrailTrace oldValue = this.guardrailTrace;
            this.guardrailTrace = guardrailTrace != null ? guardrailTrace.build() : null;
            this.handleUnionValueChange(Type.GUARDRAIL_TRACE, oldValue, this.guardrailTrace);
        }

        @Override
        public final Builder guardrailTrace(GuardrailTrace guardrailTrace) {
            GuardrailTrace oldValue = this.guardrailTrace;
            this.guardrailTrace = guardrailTrace;
            this.handleUnionValueChange(Type.GUARDRAIL_TRACE, oldValue, this.guardrailTrace);
            return this;
        }

        public final OrchestrationTrace.Builder getOrchestrationTrace() {
            return this.orchestrationTrace != null ? this.orchestrationTrace.toBuilder() : null;
        }

        public final void setOrchestrationTrace(OrchestrationTrace.BuilderImpl orchestrationTrace) {
            OrchestrationTrace oldValue = this.orchestrationTrace;
            this.orchestrationTrace = orchestrationTrace != null ? orchestrationTrace.build() : null;
            this.handleUnionValueChange(Type.ORCHESTRATION_TRACE, oldValue, this.orchestrationTrace);
        }

        @Override
        public final Builder orchestrationTrace(OrchestrationTrace orchestrationTrace) {
            OrchestrationTrace oldValue = this.orchestrationTrace;
            this.orchestrationTrace = orchestrationTrace;
            this.handleUnionValueChange(Type.ORCHESTRATION_TRACE, oldValue, this.orchestrationTrace);
            return this;
        }

        public final PostProcessingTrace.Builder getPostProcessingTrace() {
            return this.postProcessingTrace != null ? this.postProcessingTrace.toBuilder() : null;
        }

        public final void setPostProcessingTrace(PostProcessingTrace.BuilderImpl postProcessingTrace) {
            PostProcessingTrace oldValue = this.postProcessingTrace;
            this.postProcessingTrace = postProcessingTrace != null ? postProcessingTrace.build() : null;
            this.handleUnionValueChange(Type.POST_PROCESSING_TRACE, oldValue, this.postProcessingTrace);
        }

        @Override
        public final Builder postProcessingTrace(PostProcessingTrace postProcessingTrace) {
            PostProcessingTrace oldValue = this.postProcessingTrace;
            this.postProcessingTrace = postProcessingTrace;
            this.handleUnionValueChange(Type.POST_PROCESSING_TRACE, oldValue, this.postProcessingTrace);
            return this;
        }

        public final PreProcessingTrace.Builder getPreProcessingTrace() {
            return this.preProcessingTrace != null ? this.preProcessingTrace.toBuilder() : null;
        }

        public final void setPreProcessingTrace(PreProcessingTrace.BuilderImpl preProcessingTrace) {
            PreProcessingTrace oldValue = this.preProcessingTrace;
            this.preProcessingTrace = preProcessingTrace != null ? preProcessingTrace.build() : null;
            this.handleUnionValueChange(Type.PRE_PROCESSING_TRACE, oldValue, this.preProcessingTrace);
        }

        @Override
        public final Builder preProcessingTrace(PreProcessingTrace preProcessingTrace) {
            PreProcessingTrace oldValue = this.preProcessingTrace;
            this.preProcessingTrace = preProcessingTrace;
            this.handleUnionValueChange(Type.PRE_PROCESSING_TRACE, oldValue, this.preProcessingTrace);
            return this;
        }

        public Trace build() {
            return new Trace(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Trace> {
        public Builder failureTrace(FailureTrace var1);

        default public Builder failureTrace(Consumer<FailureTrace.Builder> failureTrace) {
            return this.failureTrace((FailureTrace)((FailureTrace.Builder)FailureTrace.builder().applyMutation(failureTrace)).build());
        }

        public Builder guardrailTrace(GuardrailTrace var1);

        default public Builder guardrailTrace(Consumer<GuardrailTrace.Builder> guardrailTrace) {
            return this.guardrailTrace((GuardrailTrace)((GuardrailTrace.Builder)GuardrailTrace.builder().applyMutation(guardrailTrace)).build());
        }

        public Builder orchestrationTrace(OrchestrationTrace var1);

        default public Builder orchestrationTrace(Consumer<OrchestrationTrace.Builder> orchestrationTrace) {
            return this.orchestrationTrace((OrchestrationTrace)((OrchestrationTrace.Builder)OrchestrationTrace.builder().applyMutation(orchestrationTrace)).build());
        }

        public Builder postProcessingTrace(PostProcessingTrace var1);

        default public Builder postProcessingTrace(Consumer<PostProcessingTrace.Builder> postProcessingTrace) {
            return this.postProcessingTrace((PostProcessingTrace)((PostProcessingTrace.Builder)PostProcessingTrace.builder().applyMutation(postProcessingTrace)).build());
        }

        public Builder preProcessingTrace(PreProcessingTrace var1);

        default public Builder preProcessingTrace(Consumer<PreProcessingTrace.Builder> preProcessingTrace) {
            return this.preProcessingTrace((PreProcessingTrace)((PreProcessingTrace.Builder)PreProcessingTrace.builder().applyMutation(preProcessingTrace)).build());
        }
    }
}

