/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagentruntime.model.Attribution;
import software.amazon.awssdk.services.bedrockagentruntime.model.InvokeAgentResponseHandler;
import software.amazon.awssdk.services.bedrockagentruntime.model.ResponseStream;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PayloadPart
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PayloadPart>,
ResponseStream {
    private static final SdkField<Attribution> ATTRIBUTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("attribution").getter(PayloadPart.getter(PayloadPart::attribution)).setter(PayloadPart.setter(Builder::attribution)).constructor(Attribution::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attribution").build()}).build();
    private static final SdkField<SdkBytes> BYTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).memberName("bytes").getter(PayloadPart.getter(PayloadPart::bytes)).setter(PayloadPart.setter(Builder::bytes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bytes").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTION_FIELD, BYTES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("attribution", ATTRIBUTION_FIELD);
            this.put("bytes", BYTES_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Attribution attribution;
    private final SdkBytes bytes;

    protected PayloadPart(BuilderImpl builder) {
        this.attribution = builder.attribution;
        this.bytes = builder.bytes;
    }

    public final Attribution attribution() {
        return this.attribution;
    }

    public final SdkBytes bytes() {
        return this.bytes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.attribution());
        hashCode = 31 * hashCode + Objects.hashCode(this.bytes());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PayloadPart)) {
            return false;
        }
        PayloadPart other = (PayloadPart)obj;
        return Objects.equals(this.attribution(), other.attribution()) && Objects.equals(this.bytes(), other.bytes());
    }

    public final String toString() {
        return ToString.builder((String)"PayloadPart").add("Attribution", (Object)this.attribution()).add("Bytes", (Object)(this.bytes() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "attribution": {
                return Optional.ofNullable(clazz.cast(this.attribution()));
            }
            case "bytes": {
                return Optional.ofNullable(clazz.cast(this.bytes()));
            }
        }
        return Optional.empty();
    }

    public final PayloadPart copy(Consumer<? super Builder> modifier) {
        return (PayloadPart)super.copy(modifier);
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<PayloadPart, T> g) {
        return obj -> g.apply((PayloadPart)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    @Override
    public void accept(InvokeAgentResponseHandler.Visitor visitor) {
        throw new UnsupportedOperationException();
    }

    protected static class BuilderImpl
    implements Builder {
        private Attribution attribution;
        private SdkBytes bytes;

        protected BuilderImpl() {
        }

        protected BuilderImpl(PayloadPart model) {
            this.attribution(model.attribution);
            this.bytes(model.bytes);
        }

        public final Attribution.Builder getAttribution() {
            return this.attribution != null ? this.attribution.toBuilder() : null;
        }

        public final void setAttribution(Attribution.BuilderImpl attribution) {
            this.attribution = attribution != null ? attribution.build() : null;
        }

        @Override
        public final Builder attribution(Attribution attribution) {
            this.attribution = attribution;
            return this;
        }

        public final ByteBuffer getBytes() {
            return this.bytes == null ? null : this.bytes.asByteBuffer();
        }

        public final void setBytes(ByteBuffer bytes) {
            this.bytes(bytes == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)bytes));
        }

        @Override
        public final Builder bytes(SdkBytes bytes) {
            this.bytes = bytes;
            return this;
        }

        public PayloadPart build() {
            return new PayloadPart(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PayloadPart> {
        public Builder attribution(Attribution var1);

        default public Builder attribution(Consumer<Attribution.Builder> attribution) {
            return this.attribution((Attribution)((Attribution.Builder)Attribution.builder().applyMutation(attribution)).build());
        }

        public Builder bytes(SdkBytes var1);
    }
}

