/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagentruntime.model.ByteContentFile;
import software.amazon.awssdk.services.bedrockagentruntime.model.FileSourceType;
import software.amazon.awssdk.services.bedrockagentruntime.model.S3ObjectFile;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FileSource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FileSource> {
    private static final SdkField<ByteContentFile> BYTE_CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("byteContent").getter(FileSource.getter(FileSource::byteContent)).setter(FileSource.setter(Builder::byteContent)).constructor(ByteContentFile::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("byteContent").build()}).build();
    private static final SdkField<S3ObjectFile> S3_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("s3Location").getter(FileSource.getter(FileSource::s3Location)).setter(FileSource.setter(Builder::s3Location)).constructor(S3ObjectFile::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Location").build()}).build();
    private static final SdkField<String> SOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourceType").getter(FileSource.getter(FileSource::sourceTypeAsString)).setter(FileSource.setter(Builder::sourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BYTE_CONTENT_FIELD, S3_LOCATION_FIELD, SOURCE_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("byteContent", BYTE_CONTENT_FIELD);
            this.put("s3Location", S3_LOCATION_FIELD);
            this.put("sourceType", SOURCE_TYPE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final ByteContentFile byteContent;
    private final S3ObjectFile s3Location;
    private final String sourceType;

    private FileSource(BuilderImpl builder) {
        this.byteContent = builder.byteContent;
        this.s3Location = builder.s3Location;
        this.sourceType = builder.sourceType;
    }

    public final ByteContentFile byteContent() {
        return this.byteContent;
    }

    public final S3ObjectFile s3Location() {
        return this.s3Location;
    }

    public final FileSourceType sourceType() {
        return FileSourceType.fromValue(this.sourceType);
    }

    public final String sourceTypeAsString() {
        return this.sourceType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.byteContent());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Location());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FileSource)) {
            return false;
        }
        FileSource other = (FileSource)obj;
        return Objects.equals(this.byteContent(), other.byteContent()) && Objects.equals(this.s3Location(), other.s3Location()) && Objects.equals(this.sourceTypeAsString(), other.sourceTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"FileSource").add("ByteContent", (Object)this.byteContent()).add("S3Location", (Object)this.s3Location()).add("SourceType", (Object)this.sourceTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "byteContent": {
                return Optional.ofNullable(clazz.cast(this.byteContent()));
            }
            case "s3Location": {
                return Optional.ofNullable(clazz.cast(this.s3Location()));
            }
            case "sourceType": {
                return Optional.ofNullable(clazz.cast(this.sourceTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<FileSource, T> g) {
        return obj -> g.apply((FileSource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ByteContentFile byteContent;
        private S3ObjectFile s3Location;
        private String sourceType;

        private BuilderImpl() {
        }

        private BuilderImpl(FileSource model) {
            this.byteContent(model.byteContent);
            this.s3Location(model.s3Location);
            this.sourceType(model.sourceType);
        }

        public final ByteContentFile.Builder getByteContent() {
            return this.byteContent != null ? this.byteContent.toBuilder() : null;
        }

        public final void setByteContent(ByteContentFile.BuilderImpl byteContent) {
            this.byteContent = byteContent != null ? byteContent.build() : null;
        }

        @Override
        public final Builder byteContent(ByteContentFile byteContent) {
            this.byteContent = byteContent;
            return this;
        }

        public final S3ObjectFile.Builder getS3Location() {
            return this.s3Location != null ? this.s3Location.toBuilder() : null;
        }

        public final void setS3Location(S3ObjectFile.BuilderImpl s3Location) {
            this.s3Location = s3Location != null ? s3Location.build() : null;
        }

        @Override
        public final Builder s3Location(S3ObjectFile s3Location) {
            this.s3Location = s3Location;
            return this;
        }

        public final String getSourceType() {
            return this.sourceType;
        }

        public final void setSourceType(String sourceType) {
            this.sourceType = sourceType;
        }

        @Override
        public final Builder sourceType(String sourceType) {
            this.sourceType = sourceType;
            return this;
        }

        @Override
        public final Builder sourceType(FileSourceType sourceType) {
            this.sourceType(sourceType == null ? null : sourceType.toString());
            return this;
        }

        public FileSource build() {
            return new FileSource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FileSource> {
        public Builder byteContent(ByteContentFile var1);

        default public Builder byteContent(Consumer<ByteContentFile.Builder> byteContent) {
            return this.byteContent((ByteContentFile)((ByteContentFile.Builder)ByteContentFile.builder().applyMutation(byteContent)).build());
        }

        public Builder s3Location(S3ObjectFile var1);

        default public Builder s3Location(Consumer<S3ObjectFile.Builder> s3Location) {
            return this.s3Location((S3ObjectFile)((S3ObjectFile.Builder)S3ObjectFile.builder().applyMutation(s3Location)).build());
        }

        public Builder sourceType(String var1);

        public Builder sourceType(FileSourceType var1);
    }
}

