/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RetrieveAndGenerateResponse extends BedrockAgentRuntimeResponse implements
        ToCopyableBuilder<RetrieveAndGenerateResponse.Builder, RetrieveAndGenerateResponse> {
    private static final SdkField<List<Citation>> CITATIONS_FIELD = SdkField
            .<List<Citation>> builder(MarshallingType.LIST)
            .memberName("citations")
            .getter(getter(RetrieveAndGenerateResponse::citations))
            .setter(setter(Builder::citations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("citations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Citation> builder(MarshallingType.SDK_POJO)
                                            .constructor(Citation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> GUARDRAIL_ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("guardrailAction").getter(getter(RetrieveAndGenerateResponse::guardrailActionAsString))
            .setter(setter(Builder::guardrailAction))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("guardrailAction").build()).build();

    private static final SdkField<RetrieveAndGenerateOutput> OUTPUT_FIELD = SdkField
            .<RetrieveAndGenerateOutput> builder(MarshallingType.SDK_POJO).memberName("output")
            .getter(getter(RetrieveAndGenerateResponse::output)).setter(setter(Builder::output))
            .constructor(RetrieveAndGenerateOutput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("output").build()).build();

    private static final SdkField<String> SESSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sessionId").getter(getter(RetrieveAndGenerateResponse::sessionId)).setter(setter(Builder::sessionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CITATIONS_FIELD,
            GUARDRAIL_ACTION_FIELD, OUTPUT_FIELD, SESSION_ID_FIELD));

    private final List<Citation> citations;

    private final String guardrailAction;

    private final RetrieveAndGenerateOutput output;

    private final String sessionId;

    private RetrieveAndGenerateResponse(BuilderImpl builder) {
        super(builder);
        this.citations = builder.citations;
        this.guardrailAction = builder.guardrailAction;
        this.output = builder.output;
        this.sessionId = builder.sessionId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Citations property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasCitations() {
        return citations != null && !(citations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of segments of the generated response that are based on sources in the knowledge base, alongside
     * information about the sources.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCitations} method.
     * </p>
     * 
     * @return A list of segments of the generated response that are based on sources in the knowledge base, alongside
     *         information about the sources.
     */
    public final List<Citation> citations() {
        return citations;
    }

    /**
     * <p>
     * Specifies if there is a guardrail intervention in the response.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #guardrailAction}
     * will return {@link GuadrailAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #guardrailActionAsString}.
     * </p>
     * 
     * @return Specifies if there is a guardrail intervention in the response.
     * @see GuadrailAction
     */
    public final GuadrailAction guardrailAction() {
        return GuadrailAction.fromValue(guardrailAction);
    }

    /**
     * <p>
     * Specifies if there is a guardrail intervention in the response.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #guardrailAction}
     * will return {@link GuadrailAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #guardrailActionAsString}.
     * </p>
     * 
     * @return Specifies if there is a guardrail intervention in the response.
     * @see GuadrailAction
     */
    public final String guardrailActionAsString() {
        return guardrailAction;
    }

    /**
     * <p>
     * Contains the response generated from querying the knowledge base.
     * </p>
     * 
     * @return Contains the response generated from querying the knowledge base.
     */
    public final RetrieveAndGenerateOutput output() {
        return output;
    }

    /**
     * <p>
     * The unique identifier of the session. When you first make a <code>RetrieveAndGenerate</code> request, Amazon
     * Bedrock automatically generates this value. You must reuse this value for all subsequent requests in the same
     * conversational session. This value allows Amazon Bedrock to maintain context and knowledge from previous
     * interactions. You can't explicitly set the <code>sessionId</code> yourself.
     * </p>
     * 
     * @return The unique identifier of the session. When you first make a <code>RetrieveAndGenerate</code> request,
     *         Amazon Bedrock automatically generates this value. You must reuse this value for all subsequent requests
     *         in the same conversational session. This value allows Amazon Bedrock to maintain context and knowledge
     *         from previous interactions. You can't explicitly set the <code>sessionId</code> yourself.
     */
    public final String sessionId() {
        return sessionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasCitations() ? citations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(guardrailActionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(output());
        hashCode = 31 * hashCode + Objects.hashCode(sessionId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RetrieveAndGenerateResponse)) {
            return false;
        }
        RetrieveAndGenerateResponse other = (RetrieveAndGenerateResponse) obj;
        return hasCitations() == other.hasCitations() && Objects.equals(citations(), other.citations())
                && Objects.equals(guardrailActionAsString(), other.guardrailActionAsString())
                && Objects.equals(output(), other.output()) && Objects.equals(sessionId(), other.sessionId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RetrieveAndGenerateResponse").add("Citations", hasCitations() ? citations() : null)
                .add("GuardrailAction", guardrailActionAsString())
                .add("Output", output() == null ? null : "*** Sensitive Data Redacted ***").add("SessionId", sessionId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "citations":
            return Optional.ofNullable(clazz.cast(citations()));
        case "guardrailAction":
            return Optional.ofNullable(clazz.cast(guardrailActionAsString()));
        case "output":
            return Optional.ofNullable(clazz.cast(output()));
        case "sessionId":
            return Optional.ofNullable(clazz.cast(sessionId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RetrieveAndGenerateResponse, T> g) {
        return obj -> g.apply((RetrieveAndGenerateResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BedrockAgentRuntimeResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, RetrieveAndGenerateResponse> {
        /**
         * <p>
         * A list of segments of the generated response that are based on sources in the knowledge base, alongside
         * information about the sources.
         * </p>
         * 
         * @param citations
         *        A list of segments of the generated response that are based on sources in the knowledge base,
         *        alongside information about the sources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder citations(Collection<Citation> citations);

        /**
         * <p>
         * A list of segments of the generated response that are based on sources in the knowledge base, alongside
         * information about the sources.
         * </p>
         * 
         * @param citations
         *        A list of segments of the generated response that are based on sources in the knowledge base,
         *        alongside information about the sources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder citations(Citation... citations);

        /**
         * <p>
         * A list of segments of the generated response that are based on sources in the knowledge base, alongside
         * information about the sources.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrockagentruntime.model.Citation.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.bedrockagentruntime.model.Citation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrockagentruntime.model.Citation.Builder#build()} is called
         * immediately and its result is passed to {@link #citations(List<Citation>)}.
         * 
         * @param citations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrockagentruntime.model.Citation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #citations(java.util.Collection<Citation>)
         */
        Builder citations(Consumer<Citation.Builder>... citations);

        /**
         * <p>
         * Specifies if there is a guardrail intervention in the response.
         * </p>
         * 
         * @param guardrailAction
         *        Specifies if there is a guardrail intervention in the response.
         * @see GuadrailAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GuadrailAction
         */
        Builder guardrailAction(String guardrailAction);

        /**
         * <p>
         * Specifies if there is a guardrail intervention in the response.
         * </p>
         * 
         * @param guardrailAction
         *        Specifies if there is a guardrail intervention in the response.
         * @see GuadrailAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GuadrailAction
         */
        Builder guardrailAction(GuadrailAction guardrailAction);

        /**
         * <p>
         * Contains the response generated from querying the knowledge base.
         * </p>
         * 
         * @param output
         *        Contains the response generated from querying the knowledge base.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder output(RetrieveAndGenerateOutput output);

        /**
         * <p>
         * Contains the response generated from querying the knowledge base.
         * </p>
         * This is a convenience method that creates an instance of the {@link RetrieveAndGenerateOutput.Builder}
         * avoiding the need to create one manually via {@link RetrieveAndGenerateOutput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RetrieveAndGenerateOutput.Builder#build()} is called immediately
         * and its result is passed to {@link #output(RetrieveAndGenerateOutput)}.
         * 
         * @param output
         *        a consumer that will call methods on {@link RetrieveAndGenerateOutput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #output(RetrieveAndGenerateOutput)
         */
        default Builder output(Consumer<RetrieveAndGenerateOutput.Builder> output) {
            return output(RetrieveAndGenerateOutput.builder().applyMutation(output).build());
        }

        /**
         * <p>
         * The unique identifier of the session. When you first make a <code>RetrieveAndGenerate</code> request, Amazon
         * Bedrock automatically generates this value. You must reuse this value for all subsequent requests in the same
         * conversational session. This value allows Amazon Bedrock to maintain context and knowledge from previous
         * interactions. You can't explicitly set the <code>sessionId</code> yourself.
         * </p>
         * 
         * @param sessionId
         *        The unique identifier of the session. When you first make a <code>RetrieveAndGenerate</code> request,
         *        Amazon Bedrock automatically generates this value. You must reuse this value for all subsequent
         *        requests in the same conversational session. This value allows Amazon Bedrock to maintain context and
         *        knowledge from previous interactions. You can't explicitly set the <code>sessionId</code> yourself.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionId(String sessionId);
    }

    static final class BuilderImpl extends BedrockAgentRuntimeResponse.BuilderImpl implements Builder {
        private List<Citation> citations = DefaultSdkAutoConstructList.getInstance();

        private String guardrailAction;

        private RetrieveAndGenerateOutput output;

        private String sessionId;

        private BuilderImpl() {
        }

        private BuilderImpl(RetrieveAndGenerateResponse model) {
            super(model);
            citations(model.citations);
            guardrailAction(model.guardrailAction);
            output(model.output);
            sessionId(model.sessionId);
        }

        public final List<Citation.Builder> getCitations() {
            List<Citation.Builder> result = CitationsCopier.copyToBuilder(this.citations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCitations(Collection<Citation.BuilderImpl> citations) {
            this.citations = CitationsCopier.copyFromBuilder(citations);
        }

        @Override
        public final Builder citations(Collection<Citation> citations) {
            this.citations = CitationsCopier.copy(citations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder citations(Citation... citations) {
            citations(Arrays.asList(citations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder citations(Consumer<Citation.Builder>... citations) {
            citations(Stream.of(citations).map(c -> Citation.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getGuardrailAction() {
            return guardrailAction;
        }

        public final void setGuardrailAction(String guardrailAction) {
            this.guardrailAction = guardrailAction;
        }

        @Override
        public final Builder guardrailAction(String guardrailAction) {
            this.guardrailAction = guardrailAction;
            return this;
        }

        @Override
        public final Builder guardrailAction(GuadrailAction guardrailAction) {
            this.guardrailAction(guardrailAction == null ? null : guardrailAction.toString());
            return this;
        }

        public final RetrieveAndGenerateOutput.Builder getOutput() {
            return output != null ? output.toBuilder() : null;
        }

        public final void setOutput(RetrieveAndGenerateOutput.BuilderImpl output) {
            this.output = output != null ? output.build() : null;
        }

        @Override
        public final Builder output(RetrieveAndGenerateOutput output) {
            this.output = output;
            return this;
        }

        public final String getSessionId() {
            return sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        @Override
        public RetrieveAndGenerateResponse build() {
            return new RetrieveAndGenerateResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
