/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The foundation model output from the orchestration step.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OrchestrationModelInvocationOutput implements SdkPojo, Serializable,
        ToCopyableBuilder<OrchestrationModelInvocationOutput.Builder, OrchestrationModelInvocationOutput> {
    private static final SdkField<Metadata> METADATA_FIELD = SdkField.<Metadata> builder(MarshallingType.SDK_POJO)
            .memberName("metadata").getter(getter(OrchestrationModelInvocationOutput::metadata))
            .setter(setter(Builder::metadata)).constructor(Metadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadata").build()).build();

    private static final SdkField<RawResponse> RAW_RESPONSE_FIELD = SdkField.<RawResponse> builder(MarshallingType.SDK_POJO)
            .memberName("rawResponse").getter(getter(OrchestrationModelInvocationOutput::rawResponse))
            .setter(setter(Builder::rawResponse)).constructor(RawResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rawResponse").build()).build();

    private static final SdkField<String> TRACE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("traceId").getter(getter(OrchestrationModelInvocationOutput::traceId)).setter(setter(Builder::traceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("traceId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METADATA_FIELD,
            RAW_RESPONSE_FIELD, TRACE_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final Metadata metadata;

    private final RawResponse rawResponse;

    private final String traceId;

    private OrchestrationModelInvocationOutput(BuilderImpl builder) {
        this.metadata = builder.metadata;
        this.rawResponse = builder.rawResponse;
        this.traceId = builder.traceId;
    }

    /**
     * <p>
     * Contains information about the foundation model output from the orchestration step.
     * </p>
     * 
     * @return Contains information about the foundation model output from the orchestration step.
     */
    public final Metadata metadata() {
        return metadata;
    }

    /**
     * <p>
     * Contains details of the raw response from the foundation model output.
     * </p>
     * 
     * @return Contains details of the raw response from the foundation model output.
     */
    public final RawResponse rawResponse() {
        return rawResponse;
    }

    /**
     * <p>
     * The unique identifier of the trace.
     * </p>
     * 
     * @return The unique identifier of the trace.
     */
    public final String traceId() {
        return traceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(metadata());
        hashCode = 31 * hashCode + Objects.hashCode(rawResponse());
        hashCode = 31 * hashCode + Objects.hashCode(traceId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OrchestrationModelInvocationOutput)) {
            return false;
        }
        OrchestrationModelInvocationOutput other = (OrchestrationModelInvocationOutput) obj;
        return Objects.equals(metadata(), other.metadata()) && Objects.equals(rawResponse(), other.rawResponse())
                && Objects.equals(traceId(), other.traceId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OrchestrationModelInvocationOutput")
                .add("Metadata", metadata() == null ? null : "*** Sensitive Data Redacted ***")
                .add("RawResponse", rawResponse() == null ? null : "*** Sensitive Data Redacted ***").add("TraceId", traceId())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "metadata":
            return Optional.ofNullable(clazz.cast(metadata()));
        case "rawResponse":
            return Optional.ofNullable(clazz.cast(rawResponse()));
        case "traceId":
            return Optional.ofNullable(clazz.cast(traceId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OrchestrationModelInvocationOutput, T> g) {
        return obj -> g.apply((OrchestrationModelInvocationOutput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OrchestrationModelInvocationOutput> {
        /**
         * <p>
         * Contains information about the foundation model output from the orchestration step.
         * </p>
         * 
         * @param metadata
         *        Contains information about the foundation model output from the orchestration step.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadata(Metadata metadata);

        /**
         * <p>
         * Contains information about the foundation model output from the orchestration step.
         * </p>
         * This is a convenience method that creates an instance of the {@link Metadata.Builder} avoiding the need to
         * create one manually via {@link Metadata#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Metadata.Builder#build()} is called immediately and its result is
         * passed to {@link #metadata(Metadata)}.
         * 
         * @param metadata
         *        a consumer that will call methods on {@link Metadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metadata(Metadata)
         */
        default Builder metadata(Consumer<Metadata.Builder> metadata) {
            return metadata(Metadata.builder().applyMutation(metadata).build());
        }

        /**
         * <p>
         * Contains details of the raw response from the foundation model output.
         * </p>
         * 
         * @param rawResponse
         *        Contains details of the raw response from the foundation model output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rawResponse(RawResponse rawResponse);

        /**
         * <p>
         * Contains details of the raw response from the foundation model output.
         * </p>
         * This is a convenience method that creates an instance of the {@link RawResponse.Builder} avoiding the need to
         * create one manually via {@link RawResponse#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RawResponse.Builder#build()} is called immediately and its result
         * is passed to {@link #rawResponse(RawResponse)}.
         * 
         * @param rawResponse
         *        a consumer that will call methods on {@link RawResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rawResponse(RawResponse)
         */
        default Builder rawResponse(Consumer<RawResponse.Builder> rawResponse) {
            return rawResponse(RawResponse.builder().applyMutation(rawResponse).build());
        }

        /**
         * <p>
         * The unique identifier of the trace.
         * </p>
         * 
         * @param traceId
         *        The unique identifier of the trace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder traceId(String traceId);
    }

    static final class BuilderImpl implements Builder {
        private Metadata metadata;

        private RawResponse rawResponse;

        private String traceId;

        private BuilderImpl() {
        }

        private BuilderImpl(OrchestrationModelInvocationOutput model) {
            metadata(model.metadata);
            rawResponse(model.rawResponse);
            traceId(model.traceId);
        }

        public final Metadata.Builder getMetadata() {
            return metadata != null ? metadata.toBuilder() : null;
        }

        public final void setMetadata(Metadata.BuilderImpl metadata) {
            this.metadata = metadata != null ? metadata.build() : null;
        }

        @Override
        public final Builder metadata(Metadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public final RawResponse.Builder getRawResponse() {
            return rawResponse != null ? rawResponse.toBuilder() : null;
        }

        public final void setRawResponse(RawResponse.BuilderImpl rawResponse) {
            this.rawResponse = rawResponse != null ? rawResponse.build() : null;
        }

        @Override
        public final Builder rawResponse(RawResponse rawResponse) {
            this.rawResponse = rawResponse;
            return this;
        }

        public final String getTraceId() {
            return traceId;
        }

        public final void setTraceId(String traceId) {
            this.traceId = traceId;
        }

        @Override
        public final Builder traceId(String traceId) {
            this.traceId = traceId;
            return this;
        }

        @Override
        public OrchestrationModelInvocationOutput build() {
            return new OrchestrationModelInvocationOutput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
