/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;

@Generated("software.amazon.awssdk:codegen")
final class ContentMapCopier {
    static Map<String, List<Parameter>> copy(Map<String, ? extends Collection<? extends Parameter>> contentMapParam) {
        Map<String, List<Parameter>> map;
        if (contentMapParam == null || contentMapParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, List<Parameter>> modifiableMap = new LinkedHashMap<>(contentMapParam.size());
            contentMapParam.forEach((key, value) -> {
                List<Parameter> list;
                if (value == null || value instanceof SdkAutoConstructList) {
                    list = DefaultSdkAutoConstructList.getInstance();
                } else {
                    List<Parameter> modifiableList = new ArrayList<>(value.size());
                    value.forEach(entry -> {
                        modifiableList.add(entry);
                    });
                    list = Collections.unmodifiableList(modifiableList);
                }
                modifiableMap.put(key, list);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<String, List<Parameter>> copyFromBuilder(
            Map<String, ? extends Collection<? extends Parameter.Builder>> contentMapParam) {
        Map<String, List<Parameter>> map;
        if (contentMapParam == null || contentMapParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, List<Parameter>> modifiableMap = new LinkedHashMap<>(contentMapParam.size());
            contentMapParam.forEach((key, value) -> {
                List<Parameter> list;
                if (value == null || value instanceof SdkAutoConstructList) {
                    list = DefaultSdkAutoConstructList.getInstance();
                } else {
                    List<Parameter> modifiableList = new ArrayList<>(value.size());
                    value.forEach(entry -> {
                        Parameter member = entry == null ? null : entry.build();
                        modifiableList.add(member);
                    });
                    list = Collections.unmodifiableList(modifiableList);
                }
                modifiableMap.put(key, list);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<String, List<Parameter.Builder>> copyToBuilder(
            Map<String, ? extends Collection<? extends Parameter>> contentMapParam) {
        Map<String, List<Parameter.Builder>> map;
        if (contentMapParam == null || contentMapParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, List<Parameter.Builder>> modifiableMap = new LinkedHashMap<>(contentMapParam.size());
            contentMapParam.forEach((key, value) -> {
                List<Parameter.Builder> list;
                if (value == null || value instanceof SdkAutoConstructList) {
                    list = DefaultSdkAutoConstructList.getInstance();
                } else {
                    List<Parameter.Builder> modifiableList = new ArrayList<>(value.size());
                    value.forEach(entry -> {
                        Parameter.Builder member = entry == null ? null : entry.toBuilder();
                        modifiableList.add(member);
                    });
                    list = Collections.unmodifiableList(modifiableList);
                }
                modifiableMap.put(key, list);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }
}
