/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.bedrock.BedrockAsyncClient;
import software.amazon.awssdk.services.bedrock.internal.UserAgentUtils;
import software.amazon.awssdk.services.bedrock.model.ListMarketplaceModelEndpointsRequest;
import software.amazon.awssdk.services.bedrock.model.ListMarketplaceModelEndpointsResponse;
import software.amazon.awssdk.services.bedrock.model.MarketplaceModelEndpointSummary;

public class ListMarketplaceModelEndpointsPublisher
implements SdkPublisher<ListMarketplaceModelEndpointsResponse> {
    private final BedrockAsyncClient client;
    private final ListMarketplaceModelEndpointsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListMarketplaceModelEndpointsPublisher(BedrockAsyncClient client, ListMarketplaceModelEndpointsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListMarketplaceModelEndpointsPublisher(BedrockAsyncClient client, ListMarketplaceModelEndpointsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListMarketplaceModelEndpointsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListMarketplaceModelEndpointsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<MarketplaceModelEndpointSummary> marketplaceModelEndpoints() {
        Function<ListMarketplaceModelEndpointsResponse, Iterator> getIterator = response -> {
            if (response != null && response.marketplaceModelEndpoints() != null) {
                return response.marketplaceModelEndpoints().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListMarketplaceModelEndpointsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListMarketplaceModelEndpointsResponseFetcher
    implements AsyncPageFetcher<ListMarketplaceModelEndpointsResponse> {
        private ListMarketplaceModelEndpointsResponseFetcher() {
        }

        public boolean hasNextPage(ListMarketplaceModelEndpointsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListMarketplaceModelEndpointsResponse> nextPage(ListMarketplaceModelEndpointsResponse previousPage) {
            if (previousPage == null) {
                return ListMarketplaceModelEndpointsPublisher.this.client.listMarketplaceModelEndpoints(ListMarketplaceModelEndpointsPublisher.this.firstRequest);
            }
            return ListMarketplaceModelEndpointsPublisher.this.client.listMarketplaceModelEndpoints((ListMarketplaceModelEndpointsRequest)((Object)ListMarketplaceModelEndpointsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

