/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.bedrock.model.RequestMetadataMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RequestMetadataBaseFilters
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RequestMetadataBaseFilters> {
    private static final SdkField<Map<String, String>> EQUALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("equals").getter(RequestMetadataBaseFilters.getter(RequestMetadataBaseFilters::equalsValue)).setter(RequestMetadataBaseFilters.setter(Builder::equalsValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("equals").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> NOT_EQUALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("notEquals").getter(RequestMetadataBaseFilters.getter(RequestMetadataBaseFilters::notEquals)).setter(RequestMetadataBaseFilters.setter(Builder::notEquals)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("notEquals").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EQUALS_FIELD, NOT_EQUALS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RequestMetadataBaseFilters.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Map<String, String> equalsValue;
    private final Map<String, String> notEquals;

    private RequestMetadataBaseFilters(BuilderImpl builder) {
        this.equalsValue = builder.equalsValue;
        this.notEquals = builder.notEquals;
    }

    public final boolean hasEqualsValue() {
        return this.equalsValue != null && !(this.equalsValue instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> equalsValue() {
        return this.equalsValue;
    }

    public final boolean hasNotEquals() {
        return this.notEquals != null && !(this.notEquals instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> notEquals() {
        return this.notEquals;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEqualsValue() ? this.equalsValue() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNotEquals() ? this.notEquals() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RequestMetadataBaseFilters)) {
            return false;
        }
        RequestMetadataBaseFilters other = (RequestMetadataBaseFilters)obj;
        return this.hasEqualsValue() == other.hasEqualsValue() && Objects.equals(this.equalsValue(), other.equalsValue()) && this.hasNotEquals() == other.hasNotEquals() && Objects.equals(this.notEquals(), other.notEquals());
    }

    public final String toString() {
        return ToString.builder((String)"RequestMetadataBaseFilters").add("Equals", (Object)(this.equalsValue() == null ? null : "*** Sensitive Data Redacted ***")).add("NotEquals", (Object)(this.notEquals() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "equals": {
                return Optional.ofNullable(clazz.cast(this.equalsValue()));
            }
            case "notEquals": {
                return Optional.ofNullable(clazz.cast(this.notEquals()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Map<String, String>>> map = new HashMap<String, SdkField<Map<String, String>>>();
        map.put("equals", EQUALS_FIELD);
        map.put("notEquals", NOT_EQUALS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RequestMetadataBaseFilters, T> g) {
        return obj -> g.apply((RequestMetadataBaseFilters)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Map<String, String> equalsValue = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, String> notEquals = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RequestMetadataBaseFilters model) {
            this.equalsValue(model.equalsValue);
            this.notEquals(model.notEquals);
        }

        public final Map<String, String> getEqualsValue() {
            if (this.equalsValue instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.equalsValue;
        }

        public final void setEqualsValue(Map<String, String> equalsValue) {
            this.equalsValue = RequestMetadataMapCopier.copy(equalsValue);
        }

        @Override
        public final Builder equalsValue(Map<String, String> equalsValue) {
            this.equalsValue = RequestMetadataMapCopier.copy(equalsValue);
            return this;
        }

        public final Map<String, String> getNotEquals() {
            if (this.notEquals instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.notEquals;
        }

        public final void setNotEquals(Map<String, String> notEquals) {
            this.notEquals = RequestMetadataMapCopier.copy(notEquals);
        }

        @Override
        public final Builder notEquals(Map<String, String> notEquals) {
            this.notEquals = RequestMetadataMapCopier.copy(notEquals);
            return this;
        }

        public RequestMetadataBaseFilters build() {
            return new RequestMetadataBaseFilters(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RequestMetadataBaseFilters> {
        public Builder equalsValue(Map<String, String> var1);

        public Builder notEquals(Map<String, String> var1);
    }
}

