/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.bedrock.BedrockClient;
import software.amazon.awssdk.services.bedrock.internal.UserAgentUtils;
import software.amazon.awssdk.services.bedrock.model.EvaluationSummary;
import software.amazon.awssdk.services.bedrock.model.ListEvaluationJobsRequest;
import software.amazon.awssdk.services.bedrock.model.ListEvaluationJobsResponse;

public class ListEvaluationJobsIterable
implements SdkIterable<ListEvaluationJobsResponse> {
    private final BedrockClient client;
    private final ListEvaluationJobsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListEvaluationJobsIterable(BedrockClient client, ListEvaluationJobsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListEvaluationJobsResponseFetcher();
    }

    public Iterator<ListEvaluationJobsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<EvaluationSummary> jobSummaries() {
        Function<ListEvaluationJobsResponse, Iterator> getIterator = response -> {
            if (response != null && response.jobSummaries() != null) {
                return response.jobSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListEvaluationJobsResponseFetcher
    implements SyncPageFetcher<ListEvaluationJobsResponse> {
        private ListEvaluationJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListEvaluationJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListEvaluationJobsResponse nextPage(ListEvaluationJobsResponse previousPage) {
            if (previousPage == null) {
                return ListEvaluationJobsIterable.this.client.listEvaluationJobs(ListEvaluationJobsIterable.this.firstRequest);
            }
            return ListEvaluationJobsIterable.this.client.listEvaluationJobs((ListEvaluationJobsRequest)((Object)ListEvaluationJobsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

