/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListCustomModelsRequest extends BedrockRequest implements
        ToCopyableBuilder<ListCustomModelsRequest.Builder, ListCustomModelsRequest> {
    private static final SdkField<Instant> CREATION_TIME_BEFORE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationTimeBefore")
            .getter(getter(ListCustomModelsRequest::creationTimeBefore))
            .setter(setter(Builder::creationTimeBefore))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("creationTimeBefore").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> CREATION_TIME_AFTER_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationTimeAfter")
            .getter(getter(ListCustomModelsRequest::creationTimeAfter))
            .setter(setter(Builder::creationTimeAfter))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("creationTimeAfter").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> NAME_CONTAINS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nameContains").getter(getter(ListCustomModelsRequest::nameContains))
            .setter(setter(Builder::nameContains))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nameContains").build()).build();

    private static final SdkField<String> BASE_MODEL_ARN_EQUALS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("baseModelArnEquals").getter(getter(ListCustomModelsRequest::baseModelArnEquals))
            .setter(setter(Builder::baseModelArnEquals))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("baseModelArnEquals").build())
            .build();

    private static final SdkField<String> FOUNDATION_MODEL_ARN_EQUALS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("foundationModelArnEquals")
            .getter(getter(ListCustomModelsRequest::foundationModelArnEquals))
            .setter(setter(Builder::foundationModelArnEquals))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("foundationModelArnEquals")
                    .build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListCustomModelsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListCustomModelsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final SdkField<String> SORT_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("sortBy")
            .getter(getter(ListCustomModelsRequest::sortByAsString)).setter(setter(Builder::sortBy))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("sortBy").build()).build();

    private static final SdkField<String> SORT_ORDER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sortOrder").getter(getter(ListCustomModelsRequest::sortOrderAsString))
            .setter(setter(Builder::sortOrder))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("sortOrder").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATION_TIME_BEFORE_FIELD,
            CREATION_TIME_AFTER_FIELD, NAME_CONTAINS_FIELD, BASE_MODEL_ARN_EQUALS_FIELD, FOUNDATION_MODEL_ARN_EQUALS_FIELD,
            MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, SORT_BY_FIELD, SORT_ORDER_FIELD));

    private final Instant creationTimeBefore;

    private final Instant creationTimeAfter;

    private final String nameContains;

    private final String baseModelArnEquals;

    private final String foundationModelArnEquals;

    private final Integer maxResults;

    private final String nextToken;

    private final String sortBy;

    private final String sortOrder;

    private ListCustomModelsRequest(BuilderImpl builder) {
        super(builder);
        this.creationTimeBefore = builder.creationTimeBefore;
        this.creationTimeAfter = builder.creationTimeAfter;
        this.nameContains = builder.nameContains;
        this.baseModelArnEquals = builder.baseModelArnEquals;
        this.foundationModelArnEquals = builder.foundationModelArnEquals;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.sortBy = builder.sortBy;
        this.sortOrder = builder.sortOrder;
    }

    /**
     * <p>
     * Return custom models created before the specified time.
     * </p>
     * 
     * @return Return custom models created before the specified time.
     */
    public final Instant creationTimeBefore() {
        return creationTimeBefore;
    }

    /**
     * <p>
     * Return custom models created after the specified time.
     * </p>
     * 
     * @return Return custom models created after the specified time.
     */
    public final Instant creationTimeAfter() {
        return creationTimeAfter;
    }

    /**
     * <p>
     * Return custom models only if the job name contains these characters.
     * </p>
     * 
     * @return Return custom models only if the job name contains these characters.
     */
    public final String nameContains() {
        return nameContains;
    }

    /**
     * <p>
     * Return custom models only if the base model ARN matches this parameter.
     * </p>
     * 
     * @return Return custom models only if the base model ARN matches this parameter.
     */
    public final String baseModelArnEquals() {
        return baseModelArnEquals;
    }

    /**
     * <p>
     * Return custom models only if the foundation model ARN matches this parameter.
     * </p>
     * 
     * @return Return custom models only if the foundation model ARN matches this parameter.
     */
    public final String foundationModelArnEquals() {
        return foundationModelArnEquals;
    }

    /**
     * <p>
     * Maximum number of results to return in the response.
     * </p>
     * 
     * @return Maximum number of results to return in the response.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * Continuation token from the previous response, for Amazon Bedrock to list the next set of results.
     * </p>
     * 
     * @return Continuation token from the previous response, for Amazon Bedrock to list the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The field to sort by in the returned list of models.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortBy} will
     * return {@link SortModelsBy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortByAsString}.
     * </p>
     * 
     * @return The field to sort by in the returned list of models.
     * @see SortModelsBy
     */
    public final SortModelsBy sortBy() {
        return SortModelsBy.fromValue(sortBy);
    }

    /**
     * <p>
     * The field to sort by in the returned list of models.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortBy} will
     * return {@link SortModelsBy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortByAsString}.
     * </p>
     * 
     * @return The field to sort by in the returned list of models.
     * @see SortModelsBy
     */
    public final String sortByAsString() {
        return sortBy;
    }

    /**
     * <p>
     * The sort order of the results.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link SortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortOrderAsString}.
     * </p>
     * 
     * @return The sort order of the results.
     * @see SortOrder
     */
    public final SortOrder sortOrder() {
        return SortOrder.fromValue(sortOrder);
    }

    /**
     * <p>
     * The sort order of the results.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link SortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortOrderAsString}.
     * </p>
     * 
     * @return The sort order of the results.
     * @see SortOrder
     */
    public final String sortOrderAsString() {
        return sortOrder;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(creationTimeBefore());
        hashCode = 31 * hashCode + Objects.hashCode(creationTimeAfter());
        hashCode = 31 * hashCode + Objects.hashCode(nameContains());
        hashCode = 31 * hashCode + Objects.hashCode(baseModelArnEquals());
        hashCode = 31 * hashCode + Objects.hashCode(foundationModelArnEquals());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(sortByAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sortOrderAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCustomModelsRequest)) {
            return false;
        }
        ListCustomModelsRequest other = (ListCustomModelsRequest) obj;
        return Objects.equals(creationTimeBefore(), other.creationTimeBefore())
                && Objects.equals(creationTimeAfter(), other.creationTimeAfter())
                && Objects.equals(nameContains(), other.nameContains())
                && Objects.equals(baseModelArnEquals(), other.baseModelArnEquals())
                && Objects.equals(foundationModelArnEquals(), other.foundationModelArnEquals())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(sortByAsString(), other.sortByAsString())
                && Objects.equals(sortOrderAsString(), other.sortOrderAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListCustomModelsRequest").add("CreationTimeBefore", creationTimeBefore())
                .add("CreationTimeAfter", creationTimeAfter()).add("NameContains", nameContains())
                .add("BaseModelArnEquals", baseModelArnEquals()).add("FoundationModelArnEquals", foundationModelArnEquals())
                .add("MaxResults", maxResults()).add("NextToken", nextToken()).add("SortBy", sortByAsString())
                .add("SortOrder", sortOrderAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "creationTimeBefore":
            return Optional.ofNullable(clazz.cast(creationTimeBefore()));
        case "creationTimeAfter":
            return Optional.ofNullable(clazz.cast(creationTimeAfter()));
        case "nameContains":
            return Optional.ofNullable(clazz.cast(nameContains()));
        case "baseModelArnEquals":
            return Optional.ofNullable(clazz.cast(baseModelArnEquals()));
        case "foundationModelArnEquals":
            return Optional.ofNullable(clazz.cast(foundationModelArnEquals()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "sortBy":
            return Optional.ofNullable(clazz.cast(sortByAsString()));
        case "sortOrder":
            return Optional.ofNullable(clazz.cast(sortOrderAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListCustomModelsRequest, T> g) {
        return obj -> g.apply((ListCustomModelsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BedrockRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListCustomModelsRequest> {
        /**
         * <p>
         * Return custom models created before the specified time.
         * </p>
         * 
         * @param creationTimeBefore
         *        Return custom models created before the specified time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTimeBefore(Instant creationTimeBefore);

        /**
         * <p>
         * Return custom models created after the specified time.
         * </p>
         * 
         * @param creationTimeAfter
         *        Return custom models created after the specified time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTimeAfter(Instant creationTimeAfter);

        /**
         * <p>
         * Return custom models only if the job name contains these characters.
         * </p>
         * 
         * @param nameContains
         *        Return custom models only if the job name contains these characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nameContains(String nameContains);

        /**
         * <p>
         * Return custom models only if the base model ARN matches this parameter.
         * </p>
         * 
         * @param baseModelArnEquals
         *        Return custom models only if the base model ARN matches this parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder baseModelArnEquals(String baseModelArnEquals);

        /**
         * <p>
         * Return custom models only if the foundation model ARN matches this parameter.
         * </p>
         * 
         * @param foundationModelArnEquals
         *        Return custom models only if the foundation model ARN matches this parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder foundationModelArnEquals(String foundationModelArnEquals);

        /**
         * <p>
         * Maximum number of results to return in the response.
         * </p>
         * 
         * @param maxResults
         *        Maximum number of results to return in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * Continuation token from the previous response, for Amazon Bedrock to list the next set of results.
         * </p>
         * 
         * @param nextToken
         *        Continuation token from the previous response, for Amazon Bedrock to list the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The field to sort by in the returned list of models.
         * </p>
         * 
         * @param sortBy
         *        The field to sort by in the returned list of models.
         * @see SortModelsBy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortModelsBy
         */
        Builder sortBy(String sortBy);

        /**
         * <p>
         * The field to sort by in the returned list of models.
         * </p>
         * 
         * @param sortBy
         *        The field to sort by in the returned list of models.
         * @see SortModelsBy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortModelsBy
         */
        Builder sortBy(SortModelsBy sortBy);

        /**
         * <p>
         * The sort order of the results.
         * </p>
         * 
         * @param sortOrder
         *        The sort order of the results.
         * @see SortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortOrder
         */
        Builder sortOrder(String sortOrder);

        /**
         * <p>
         * The sort order of the results.
         * </p>
         * 
         * @param sortOrder
         *        The sort order of the results.
         * @see SortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortOrder
         */
        Builder sortOrder(SortOrder sortOrder);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BedrockRequest.BuilderImpl implements Builder {
        private Instant creationTimeBefore;

        private Instant creationTimeAfter;

        private String nameContains;

        private String baseModelArnEquals;

        private String foundationModelArnEquals;

        private Integer maxResults;

        private String nextToken;

        private String sortBy;

        private String sortOrder;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCustomModelsRequest model) {
            super(model);
            creationTimeBefore(model.creationTimeBefore);
            creationTimeAfter(model.creationTimeAfter);
            nameContains(model.nameContains);
            baseModelArnEquals(model.baseModelArnEquals);
            foundationModelArnEquals(model.foundationModelArnEquals);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            sortBy(model.sortBy);
            sortOrder(model.sortOrder);
        }

        public final Instant getCreationTimeBefore() {
            return creationTimeBefore;
        }

        public final void setCreationTimeBefore(Instant creationTimeBefore) {
            this.creationTimeBefore = creationTimeBefore;
        }

        @Override
        public final Builder creationTimeBefore(Instant creationTimeBefore) {
            this.creationTimeBefore = creationTimeBefore;
            return this;
        }

        public final Instant getCreationTimeAfter() {
            return creationTimeAfter;
        }

        public final void setCreationTimeAfter(Instant creationTimeAfter) {
            this.creationTimeAfter = creationTimeAfter;
        }

        @Override
        public final Builder creationTimeAfter(Instant creationTimeAfter) {
            this.creationTimeAfter = creationTimeAfter;
            return this;
        }

        public final String getNameContains() {
            return nameContains;
        }

        public final void setNameContains(String nameContains) {
            this.nameContains = nameContains;
        }

        @Override
        public final Builder nameContains(String nameContains) {
            this.nameContains = nameContains;
            return this;
        }

        public final String getBaseModelArnEquals() {
            return baseModelArnEquals;
        }

        public final void setBaseModelArnEquals(String baseModelArnEquals) {
            this.baseModelArnEquals = baseModelArnEquals;
        }

        @Override
        public final Builder baseModelArnEquals(String baseModelArnEquals) {
            this.baseModelArnEquals = baseModelArnEquals;
            return this;
        }

        public final String getFoundationModelArnEquals() {
            return foundationModelArnEquals;
        }

        public final void setFoundationModelArnEquals(String foundationModelArnEquals) {
            this.foundationModelArnEquals = foundationModelArnEquals;
        }

        @Override
        public final Builder foundationModelArnEquals(String foundationModelArnEquals) {
            this.foundationModelArnEquals = foundationModelArnEquals;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getSortBy() {
            return sortBy;
        }

        public final void setSortBy(String sortBy) {
            this.sortBy = sortBy;
        }

        @Override
        public final Builder sortBy(String sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        @Override
        public final Builder sortBy(SortModelsBy sortBy) {
            this.sortBy(sortBy == null ? null : sortBy.toString());
            return this;
        }

        public final String getSortOrder() {
            return sortOrder;
        }

        public final void setSortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
        }

        @Override
        public final Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @Override
        public final Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder(sortOrder == null ? null : sortOrder.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListCustomModelsRequest build() {
            return new ListCustomModelsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
