/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.b2bi.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.b2bi.model.KeyListCopier;
import software.amazon.awssdk.services.b2bi.model.SampleDocumentKeys;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SampleDocuments
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SampleDocuments> {
    private static final SdkField<String> BUCKET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("bucketName").getter(SampleDocuments.getter(SampleDocuments::bucketName)).setter(SampleDocuments.setter(Builder::bucketName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bucketName").build()}).build();
    private static final SdkField<List<SampleDocumentKeys>> KEYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("keys").getter(SampleDocuments.getter(SampleDocuments::keys)).setter(SampleDocuments.setter(Builder::keys)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("keys").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SampleDocumentKeys::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUCKET_NAME_FIELD, KEYS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SampleDocuments.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String bucketName;
    private final List<SampleDocumentKeys> keys;

    private SampleDocuments(BuilderImpl builder) {
        this.bucketName = builder.bucketName;
        this.keys = builder.keys;
    }

    public final String bucketName() {
        return this.bucketName;
    }

    public final boolean hasKeys() {
        return this.keys != null && !(this.keys instanceof SdkAutoConstructList);
    }

    public final List<SampleDocumentKeys> keys() {
        return this.keys;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.bucketName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasKeys() ? this.keys() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SampleDocuments)) {
            return false;
        }
        SampleDocuments other = (SampleDocuments)obj;
        return Objects.equals(this.bucketName(), other.bucketName()) && this.hasKeys() == other.hasKeys() && Objects.equals(this.keys(), other.keys());
    }

    public final String toString() {
        return ToString.builder((String)"SampleDocuments").add("BucketName", (Object)this.bucketName()).add("Keys", this.hasKeys() ? this.keys() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "bucketName": {
                return Optional.ofNullable(clazz.cast(this.bucketName()));
            }
            case "keys": {
                return Optional.ofNullable(clazz.cast(this.keys()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("bucketName", BUCKET_NAME_FIELD);
        map.put("keys", KEYS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SampleDocuments, T> g) {
        return obj -> g.apply((SampleDocuments)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String bucketName;
        private List<SampleDocumentKeys> keys = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SampleDocuments model) {
            this.bucketName(model.bucketName);
            this.keys(model.keys);
        }

        public final String getBucketName() {
            return this.bucketName;
        }

        public final void setBucketName(String bucketName) {
            this.bucketName = bucketName;
        }

        @Override
        public final Builder bucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        public final List<SampleDocumentKeys.Builder> getKeys() {
            List<SampleDocumentKeys.Builder> result = KeyListCopier.copyToBuilder(this.keys);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setKeys(Collection<SampleDocumentKeys.BuilderImpl> keys) {
            this.keys = KeyListCopier.copyFromBuilder(keys);
        }

        @Override
        public final Builder keys(Collection<SampleDocumentKeys> keys) {
            this.keys = KeyListCopier.copy(keys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keys(SampleDocumentKeys ... keys) {
            this.keys(Arrays.asList(keys));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keys(Consumer<SampleDocumentKeys.Builder> ... keys) {
            this.keys(Stream.of(keys).map(c -> (SampleDocumentKeys)((SampleDocumentKeys.Builder)SampleDocumentKeys.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public SampleDocuments build() {
            return new SampleDocuments(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SampleDocuments> {
        public Builder bucketName(String var1);

        public Builder keys(Collection<SampleDocumentKeys> var1);

        public Builder keys(SampleDocumentKeys ... var1);

        public Builder keys(Consumer<SampleDocumentKeys.Builder> ... var1);
    }
}

