/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.b2bi.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.b2bi.model.B2BiResponse;
import software.amazon.awssdk.services.b2bi.model.TransformerListCopier;
import software.amazon.awssdk.services.b2bi.model.TransformerSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListTransformersResponse
extends B2BiResponse
implements ToCopyableBuilder<Builder, ListTransformersResponse> {
    private static final SdkField<List<TransformerSummary>> TRANSFORMERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("transformers").getter(ListTransformersResponse.getter(ListTransformersResponse::transformers)).setter(ListTransformersResponse.setter(Builder::transformers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("transformers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TransformerSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListTransformersResponse.getter(ListTransformersResponse::nextToken)).setter(ListTransformersResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSFORMERS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListTransformersResponse.memberNameToFieldInitializer();
    private final List<TransformerSummary> transformers;
    private final String nextToken;

    private ListTransformersResponse(BuilderImpl builder) {
        super(builder);
        this.transformers = builder.transformers;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasTransformers() {
        return this.transformers != null && !(this.transformers instanceof SdkAutoConstructList);
    }

    public final List<TransformerSummary> transformers() {
        return this.transformers;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTransformers() ? this.transformers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTransformersResponse)) {
            return false;
        }
        ListTransformersResponse other = (ListTransformersResponse)((Object)obj);
        return this.hasTransformers() == other.hasTransformers() && Objects.equals(this.transformers(), other.transformers()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListTransformersResponse").add("Transformers", this.hasTransformers() ? this.transformers() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "transformers": {
                return Optional.ofNullable(clazz.cast(this.transformers()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("transformers", TRANSFORMERS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListTransformersResponse, T> g) {
        return obj -> g.apply((ListTransformersResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends B2BiResponse.BuilderImpl
    implements Builder {
        private List<TransformerSummary> transformers = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTransformersResponse model) {
            super(model);
            this.transformers(model.transformers);
            this.nextToken(model.nextToken);
        }

        public final List<TransformerSummary.Builder> getTransformers() {
            List<TransformerSummary.Builder> result = TransformerListCopier.copyToBuilder(this.transformers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTransformers(Collection<TransformerSummary.BuilderImpl> transformers) {
            this.transformers = TransformerListCopier.copyFromBuilder(transformers);
        }

        @Override
        public final Builder transformers(Collection<TransformerSummary> transformers) {
            this.transformers = TransformerListCopier.copy(transformers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder transformers(TransformerSummary ... transformers) {
            this.transformers(Arrays.asList(transformers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder transformers(Consumer<TransformerSummary.Builder> ... transformers) {
            this.transformers(Stream.of(transformers).map(c -> (TransformerSummary)((TransformerSummary.Builder)TransformerSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListTransformersResponse build() {
            return new ListTransformersResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends B2BiResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListTransformersResponse> {
        public Builder transformers(Collection<TransformerSummary> var1);

        public Builder transformers(TransformerSummary ... var1);

        public Builder transformers(Consumer<TransformerSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

