/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.autoscaling.model.AlarmListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AlarmSpecification
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AlarmSpecification> {
    private static final SdkField<List<String>> ALARMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Alarms").getter(AlarmSpecification.getter(AlarmSpecification::alarms)).setter(AlarmSpecification.setter(Builder::alarms)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Alarms").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALARMS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> alarms;

    private AlarmSpecification(BuilderImpl builder) {
        this.alarms = builder.alarms;
    }

    public final boolean hasAlarms() {
        return this.alarms != null && !(this.alarms instanceof SdkAutoConstructList);
    }

    public final List<String> alarms() {
        return this.alarms;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAlarms() ? this.alarms() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AlarmSpecification)) {
            return false;
        }
        AlarmSpecification other = (AlarmSpecification)obj;
        return this.hasAlarms() == other.hasAlarms() && Objects.equals(this.alarms(), other.alarms());
    }

    public final String toString() {
        return ToString.builder((String)"AlarmSpecification").add("Alarms", this.hasAlarms() ? this.alarms() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Alarms": {
                return Optional.ofNullable(clazz.cast(this.alarms()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AlarmSpecification, T> g) {
        return obj -> g.apply((AlarmSpecification)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> alarms = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AlarmSpecification model) {
            this.alarms(model.alarms);
        }

        public final Collection<String> getAlarms() {
            if (this.alarms instanceof SdkAutoConstructList) {
                return null;
            }
            return this.alarms;
        }

        public final void setAlarms(Collection<String> alarms) {
            this.alarms = AlarmListCopier.copy(alarms);
        }

        @Override
        public final Builder alarms(Collection<String> alarms) {
            this.alarms = AlarmListCopier.copy(alarms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder alarms(String ... alarms) {
            this.alarms(Arrays.asList(alarms));
            return this;
        }

        public AlarmSpecification build() {
            return new AlarmSpecification(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AlarmSpecification> {
        public Builder alarms(Collection<String> var1);

        public Builder alarms(String ... var1);
    }
}

