/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.autoscaling.AutoScalingClient;
import software.amazon.awssdk.services.autoscaling.model.DescribePoliciesRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribePoliciesResponse;
import software.amazon.awssdk.services.autoscaling.model.ScalingPolicy;

public class DescribePoliciesIterable
implements SdkIterable<DescribePoliciesResponse> {
    private final AutoScalingClient client;
    private final DescribePoliciesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribePoliciesIterable(AutoScalingClient client, DescribePoliciesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribePoliciesResponseFetcher();
    }

    public Iterator<DescribePoliciesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ScalingPolicy> scalingPolicies() {
        Function<DescribePoliciesResponse, Iterator> getIterator = response -> {
            if (response != null && response.scalingPolicies() != null) {
                return response.scalingPolicies().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribePoliciesResponseFetcher
    implements SyncPageFetcher<DescribePoliciesResponse> {
        private DescribePoliciesResponseFetcher() {
        }

        public boolean hasNextPage(DescribePoliciesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribePoliciesResponse nextPage(DescribePoliciesResponse previousPage) {
            if (previousPage == null) {
                return DescribePoliciesIterable.this.client.describePolicies(DescribePoliciesIterable.this.firstRequest);
            }
            return DescribePoliciesIterable.this.client.describePolicies((DescribePoliciesRequest)((Object)DescribePoliciesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

