/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the minimum and maximum for the <code>MemoryMiB</code> object when you specify <a>InstanceRequirements</a>
 * for an Auto Scaling group.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MemoryMiBRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<MemoryMiBRequest.Builder, MemoryMiBRequest> {
    private static final SdkField<Integer> MIN_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Min")
            .getter(getter(MemoryMiBRequest::min)).setter(setter(Builder::min))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Min").build()).build();

    private static final SdkField<Integer> MAX_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Max")
            .getter(getter(MemoryMiBRequest::max)).setter(setter(Builder::max))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Max").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MIN_FIELD, MAX_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer min;

    private final Integer max;

    private MemoryMiBRequest(BuilderImpl builder) {
        this.min = builder.min;
        this.max = builder.max;
    }

    /**
     * <p>
     * The memory minimum in MiB.
     * </p>
     * 
     * @return The memory minimum in MiB.
     */
    public final Integer min() {
        return min;
    }

    /**
     * <p>
     * The memory maximum in MiB.
     * </p>
     * 
     * @return The memory maximum in MiB.
     */
    public final Integer max() {
        return max;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(min());
        hashCode = 31 * hashCode + Objects.hashCode(max());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MemoryMiBRequest)) {
            return false;
        }
        MemoryMiBRequest other = (MemoryMiBRequest) obj;
        return Objects.equals(min(), other.min()) && Objects.equals(max(), other.max());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MemoryMiBRequest").add("Min", min()).add("Max", max()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Min":
            return Optional.ofNullable(clazz.cast(min()));
        case "Max":
            return Optional.ofNullable(clazz.cast(max()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MemoryMiBRequest, T> g) {
        return obj -> g.apply((MemoryMiBRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MemoryMiBRequest> {
        /**
         * <p>
         * The memory minimum in MiB.
         * </p>
         * 
         * @param min
         *        The memory minimum in MiB.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder min(Integer min);

        /**
         * <p>
         * The memory maximum in MiB.
         * </p>
         * 
         * @param max
         *        The memory maximum in MiB.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder max(Integer max);
    }

    static final class BuilderImpl implements Builder {
        private Integer min;

        private Integer max;

        private BuilderImpl() {
        }

        private BuilderImpl(MemoryMiBRequest model) {
            min(model.min);
            max(model.max);
        }

        public final Integer getMin() {
            return min;
        }

        public final void setMin(Integer min) {
            this.min = min;
        }

        @Override
        public final Builder min(Integer min) {
            this.min = min;
            return this;
        }

        public final Integer getMax() {
            return max;
        }

        public final void setMax(Integer max) {
            this.max = max;
        }

        @Override
        public final Builder max(Integer max) {
            this.max = max;
            return this;
        }

        @Override
        public MemoryMiBRequest build() {
            return new MemoryMiBRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
