/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CancelInstanceRefreshResponse extends AutoScalingResponse implements
        ToCopyableBuilder<CancelInstanceRefreshResponse.Builder, CancelInstanceRefreshResponse> {
    private static final SdkField<String> INSTANCE_REFRESH_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceRefreshId").getter(getter(CancelInstanceRefreshResponse::instanceRefreshId))
            .setter(setter(Builder::instanceRefreshId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceRefreshId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_REFRESH_ID_FIELD));

    private final String instanceRefreshId;

    private CancelInstanceRefreshResponse(BuilderImpl builder) {
        super(builder);
        this.instanceRefreshId = builder.instanceRefreshId;
    }

    /**
     * <p>
     * The instance refresh ID associated with the request. This is the unique ID assigned to the instance refresh when
     * it was started.
     * </p>
     * 
     * @return The instance refresh ID associated with the request. This is the unique ID assigned to the instance
     *         refresh when it was started.
     */
    public final String instanceRefreshId() {
        return instanceRefreshId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(instanceRefreshId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CancelInstanceRefreshResponse)) {
            return false;
        }
        CancelInstanceRefreshResponse other = (CancelInstanceRefreshResponse) obj;
        return Objects.equals(instanceRefreshId(), other.instanceRefreshId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CancelInstanceRefreshResponse").add("InstanceRefreshId", instanceRefreshId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceRefreshId":
            return Optional.ofNullable(clazz.cast(instanceRefreshId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CancelInstanceRefreshResponse, T> g) {
        return obj -> g.apply((CancelInstanceRefreshResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AutoScalingResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CancelInstanceRefreshResponse> {
        /**
         * <p>
         * The instance refresh ID associated with the request. This is the unique ID assigned to the instance refresh
         * when it was started.
         * </p>
         * 
         * @param instanceRefreshId
         *        The instance refresh ID associated with the request. This is the unique ID assigned to the instance
         *        refresh when it was started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceRefreshId(String instanceRefreshId);
    }

    static final class BuilderImpl extends AutoScalingResponse.BuilderImpl implements Builder {
        private String instanceRefreshId;

        private BuilderImpl() {
        }

        private BuilderImpl(CancelInstanceRefreshResponse model) {
            super(model);
            instanceRefreshId(model.instanceRefreshId);
        }

        public final String getInstanceRefreshId() {
            return instanceRefreshId;
        }

        public final void setInstanceRefreshId(String instanceRefreshId) {
            this.instanceRefreshId = instanceRefreshId;
        }

        @Override
        public final Builder instanceRefreshId(String instanceRefreshId) {
            this.instanceRefreshId = instanceRefreshId;
            return this;
        }

        @Override
        public CancelInstanceRefreshResponse build() {
            return new CancelInstanceRefreshResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
