/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.autoscaling.model.*;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;

import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * PutScalingPolicyResponse StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class PutScalingPolicyResponseUnmarshaller implements Unmarshaller<PutScalingPolicyResponse, StaxUnmarshallerContext> {

    public PutScalingPolicyResponse unmarshall(StaxUnmarshallerContext context) throws Exception {
        PutScalingPolicyResponse.Builder putScalingPolicyResponse = PutScalingPolicyResponse.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 2;

        java.util.List<Alarm> alarms = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                putScalingPolicyResponse.alarms(alarms);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("PolicyARN", targetDepth)) {
                    putScalingPolicyResponse.policyARN(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("Alarms", targetDepth)) {
                    alarms = new ArrayList<Alarm>();
                    continue;
                }

                if (context.testExpression("Alarms/member", targetDepth)) {
                    alarms.add(AlarmUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    putScalingPolicyResponse.alarms(alarms);
                    break;
                }
            }
        }
        return putScalingPolicyResponse.build();
    }

    private static final PutScalingPolicyResponseUnmarshaller INSTANCE = new PutScalingPolicyResponseUnmarshaller();

    public static PutScalingPolicyResponseUnmarshaller getInstance() {
        return INSTANCE;
    }
}
