/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.autoscaling.model.*;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;

import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * DescribeNotificationConfigurationsResponse StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class DescribeNotificationConfigurationsResponseUnmarshaller implements
        Unmarshaller<DescribeNotificationConfigurationsResponse, StaxUnmarshallerContext> {

    public DescribeNotificationConfigurationsResponse unmarshall(StaxUnmarshallerContext context) throws Exception {
        DescribeNotificationConfigurationsResponse.Builder describeNotificationConfigurationsResponse = DescribeNotificationConfigurationsResponse
                .builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 2;

        java.util.List<NotificationConfiguration> notificationConfigurations = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                describeNotificationConfigurationsResponse.notificationConfigurations(notificationConfigurations);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("NotificationConfigurations", targetDepth)) {
                    notificationConfigurations = new ArrayList<NotificationConfiguration>();
                    continue;
                }

                if (context.testExpression("NotificationConfigurations/member", targetDepth)) {
                    notificationConfigurations.add(NotificationConfigurationUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("NextToken", targetDepth)) {
                    describeNotificationConfigurationsResponse.nextToken(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    describeNotificationConfigurationsResponse.notificationConfigurations(notificationConfigurations);
                    break;
                }
            }
        }
        return describeNotificationConfigurationsResponse.build();
    }

    private static final DescribeNotificationConfigurationsResponseUnmarshaller INSTANCE = new DescribeNotificationConfigurationsResponseUnmarshaller();

    public static DescribeNotificationConfigurationsResponseUnmarshaller getInstance() {
        return INSTANCE;
    }
}
