/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.autoscaling.model.*;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;

import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * DescribeLoadBalancersResponse StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class DescribeLoadBalancersResponseUnmarshaller implements
        Unmarshaller<DescribeLoadBalancersResponse, StaxUnmarshallerContext> {

    public DescribeLoadBalancersResponse unmarshall(StaxUnmarshallerContext context) throws Exception {
        DescribeLoadBalancersResponse.Builder describeLoadBalancersResponse = DescribeLoadBalancersResponse.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 2;

        java.util.List<LoadBalancerState> loadBalancers = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                describeLoadBalancersResponse.loadBalancers(loadBalancers);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("LoadBalancers", targetDepth)) {
                    loadBalancers = new ArrayList<LoadBalancerState>();
                    continue;
                }

                if (context.testExpression("LoadBalancers/member", targetDepth)) {
                    loadBalancers.add(LoadBalancerStateUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("NextToken", targetDepth)) {
                    describeLoadBalancersResponse.nextToken(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    describeLoadBalancersResponse.loadBalancers(loadBalancers);
                    break;
                }
            }
        }
        return describeLoadBalancersResponse.build();
    }

    private static final DescribeLoadBalancersResponseUnmarshaller INSTANCE = new DescribeLoadBalancersResponseUnmarshaller();

    public static DescribeLoadBalancersResponseUnmarshaller getInstance() {
        return INSTANCE;
    }
}
