/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.transform;

import java.util.List;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.autoscaling.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;

/**
 * AttachLoadBalancersRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class AttachLoadBalancersRequestMarshaller implements
        Marshaller<Request<AttachLoadBalancersRequest>, AttachLoadBalancersRequest> {

    public Request<AttachLoadBalancersRequest> marshall(AttachLoadBalancersRequest attachLoadBalancersRequest) {

        if (attachLoadBalancersRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<AttachLoadBalancersRequest> request = new DefaultRequest<AttachLoadBalancersRequest>(attachLoadBalancersRequest,
                "AutoScalingClient");
        request.addParameter("Action", "AttachLoadBalancers");
        request.addParameter("Version", "2011-01-01");
        request.setHttpMethod(HttpMethodName.POST);

        if (attachLoadBalancersRequest.autoScalingGroupName() != null) {
            request.addParameter("AutoScalingGroupName",
                    StringUtils.fromString(attachLoadBalancersRequest.autoScalingGroupName()));
        }

        java.util.List<String> loadBalancerNamesList = attachLoadBalancersRequest.loadBalancerNames();

        if (loadBalancerNamesList != null) {
            if (!loadBalancerNamesList.isEmpty()) {
                int loadBalancerNamesListIndex = 1;

                for (String loadBalancerNamesListValue : loadBalancerNamesList) {
                    if (loadBalancerNamesListValue != null) {
                        request.addParameter("LoadBalancerNames.member." + loadBalancerNamesListIndex,
                                StringUtils.fromString(loadBalancerNamesListValue));
                    }
                    loadBalancerNamesListIndex++;
                }
            } else {
                request.addParameter("LoadBalancerNames", "");
            }
        }

        return request;
    }

}
