/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DeleteScheduledActionRequest extends AutoScalingRequest implements
        ToCopyableBuilder<DeleteScheduledActionRequest.Builder, DeleteScheduledActionRequest> {
    private final String autoScalingGroupName;

    private final String scheduledActionName;

    private DeleteScheduledActionRequest(BuilderImpl builder) {
        super(builder);
        this.autoScalingGroupName = builder.autoScalingGroupName;
        this.scheduledActionName = builder.scheduledActionName;
    }

    /**
     * <p>
     * The name of the Auto Scaling group.
     * </p>
     * 
     * @return The name of the Auto Scaling group.
     */
    public String autoScalingGroupName() {
        return autoScalingGroupName;
    }

    /**
     * <p>
     * The name of the action to delete.
     * </p>
     * 
     * @return The name of the action to delete.
     */
    public String scheduledActionName() {
        return scheduledActionName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(autoScalingGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(scheduledActionName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteScheduledActionRequest)) {
            return false;
        }
        DeleteScheduledActionRequest other = (DeleteScheduledActionRequest) obj;
        return Objects.equals(autoScalingGroupName(), other.autoScalingGroupName())
                && Objects.equals(scheduledActionName(), other.scheduledActionName());
    }

    @Override
    public String toString() {
        return ToString.builder("DeleteScheduledActionRequest").add("AutoScalingGroupName", autoScalingGroupName())
                .add("ScheduledActionName", scheduledActionName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AutoScalingGroupName":
            return Optional.of(clazz.cast(autoScalingGroupName()));
        case "ScheduledActionName":
            return Optional.of(clazz.cast(scheduledActionName()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends AutoScalingRequest.Builder, CopyableBuilder<Builder, DeleteScheduledActionRequest> {
        /**
         * <p>
         * The name of the Auto Scaling group.
         * </p>
         * 
         * @param autoScalingGroupName
         *        The name of the Auto Scaling group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoScalingGroupName(String autoScalingGroupName);

        /**
         * <p>
         * The name of the action to delete.
         * </p>
         * 
         * @param scheduledActionName
         *        The name of the action to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduledActionName(String scheduledActionName);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends AutoScalingRequest.BuilderImpl implements Builder {
        private String autoScalingGroupName;

        private String scheduledActionName;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteScheduledActionRequest model) {
            autoScalingGroupName(model.autoScalingGroupName);
            scheduledActionName(model.scheduledActionName);
        }

        public final String getAutoScalingGroupName() {
            return autoScalingGroupName;
        }

        @Override
        public final Builder autoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
            return this;
        }

        public final void setAutoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
        }

        public final String getScheduledActionName() {
            return scheduledActionName;
        }

        @Override
        public final Builder scheduledActionName(String scheduledActionName) {
            this.scheduledActionName = scheduledActionName;
            return this;
        }

        public final void setScheduledActionName(String scheduledActionName) {
            this.scheduledActionName = scheduledActionName;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DeleteScheduledActionRequest build() {
            return new DeleteScheduledActionRequest(this);
        }
    }
}
