/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DeleteLifecycleHookRequest extends AutoScalingRequest implements
        ToCopyableBuilder<DeleteLifecycleHookRequest.Builder, DeleteLifecycleHookRequest> {
    private final String lifecycleHookName;

    private final String autoScalingGroupName;

    private DeleteLifecycleHookRequest(BuilderImpl builder) {
        super(builder);
        this.lifecycleHookName = builder.lifecycleHookName;
        this.autoScalingGroupName = builder.autoScalingGroupName;
    }

    /**
     * <p>
     * The name of the lifecycle hook.
     * </p>
     * 
     * @return The name of the lifecycle hook.
     */
    public String lifecycleHookName() {
        return lifecycleHookName;
    }

    /**
     * <p>
     * The name of the Auto Scaling group for the lifecycle hook.
     * </p>
     * 
     * @return The name of the Auto Scaling group for the lifecycle hook.
     */
    public String autoScalingGroupName() {
        return autoScalingGroupName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(lifecycleHookName());
        hashCode = 31 * hashCode + Objects.hashCode(autoScalingGroupName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteLifecycleHookRequest)) {
            return false;
        }
        DeleteLifecycleHookRequest other = (DeleteLifecycleHookRequest) obj;
        return Objects.equals(lifecycleHookName(), other.lifecycleHookName())
                && Objects.equals(autoScalingGroupName(), other.autoScalingGroupName());
    }

    @Override
    public String toString() {
        return ToString.builder("DeleteLifecycleHookRequest").add("LifecycleHookName", lifecycleHookName())
                .add("AutoScalingGroupName", autoScalingGroupName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LifecycleHookName":
            return Optional.of(clazz.cast(lifecycleHookName()));
        case "AutoScalingGroupName":
            return Optional.of(clazz.cast(autoScalingGroupName()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends AutoScalingRequest.Builder, CopyableBuilder<Builder, DeleteLifecycleHookRequest> {
        /**
         * <p>
         * The name of the lifecycle hook.
         * </p>
         * 
         * @param lifecycleHookName
         *        The name of the lifecycle hook.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lifecycleHookName(String lifecycleHookName);

        /**
         * <p>
         * The name of the Auto Scaling group for the lifecycle hook.
         * </p>
         * 
         * @param autoScalingGroupName
         *        The name of the Auto Scaling group for the lifecycle hook.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoScalingGroupName(String autoScalingGroupName);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends AutoScalingRequest.BuilderImpl implements Builder {
        private String lifecycleHookName;

        private String autoScalingGroupName;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteLifecycleHookRequest model) {
            lifecycleHookName(model.lifecycleHookName);
            autoScalingGroupName(model.autoScalingGroupName);
        }

        public final String getLifecycleHookName() {
            return lifecycleHookName;
        }

        @Override
        public final Builder lifecycleHookName(String lifecycleHookName) {
            this.lifecycleHookName = lifecycleHookName;
            return this;
        }

        public final void setLifecycleHookName(String lifecycleHookName) {
            this.lifecycleHookName = lifecycleHookName;
        }

        public final String getAutoScalingGroupName() {
            return autoScalingGroupName;
        }

        @Override
        public final Builder autoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
            return this;
        }

        public final void setAutoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DeleteLifecycleHookRequest build() {
            return new DeleteLifecycleHookRequest(this);
        }
    }
}
