/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes scaling activity, which is a long-running process that represents a change to your Auto Scaling group, such
 * as changing its size or replacing an instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class Activity implements ToCopyableBuilder<Activity.Builder, Activity> {
    private final String activityId;

    private final String autoScalingGroupName;

    private final String description;

    private final String cause;

    private final Instant startTime;

    private final Instant endTime;

    private final String statusCode;

    private final String statusMessage;

    private final Integer progress;

    private final String details;

    private Activity(BuilderImpl builder) {
        this.activityId = builder.activityId;
        this.autoScalingGroupName = builder.autoScalingGroupName;
        this.description = builder.description;
        this.cause = builder.cause;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.statusCode = builder.statusCode;
        this.statusMessage = builder.statusMessage;
        this.progress = builder.progress;
        this.details = builder.details;
    }

    /**
     * <p>
     * The ID of the activity.
     * </p>
     * 
     * @return The ID of the activity.
     */
    public String activityId() {
        return activityId;
    }

    /**
     * <p>
     * The name of the Auto Scaling group.
     * </p>
     * 
     * @return The name of the Auto Scaling group.
     */
    public String autoScalingGroupName() {
        return autoScalingGroupName;
    }

    /**
     * <p>
     * A friendly, more verbose description of the activity.
     * </p>
     * 
     * @return A friendly, more verbose description of the activity.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The reason the activity began.
     * </p>
     * 
     * @return The reason the activity began.
     */
    public String cause() {
        return cause;
    }

    /**
     * <p>
     * The start time of the activity.
     * </p>
     * 
     * @return The start time of the activity.
     */
    public Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The end time of the activity.
     * </p>
     * 
     * @return The end time of the activity.
     */
    public Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * The current status of the activity.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statusCode} will
     * return {@link ScalingActivityStatusCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusCodeString}.
     * </p>
     * 
     * @return The current status of the activity.
     * @see ScalingActivityStatusCode
     */
    public ScalingActivityStatusCode statusCode() {
        return ScalingActivityStatusCode.fromValue(statusCode);
    }

    /**
     * <p>
     * The current status of the activity.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statusCode} will
     * return {@link ScalingActivityStatusCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusCodeString}.
     * </p>
     * 
     * @return The current status of the activity.
     * @see ScalingActivityStatusCode
     */
    public String statusCodeString() {
        return statusCode;
    }

    /**
     * <p>
     * A friendly, more verbose description of the activity status.
     * </p>
     * 
     * @return A friendly, more verbose description of the activity status.
     */
    public String statusMessage() {
        return statusMessage;
    }

    /**
     * <p>
     * A value between 0 and 100 that indicates the progress of the activity.
     * </p>
     * 
     * @return A value between 0 and 100 that indicates the progress of the activity.
     */
    public Integer progress() {
        return progress;
    }

    /**
     * <p>
     * The details about the activity.
     * </p>
     * 
     * @return The details about the activity.
     */
    public String details() {
        return details;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(activityId());
        hashCode = 31 * hashCode + Objects.hashCode(autoScalingGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(cause());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(statusCodeString());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(progress());
        hashCode = 31 * hashCode + Objects.hashCode(details());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Activity)) {
            return false;
        }
        Activity other = (Activity) obj;
        return Objects.equals(activityId(), other.activityId())
                && Objects.equals(autoScalingGroupName(), other.autoScalingGroupName())
                && Objects.equals(description(), other.description()) && Objects.equals(cause(), other.cause())
                && Objects.equals(startTime(), other.startTime()) && Objects.equals(endTime(), other.endTime())
                && Objects.equals(statusCodeString(), other.statusCodeString())
                && Objects.equals(statusMessage(), other.statusMessage()) && Objects.equals(progress(), other.progress())
                && Objects.equals(details(), other.details());
    }

    @Override
    public String toString() {
        return ToString.builder("Activity").add("ActivityId", activityId()).add("AutoScalingGroupName", autoScalingGroupName())
                .add("Description", description()).add("Cause", cause()).add("StartTime", startTime()).add("EndTime", endTime())
                .add("StatusCode", statusCodeString()).add("StatusMessage", statusMessage()).add("Progress", progress())
                .add("Details", details()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ActivityId":
            return Optional.of(clazz.cast(activityId()));
        case "AutoScalingGroupName":
            return Optional.of(clazz.cast(autoScalingGroupName()));
        case "Description":
            return Optional.of(clazz.cast(description()));
        case "Cause":
            return Optional.of(clazz.cast(cause()));
        case "StartTime":
            return Optional.of(clazz.cast(startTime()));
        case "EndTime":
            return Optional.of(clazz.cast(endTime()));
        case "StatusCode":
            return Optional.of(clazz.cast(statusCodeString()));
        case "StatusMessage":
            return Optional.of(clazz.cast(statusMessage()));
        case "Progress":
            return Optional.of(clazz.cast(progress()));
        case "Details":
            return Optional.of(clazz.cast(details()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, Activity> {
        /**
         * <p>
         * The ID of the activity.
         * </p>
         * 
         * @param activityId
         *        The ID of the activity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activityId(String activityId);

        /**
         * <p>
         * The name of the Auto Scaling group.
         * </p>
         * 
         * @param autoScalingGroupName
         *        The name of the Auto Scaling group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoScalingGroupName(String autoScalingGroupName);

        /**
         * <p>
         * A friendly, more verbose description of the activity.
         * </p>
         * 
         * @param description
         *        A friendly, more verbose description of the activity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The reason the activity began.
         * </p>
         * 
         * @param cause
         *        The reason the activity began.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cause(String cause);

        /**
         * <p>
         * The start time of the activity.
         * </p>
         * 
         * @param startTime
         *        The start time of the activity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The end time of the activity.
         * </p>
         * 
         * @param endTime
         *        The end time of the activity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * The current status of the activity.
         * </p>
         * 
         * @param statusCode
         *        The current status of the activity.
         * @see ScalingActivityStatusCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScalingActivityStatusCode
         */
        Builder statusCode(String statusCode);

        /**
         * <p>
         * The current status of the activity.
         * </p>
         * 
         * @param statusCode
         *        The current status of the activity.
         * @see ScalingActivityStatusCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScalingActivityStatusCode
         */
        Builder statusCode(ScalingActivityStatusCode statusCode);

        /**
         * <p>
         * A friendly, more verbose description of the activity status.
         * </p>
         * 
         * @param statusMessage
         *        A friendly, more verbose description of the activity status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);

        /**
         * <p>
         * A value between 0 and 100 that indicates the progress of the activity.
         * </p>
         * 
         * @param progress
         *        A value between 0 and 100 that indicates the progress of the activity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder progress(Integer progress);

        /**
         * <p>
         * The details about the activity.
         * </p>
         * 
         * @param details
         *        The details about the activity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder details(String details);
    }

    static final class BuilderImpl implements Builder {
        private String activityId;

        private String autoScalingGroupName;

        private String description;

        private String cause;

        private Instant startTime;

        private Instant endTime;

        private String statusCode;

        private String statusMessage;

        private Integer progress;

        private String details;

        private BuilderImpl() {
        }

        private BuilderImpl(Activity model) {
            activityId(model.activityId);
            autoScalingGroupName(model.autoScalingGroupName);
            description(model.description);
            cause(model.cause);
            startTime(model.startTime);
            endTime(model.endTime);
            statusCode(model.statusCode);
            statusMessage(model.statusMessage);
            progress(model.progress);
            details(model.details);
        }

        public final String getActivityId() {
            return activityId;
        }

        @Override
        public final Builder activityId(String activityId) {
            this.activityId = activityId;
            return this;
        }

        public final void setActivityId(String activityId) {
            this.activityId = activityId;
        }

        public final String getAutoScalingGroupName() {
            return autoScalingGroupName;
        }

        @Override
        public final Builder autoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
            return this;
        }

        public final void setAutoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getCause() {
            return cause;
        }

        @Override
        public final Builder cause(String cause) {
            this.cause = cause;
            return this;
        }

        public final void setCause(String cause) {
            this.cause = cause;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        public final String getStatusCode() {
            return statusCode;
        }

        @Override
        public final Builder statusCode(String statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public final Builder statusCode(ScalingActivityStatusCode statusCode) {
            this.statusCode(statusCode.toString());
            return this;
        }

        public final void setStatusCode(String statusCode) {
            this.statusCode = statusCode;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        public final Integer getProgress() {
            return progress;
        }

        @Override
        public final Builder progress(Integer progress) {
            this.progress = progress;
            return this;
        }

        public final void setProgress(Integer progress) {
            this.progress = progress;
        }

        public final String getDetails() {
            return details;
        }

        @Override
        public final Builder details(String details) {
            this.details = details;
            return this;
        }

        public final void setDetails(String details) {
            this.details = details;
        }

        @Override
        public Activity build() {
            return new Activity(this);
        }
    }
}
