/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.autoscaling.model.AutoScalingGroup;
import software.amazon.awssdk.services.autoscaling.model.EnabledMetric;
import software.amazon.awssdk.services.autoscaling.model.Instance;
import software.amazon.awssdk.services.autoscaling.model.SuspendedProcess;
import software.amazon.awssdk.services.autoscaling.model.TagDescription;
import software.amazon.awssdk.services.autoscaling.transform.EnabledMetricUnmarshaller;
import software.amazon.awssdk.services.autoscaling.transform.InstanceUnmarshaller;
import software.amazon.awssdk.services.autoscaling.transform.SuspendedProcessUnmarshaller;
import software.amazon.awssdk.services.autoscaling.transform.TagDescriptionUnmarshaller;

public class AutoScalingGroupUnmarshaller
implements Unmarshaller<AutoScalingGroup, StaxUnmarshallerContext> {
    private static final AutoScalingGroupUnmarshaller INSTANCE = new AutoScalingGroupUnmarshaller();

    public AutoScalingGroup unmarshall(StaxUnmarshallerContext context) throws Exception {
        AutoScalingGroup.Builder autoScalingGroup;
        block33: {
            autoScalingGroup = AutoScalingGroup.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                ++targetDepth;
            }
            ArrayList<String> availabilityZones = null;
            ArrayList<String> loadBalancerNames = null;
            ArrayList<String> targetGroupARNs = null;
            ArrayList<Instance> instances = null;
            ArrayList<SuspendedProcess> suspendedProcesses = null;
            ArrayList<EnabledMetric> enabledMetrics = null;
            ArrayList<TagDescription> tags = null;
            ArrayList<String> terminationPolicies = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    autoScalingGroup.availabilityZones(availabilityZones);
                    autoScalingGroup.loadBalancerNames(loadBalancerNames);
                    autoScalingGroup.targetGroupARNs(targetGroupARNs);
                    autoScalingGroup.instances(instances);
                    autoScalingGroup.suspendedProcesses(suspendedProcesses);
                    autoScalingGroup.enabledMetrics(enabledMetrics);
                    autoScalingGroup.tags(tags);
                    autoScalingGroup.terminationPolicies(terminationPolicies);
                    break block33;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("AutoScalingGroupName", targetDepth)) {
                        autoScalingGroup.autoScalingGroupName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("AutoScalingGroupARN", targetDepth)) {
                        autoScalingGroup.autoScalingGroupARN(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("LaunchConfigurationName", targetDepth)) {
                        autoScalingGroup.launchConfigurationName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("MinSize", targetDepth)) {
                        autoScalingGroup.minSize(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("MaxSize", targetDepth)) {
                        autoScalingGroup.maxSize(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("DesiredCapacity", targetDepth)) {
                        autoScalingGroup.desiredCapacity(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("DefaultCooldown", targetDepth)) {
                        autoScalingGroup.defaultCooldown(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("AvailabilityZones", targetDepth)) {
                        availabilityZones = new ArrayList<String>();
                        continue;
                    }
                    if (context.testExpression("AvailabilityZones/member", targetDepth)) {
                        availabilityZones.add(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("LoadBalancerNames", targetDepth)) {
                        loadBalancerNames = new ArrayList<String>();
                        continue;
                    }
                    if (context.testExpression("LoadBalancerNames/member", targetDepth)) {
                        loadBalancerNames.add(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("TargetGroupARNs", targetDepth)) {
                        targetGroupARNs = new ArrayList<String>();
                        continue;
                    }
                    if (context.testExpression("TargetGroupARNs/member", targetDepth)) {
                        targetGroupARNs.add(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("HealthCheckType", targetDepth)) {
                        autoScalingGroup.healthCheckType(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("HealthCheckGracePeriod", targetDepth)) {
                        autoScalingGroup.healthCheckGracePeriod(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Instances", targetDepth)) {
                        instances = new ArrayList<Instance>();
                        continue;
                    }
                    if (context.testExpression("Instances/member", targetDepth)) {
                        instances.add(InstanceUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("CreatedTime", targetDepth)) {
                        autoScalingGroup.createdTime(SimpleTypeStaxUnmarshallers.InstantUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("SuspendedProcesses", targetDepth)) {
                        suspendedProcesses = new ArrayList<SuspendedProcess>();
                        continue;
                    }
                    if (context.testExpression("SuspendedProcesses/member", targetDepth)) {
                        suspendedProcesses.add(SuspendedProcessUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("PlacementGroup", targetDepth)) {
                        autoScalingGroup.placementGroup(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("VPCZoneIdentifier", targetDepth)) {
                        autoScalingGroup.vpcZoneIdentifier(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("EnabledMetrics", targetDepth)) {
                        enabledMetrics = new ArrayList<EnabledMetric>();
                        continue;
                    }
                    if (context.testExpression("EnabledMetrics/member", targetDepth)) {
                        enabledMetrics.add(EnabledMetricUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Status", targetDepth)) {
                        autoScalingGroup.status(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Tags", targetDepth)) {
                        tags = new ArrayList<TagDescription>();
                        continue;
                    }
                    if (context.testExpression("Tags/member", targetDepth)) {
                        tags.add(TagDescriptionUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("TerminationPolicies", targetDepth)) {
                        terminationPolicies = new ArrayList<String>();
                        continue;
                    }
                    if (context.testExpression("TerminationPolicies/member", targetDepth)) {
                        terminationPolicies.add(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (!context.testExpression("NewInstancesProtectedFromScaleIn", targetDepth)) continue;
                    autoScalingGroup.newInstancesProtectedFromScaleIn(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            autoScalingGroup.availabilityZones(availabilityZones);
            autoScalingGroup.loadBalancerNames(loadBalancerNames);
            autoScalingGroup.targetGroupARNs(targetGroupARNs);
            autoScalingGroup.instances(instances);
            autoScalingGroup.suspendedProcesses(suspendedProcesses);
            autoScalingGroup.enabledMetrics(enabledMetrics);
            autoScalingGroup.tags(tags);
            autoScalingGroup.terminationPolicies(terminationPolicies);
        }
        return (AutoScalingGroup)autoScalingGroup.build();
    }

    public static AutoScalingGroupUnmarshaller getInstance() {
        return INSTANCE;
    }
}

