/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class TerminateInstanceInAutoScalingGroupRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, TerminateInstanceInAutoScalingGroupRequest> {
    private final String instanceId;
    private final Boolean shouldDecrementDesiredCapacity;

    private TerminateInstanceInAutoScalingGroupRequest(BuilderImpl builder) {
        this.instanceId = builder.instanceId;
        this.shouldDecrementDesiredCapacity = builder.shouldDecrementDesiredCapacity;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public Boolean shouldDecrementDesiredCapacity() {
        return this.shouldDecrementDesiredCapacity;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.instanceId() == null ? 0 : this.instanceId().hashCode());
        hashCode = 31 * hashCode + (this.shouldDecrementDesiredCapacity() == null ? 0 : this.shouldDecrementDesiredCapacity().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TerminateInstanceInAutoScalingGroupRequest)) {
            return false;
        }
        TerminateInstanceInAutoScalingGroupRequest other = (TerminateInstanceInAutoScalingGroupRequest)((Object)obj);
        if (other.instanceId() == null ^ this.instanceId() == null) {
            return false;
        }
        if (other.instanceId() != null && !other.instanceId().equals(this.instanceId())) {
            return false;
        }
        if (other.shouldDecrementDesiredCapacity() == null ^ this.shouldDecrementDesiredCapacity() == null) {
            return false;
        }
        return other.shouldDecrementDesiredCapacity() == null || other.shouldDecrementDesiredCapacity().equals(this.shouldDecrementDesiredCapacity());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.instanceId() != null) {
            sb.append("InstanceId: ").append(this.instanceId()).append(",");
        }
        if (this.shouldDecrementDesiredCapacity() != null) {
            sb.append("ShouldDecrementDesiredCapacity: ").append(this.shouldDecrementDesiredCapacity()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String instanceId;
        private Boolean shouldDecrementDesiredCapacity;

        private BuilderImpl() {
        }

        private BuilderImpl(TerminateInstanceInAutoScalingGroupRequest model) {
            this.setInstanceId(model.instanceId);
            this.setShouldDecrementDesiredCapacity(model.shouldDecrementDesiredCapacity);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final Boolean getShouldDecrementDesiredCapacity() {
            return this.shouldDecrementDesiredCapacity;
        }

        @Override
        public final Builder shouldDecrementDesiredCapacity(Boolean shouldDecrementDesiredCapacity) {
            this.shouldDecrementDesiredCapacity = shouldDecrementDesiredCapacity;
            return this;
        }

        public final void setShouldDecrementDesiredCapacity(Boolean shouldDecrementDesiredCapacity) {
            this.shouldDecrementDesiredCapacity = shouldDecrementDesiredCapacity;
        }

        public TerminateInstanceInAutoScalingGroupRequest build() {
            return new TerminateInstanceInAutoScalingGroupRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, TerminateInstanceInAutoScalingGroupRequest> {
        public Builder instanceId(String var1);

        public Builder shouldDecrementDesiredCapacity(Boolean var1);
    }
}

