/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.autoscaling.model.AutoScalingNotificationTypesCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PutNotificationConfigurationRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, PutNotificationConfigurationRequest> {
    private final String autoScalingGroupName;
    private final String topicARN;
    private final List<String> notificationTypes;

    private PutNotificationConfigurationRequest(BuilderImpl builder) {
        this.autoScalingGroupName = builder.autoScalingGroupName;
        this.topicARN = builder.topicARN;
        this.notificationTypes = builder.notificationTypes;
    }

    public String autoScalingGroupName() {
        return this.autoScalingGroupName;
    }

    public String topicARN() {
        return this.topicARN;
    }

    public List<String> notificationTypes() {
        return this.notificationTypes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.autoScalingGroupName() == null ? 0 : this.autoScalingGroupName().hashCode());
        hashCode = 31 * hashCode + (this.topicARN() == null ? 0 : this.topicARN().hashCode());
        hashCode = 31 * hashCode + (this.notificationTypes() == null ? 0 : this.notificationTypes().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutNotificationConfigurationRequest)) {
            return false;
        }
        PutNotificationConfigurationRequest other = (PutNotificationConfigurationRequest)((Object)obj);
        if (other.autoScalingGroupName() == null ^ this.autoScalingGroupName() == null) {
            return false;
        }
        if (other.autoScalingGroupName() != null && !other.autoScalingGroupName().equals(this.autoScalingGroupName())) {
            return false;
        }
        if (other.topicARN() == null ^ this.topicARN() == null) {
            return false;
        }
        if (other.topicARN() != null && !other.topicARN().equals(this.topicARN())) {
            return false;
        }
        if (other.notificationTypes() == null ^ this.notificationTypes() == null) {
            return false;
        }
        return other.notificationTypes() == null || other.notificationTypes().equals(this.notificationTypes());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.autoScalingGroupName() != null) {
            sb.append("AutoScalingGroupName: ").append(this.autoScalingGroupName()).append(",");
        }
        if (this.topicARN() != null) {
            sb.append("TopicARN: ").append(this.topicARN()).append(",");
        }
        if (this.notificationTypes() != null) {
            sb.append("NotificationTypes: ").append(this.notificationTypes()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String autoScalingGroupName;
        private String topicARN;
        private List<String> notificationTypes;

        private BuilderImpl() {
        }

        private BuilderImpl(PutNotificationConfigurationRequest model) {
            this.setAutoScalingGroupName(model.autoScalingGroupName);
            this.setTopicARN(model.topicARN);
            this.setNotificationTypes(model.notificationTypes);
        }

        public final String getAutoScalingGroupName() {
            return this.autoScalingGroupName;
        }

        @Override
        public final Builder autoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
            return this;
        }

        public final void setAutoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
        }

        public final String getTopicARN() {
            return this.topicARN;
        }

        @Override
        public final Builder topicARN(String topicARN) {
            this.topicARN = topicARN;
            return this;
        }

        public final void setTopicARN(String topicARN) {
            this.topicARN = topicARN;
        }

        public final Collection<String> getNotificationTypes() {
            return this.notificationTypes;
        }

        @Override
        public final Builder notificationTypes(Collection<String> notificationTypes) {
            this.notificationTypes = AutoScalingNotificationTypesCopier.copy(notificationTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notificationTypes(String ... notificationTypes) {
            this.notificationTypes(Arrays.asList(notificationTypes));
            return this;
        }

        public final void setNotificationTypes(Collection<String> notificationTypes) {
            this.notificationTypes = AutoScalingNotificationTypesCopier.copy(notificationTypes);
        }

        public PutNotificationConfigurationRequest build() {
            return new PutNotificationConfigurationRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PutNotificationConfigurationRequest> {
        public Builder autoScalingGroupName(String var1);

        public Builder topicARN(String var1);

        public Builder notificationTypes(Collection<String> var1);

        public Builder notificationTypes(String ... var1);
    }
}

