/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class EnabledMetric
implements ToCopyableBuilder<Builder, EnabledMetric> {
    private final String metric;
    private final String granularity;

    private EnabledMetric(BuilderImpl builder) {
        this.metric = builder.metric;
        this.granularity = builder.granularity;
    }

    public String metric() {
        return this.metric;
    }

    public String granularity() {
        return this.granularity;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.metric() == null ? 0 : this.metric().hashCode());
        hashCode = 31 * hashCode + (this.granularity() == null ? 0 : this.granularity().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnabledMetric)) {
            return false;
        }
        EnabledMetric other = (EnabledMetric)obj;
        if (other.metric() == null ^ this.metric() == null) {
            return false;
        }
        if (other.metric() != null && !other.metric().equals(this.metric())) {
            return false;
        }
        if (other.granularity() == null ^ this.granularity() == null) {
            return false;
        }
        return other.granularity() == null || other.granularity().equals(this.granularity());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.metric() != null) {
            sb.append("Metric: ").append(this.metric()).append(",");
        }
        if (this.granularity() != null) {
            sb.append("Granularity: ").append(this.granularity()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String metric;
        private String granularity;

        private BuilderImpl() {
        }

        private BuilderImpl(EnabledMetric model) {
            this.setMetric(model.metric);
            this.setGranularity(model.granularity);
        }

        public final String getMetric() {
            return this.metric;
        }

        @Override
        public final Builder metric(String metric) {
            this.metric = metric;
            return this;
        }

        public final void setMetric(String metric) {
            this.metric = metric;
        }

        public final String getGranularity() {
            return this.granularity;
        }

        @Override
        public final Builder granularity(String granularity) {
            this.granularity = granularity;
            return this;
        }

        public final void setGranularity(String granularity) {
            this.granularity = granularity;
        }

        public EnabledMetric build() {
            return new EnabledMetric(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, EnabledMetric> {
        public Builder metric(String var1);

        public Builder granularity(String var1);
    }
}

