/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.autoscaling.model.LaunchConfigurationNamesCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeLaunchConfigurationsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeLaunchConfigurationsRequest> {
    private final List<String> launchConfigurationNames;
    private final String nextToken;
    private final Integer maxRecords;

    private DescribeLaunchConfigurationsRequest(BuilderImpl builder) {
        this.launchConfigurationNames = builder.launchConfigurationNames;
        this.nextToken = builder.nextToken;
        this.maxRecords = builder.maxRecords;
    }

    public List<String> launchConfigurationNames() {
        return this.launchConfigurationNames;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Integer maxRecords() {
        return this.maxRecords;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.launchConfigurationNames() == null ? 0 : this.launchConfigurationNames().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        hashCode = 31 * hashCode + (this.maxRecords() == null ? 0 : this.maxRecords().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLaunchConfigurationsRequest)) {
            return false;
        }
        DescribeLaunchConfigurationsRequest other = (DescribeLaunchConfigurationsRequest)((Object)obj);
        if (other.launchConfigurationNames() == null ^ this.launchConfigurationNames() == null) {
            return false;
        }
        if (other.launchConfigurationNames() != null && !other.launchConfigurationNames().equals(this.launchConfigurationNames())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        if (other.maxRecords() == null ^ this.maxRecords() == null) {
            return false;
        }
        return other.maxRecords() == null || other.maxRecords().equals(this.maxRecords());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.launchConfigurationNames() != null) {
            sb.append("LaunchConfigurationNames: ").append(this.launchConfigurationNames()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (this.maxRecords() != null) {
            sb.append("MaxRecords: ").append(this.maxRecords()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<String> launchConfigurationNames;
        private String nextToken;
        private Integer maxRecords;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLaunchConfigurationsRequest model) {
            this.setLaunchConfigurationNames(model.launchConfigurationNames);
            this.setNextToken(model.nextToken);
            this.setMaxRecords(model.maxRecords);
        }

        public final Collection<String> getLaunchConfigurationNames() {
            return this.launchConfigurationNames;
        }

        @Override
        public final Builder launchConfigurationNames(Collection<String> launchConfigurationNames) {
            this.launchConfigurationNames = LaunchConfigurationNamesCopier.copy(launchConfigurationNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder launchConfigurationNames(String ... launchConfigurationNames) {
            this.launchConfigurationNames(Arrays.asList(launchConfigurationNames));
            return this;
        }

        public final void setLaunchConfigurationNames(Collection<String> launchConfigurationNames) {
            this.launchConfigurationNames = LaunchConfigurationNamesCopier.copy(launchConfigurationNames);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxRecords() {
            return this.maxRecords;
        }

        @Override
        public final Builder maxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
            return this;
        }

        public final void setMaxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
        }

        public DescribeLaunchConfigurationsRequest build() {
            return new DescribeLaunchConfigurationsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeLaunchConfigurationsRequest> {
        public Builder launchConfigurationNames(Collection<String> var1);

        public Builder launchConfigurationNames(String ... var1);

        public Builder nextToken(String var1);

        public Builder maxRecords(Integer var1);
    }
}

