/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.waiters;

import javax.annotation.Generated;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.services.autoscaling.AutoScalingClient;
import software.amazon.awssdk.services.autoscaling.model.*;
import software.amazon.awssdk.waiters.*;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class AutoScalingClientWaiters {

    /**
     * Represents the service client
     */
    private final AutoScalingClient client;

    private final ExecutorService executorService = Executors.newFixedThreadPool(50);

    /**
     * Constructs a new AutoScalingClientWaiters with the given client
     * 
     * @param client
     *        Service client
     */
    @SdkInternalApi
    public AutoScalingClientWaiters(AutoScalingClient client) {
        this.client = client;
    }

    /**
     * Builds a GroupInService waiter by using custom parameters waiterParameters and other parameters defined in the
     * waiters specification, and then polls until it determines whether the resource entered the desired state or not,
     * where polling criteria is bound by either default polling strategy or custom polling strategy.
     */
    public Waiter<DescribeAutoScalingGroupsRequest> groupInService() {

        return new WaiterBuilder<DescribeAutoScalingGroupsRequest, DescribeAutoScalingGroupsResponse>()
                .withSdkFunction(new DescribeAutoScalingGroupsFunction(client))
                .withAcceptors(new GroupInService.IsFalseMatcher(), new GroupInService.IsTrueMatcher())
                .withDefaultPollingStrategy(new PollingStrategy(new MaxAttemptsRetryStrategy(40), new FixedDelayStrategy(15)))
                .withExecutorService(executorService).build();
    }

    /**
     * Builds a GroupNotExists waiter by using custom parameters waiterParameters and other parameters defined in the
     * waiters specification, and then polls until it determines whether the resource entered the desired state or not,
     * where polling criteria is bound by either default polling strategy or custom polling strategy.
     */
    public Waiter<DescribeAutoScalingGroupsRequest> groupNotExists() {

        return new WaiterBuilder<DescribeAutoScalingGroupsRequest, DescribeAutoScalingGroupsResponse>()
                .withSdkFunction(new DescribeAutoScalingGroupsFunction(client))
                .withAcceptors(new GroupNotExists.IsFalseMatcher(), new GroupNotExists.IsTrueMatcher())
                .withDefaultPollingStrategy(new PollingStrategy(new MaxAttemptsRetryStrategy(40), new FixedDelayStrategy(15)))
                .withExecutorService(executorService).build();
    }

    /**
     * Builds a GroupExists waiter by using custom parameters waiterParameters and other parameters defined in the
     * waiters specification, and then polls until it determines whether the resource entered the desired state or not,
     * where polling criteria is bound by either default polling strategy or custom polling strategy.
     */
    public Waiter<DescribeAutoScalingGroupsRequest> groupExists() {

        return new WaiterBuilder<DescribeAutoScalingGroupsRequest, DescribeAutoScalingGroupsResponse>()
                .withSdkFunction(new DescribeAutoScalingGroupsFunction(client))
                .withAcceptors(new GroupExists.IsTrueMatcher(), new GroupExists.IsFalseMatcher())
                .withDefaultPollingStrategy(new PollingStrategy(new MaxAttemptsRetryStrategy(10), new FixedDelayStrategy(5)))
                .withExecutorService(executorService).build();
    }

}
