/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class PutNotificationConfigurationRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<PutNotificationConfigurationRequest.Builder, PutNotificationConfigurationRequest> {
    private final String autoScalingGroupName;

    private final String topicARN;

    private final List<String> notificationTypes;

    private PutNotificationConfigurationRequest(BuilderImpl builder) {
        this.autoScalingGroupName = builder.autoScalingGroupName;
        this.topicARN = builder.topicARN;
        this.notificationTypes = builder.notificationTypes;
    }

    /**
     * <p>
     * The name of the Auto Scaling group.
     * </p>
     * 
     * @return The name of the Auto Scaling group.
     */
    public String autoScalingGroupName() {
        return autoScalingGroupName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Amazon Simple Notification Service (SNS) topic.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Amazon Simple Notification Service (SNS) topic.
     */
    public String topicARN() {
        return topicARN;
    }

    /**
     * <p>
     * The type of event that will cause the notification to be sent. For details about notification types supported by
     * Auto Scaling, see <a>DescribeAutoScalingNotificationTypes</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The type of event that will cause the notification to be sent. For details about notification types
     *         supported by Auto Scaling, see <a>DescribeAutoScalingNotificationTypes</a>.
     */
    public List<String> notificationTypes() {
        return notificationTypes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((autoScalingGroupName() == null) ? 0 : autoScalingGroupName().hashCode());
        hashCode = 31 * hashCode + ((topicARN() == null) ? 0 : topicARN().hashCode());
        hashCode = 31 * hashCode + ((notificationTypes() == null) ? 0 : notificationTypes().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutNotificationConfigurationRequest)) {
            return false;
        }
        PutNotificationConfigurationRequest other = (PutNotificationConfigurationRequest) obj;
        if (other.autoScalingGroupName() == null ^ this.autoScalingGroupName() == null) {
            return false;
        }
        if (other.autoScalingGroupName() != null && !other.autoScalingGroupName().equals(this.autoScalingGroupName())) {
            return false;
        }
        if (other.topicARN() == null ^ this.topicARN() == null) {
            return false;
        }
        if (other.topicARN() != null && !other.topicARN().equals(this.topicARN())) {
            return false;
        }
        if (other.notificationTypes() == null ^ this.notificationTypes() == null) {
            return false;
        }
        if (other.notificationTypes() != null && !other.notificationTypes().equals(this.notificationTypes())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (autoScalingGroupName() != null) {
            sb.append("AutoScalingGroupName: ").append(autoScalingGroupName()).append(",");
        }
        if (topicARN() != null) {
            sb.append("TopicARN: ").append(topicARN()).append(",");
        }
        if (notificationTypes() != null) {
            sb.append("NotificationTypes: ").append(notificationTypes()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, PutNotificationConfigurationRequest> {
        /**
         * <p>
         * The name of the Auto Scaling group.
         * </p>
         * 
         * @param autoScalingGroupName
         *        The name of the Auto Scaling group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoScalingGroupName(String autoScalingGroupName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Amazon Simple Notification Service (SNS) topic.
         * </p>
         * 
         * @param topicARN
         *        The Amazon Resource Name (ARN) of the Amazon Simple Notification Service (SNS) topic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topicARN(String topicARN);

        /**
         * <p>
         * The type of event that will cause the notification to be sent. For details about notification types supported
         * by Auto Scaling, see <a>DescribeAutoScalingNotificationTypes</a>.
         * </p>
         * 
         * @param notificationTypes
         *        The type of event that will cause the notification to be sent. For details about notification types
         *        supported by Auto Scaling, see <a>DescribeAutoScalingNotificationTypes</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notificationTypes(Collection<String> notificationTypes);

        /**
         * <p>
         * The type of event that will cause the notification to be sent. For details about notification types supported
         * by Auto Scaling, see <a>DescribeAutoScalingNotificationTypes</a>.
         * </p>
         * 
         * @param notificationTypes
         *        The type of event that will cause the notification to be sent. For details about notification types
         *        supported by Auto Scaling, see <a>DescribeAutoScalingNotificationTypes</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notificationTypes(String... notificationTypes);
    }

    private static final class BuilderImpl implements Builder {
        private String autoScalingGroupName;

        private String topicARN;

        private List<String> notificationTypes;

        private BuilderImpl() {
        }

        private BuilderImpl(PutNotificationConfigurationRequest model) {
            setAutoScalingGroupName(model.autoScalingGroupName);
            setTopicARN(model.topicARN);
            setNotificationTypes(model.notificationTypes);
        }

        public final String getAutoScalingGroupName() {
            return autoScalingGroupName;
        }

        @Override
        public final Builder autoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
            return this;
        }

        public final void setAutoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
        }

        public final String getTopicARN() {
            return topicARN;
        }

        @Override
        public final Builder topicARN(String topicARN) {
            this.topicARN = topicARN;
            return this;
        }

        public final void setTopicARN(String topicARN) {
            this.topicARN = topicARN;
        }

        public final Collection<String> getNotificationTypes() {
            return notificationTypes;
        }

        @Override
        public final Builder notificationTypes(Collection<String> notificationTypes) {
            this.notificationTypes = AutoScalingNotificationTypesCopier.copy(notificationTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notificationTypes(String... notificationTypes) {
            notificationTypes(Arrays.asList(notificationTypes));
            return this;
        }

        public final void setNotificationTypes(Collection<String> notificationTypes) {
            this.notificationTypes = AutoScalingNotificationTypesCopier.copy(notificationTypes);
        }

        @Override
        public PutNotificationConfigurationRequest build() {
            return new PutNotificationConfigurationRequest(this);
        }
    }
}
