/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an Auto Scaling group.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class AutoScalingGroup implements ToCopyableBuilder<AutoScalingGroup.Builder, AutoScalingGroup> {
    private final String autoScalingGroupName;

    private final String autoScalingGroupARN;

    private final String launchConfigurationName;

    private final Integer minSize;

    private final Integer maxSize;

    private final Integer desiredCapacity;

    private final Integer defaultCooldown;

    private final List<String> availabilityZones;

    private final List<String> loadBalancerNames;

    private final List<String> targetGroupARNs;

    private final String healthCheckType;

    private final Integer healthCheckGracePeriod;

    private final List<Instance> instances;

    private final Instant createdTime;

    private final List<SuspendedProcess> suspendedProcesses;

    private final String placementGroup;

    private final String vpcZoneIdentifier;

    private final List<EnabledMetric> enabledMetrics;

    private final String status;

    private final List<TagDescription> tags;

    private final List<String> terminationPolicies;

    private final Boolean newInstancesProtectedFromScaleIn;

    private AutoScalingGroup(BuilderImpl builder) {
        this.autoScalingGroupName = builder.autoScalingGroupName;
        this.autoScalingGroupARN = builder.autoScalingGroupARN;
        this.launchConfigurationName = builder.launchConfigurationName;
        this.minSize = builder.minSize;
        this.maxSize = builder.maxSize;
        this.desiredCapacity = builder.desiredCapacity;
        this.defaultCooldown = builder.defaultCooldown;
        this.availabilityZones = builder.availabilityZones;
        this.loadBalancerNames = builder.loadBalancerNames;
        this.targetGroupARNs = builder.targetGroupARNs;
        this.healthCheckType = builder.healthCheckType;
        this.healthCheckGracePeriod = builder.healthCheckGracePeriod;
        this.instances = builder.instances;
        this.createdTime = builder.createdTime;
        this.suspendedProcesses = builder.suspendedProcesses;
        this.placementGroup = builder.placementGroup;
        this.vpcZoneIdentifier = builder.vpcZoneIdentifier;
        this.enabledMetrics = builder.enabledMetrics;
        this.status = builder.status;
        this.tags = builder.tags;
        this.terminationPolicies = builder.terminationPolicies;
        this.newInstancesProtectedFromScaleIn = builder.newInstancesProtectedFromScaleIn;
    }

    /**
     * <p>
     * The name of the group.
     * </p>
     * 
     * @return The name of the group.
     */
    public String autoScalingGroupName() {
        return autoScalingGroupName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the group.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the group.
     */
    public String autoScalingGroupARN() {
        return autoScalingGroupARN;
    }

    /**
     * <p>
     * The name of the associated launch configuration.
     * </p>
     * 
     * @return The name of the associated launch configuration.
     */
    public String launchConfigurationName() {
        return launchConfigurationName;
    }

    /**
     * <p>
     * The minimum size of the group.
     * </p>
     * 
     * @return The minimum size of the group.
     */
    public Integer minSize() {
        return minSize;
    }

    /**
     * <p>
     * The maximum size of the group.
     * </p>
     * 
     * @return The maximum size of the group.
     */
    public Integer maxSize() {
        return maxSize;
    }

    /**
     * <p>
     * The desired size of the group.
     * </p>
     * 
     * @return The desired size of the group.
     */
    public Integer desiredCapacity() {
        return desiredCapacity;
    }

    /**
     * <p>
     * The amount of time, in seconds, after a scaling activity completes before another scaling activity can start.
     * </p>
     * 
     * @return The amount of time, in seconds, after a scaling activity completes before another scaling activity can
     *         start.
     */
    public Integer defaultCooldown() {
        return defaultCooldown;
    }

    /**
     * <p>
     * One or more Availability Zones for the group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more Availability Zones for the group.
     */
    public List<String> availabilityZones() {
        return availabilityZones;
    }

    /**
     * <p>
     * One or more load balancers associated with the group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more load balancers associated with the group.
     */
    public List<String> loadBalancerNames() {
        return loadBalancerNames;
    }

    /**
     * <p>
     * The Amazon Resource Names (ARN) of the target groups for your load balancer.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The Amazon Resource Names (ARN) of the target groups for your load balancer.
     */
    public List<String> targetGroupARNs() {
        return targetGroupARNs;
    }

    /**
     * <p>
     * The service to use for the health checks. The valid values are <code>EC2</code> and <code>ELB</code>.
     * </p>
     * 
     * @return The service to use for the health checks. The valid values are <code>EC2</code> and <code>ELB</code>.
     */
    public String healthCheckType() {
        return healthCheckType;
    }

    /**
     * <p>
     * The amount of time, in seconds, that Auto Scaling waits before checking the health status of an EC2 instance that
     * has come into service.
     * </p>
     * 
     * @return The amount of time, in seconds, that Auto Scaling waits before checking the health status of an EC2
     *         instance that has come into service.
     */
    public Integer healthCheckGracePeriod() {
        return healthCheckGracePeriod;
    }

    /**
     * <p>
     * The EC2 instances associated with the group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The EC2 instances associated with the group.
     */
    public List<Instance> instances() {
        return instances;
    }

    /**
     * <p>
     * The date and time the group was created.
     * </p>
     * 
     * @return The date and time the group was created.
     */
    public Instant createdTime() {
        return createdTime;
    }

    /**
     * <p>
     * The suspended processes associated with the group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The suspended processes associated with the group.
     */
    public List<SuspendedProcess> suspendedProcesses() {
        return suspendedProcesses;
    }

    /**
     * <p>
     * The name of the placement group into which you'll launch your instances, if any. For more information, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html">Placement Groups</a> in the
     * <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * 
     * @return The name of the placement group into which you'll launch your instances, if any. For more information,
     *         see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html">Placement
     *         Groups</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     */
    public String placementGroup() {
        return placementGroup;
    }

    /**
     * <p>
     * One or more subnet IDs, if applicable, separated by commas.
     * </p>
     * <p>
     * If you specify <code>VPCZoneIdentifier</code> and <code>AvailabilityZones</code>, ensure that the Availability
     * Zones of the subnets match the values for <code>AvailabilityZones</code>.
     * </p>
     * 
     * @return One or more subnet IDs, if applicable, separated by commas.</p>
     *         <p>
     *         If you specify <code>VPCZoneIdentifier</code> and <code>AvailabilityZones</code>, ensure that the
     *         Availability Zones of the subnets match the values for <code>AvailabilityZones</code>.
     */
    public String vpcZoneIdentifier() {
        return vpcZoneIdentifier;
    }

    /**
     * <p>
     * The metrics enabled for the group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The metrics enabled for the group.
     */
    public List<EnabledMetric> enabledMetrics() {
        return enabledMetrics;
    }

    /**
     * <p>
     * The current state of the group when <a>DeleteAutoScalingGroup</a> is in progress.
     * </p>
     * 
     * @return The current state of the group when <a>DeleteAutoScalingGroup</a> is in progress.
     */
    public String status() {
        return status;
    }

    /**
     * <p>
     * The tags for the group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The tags for the group.
     */
    public List<TagDescription> tags() {
        return tags;
    }

    /**
     * <p>
     * The termination policies for the group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The termination policies for the group.
     */
    public List<String> terminationPolicies() {
        return terminationPolicies;
    }

    /**
     * <p>
     * Indicates whether newly launched instances are protected from termination by Auto Scaling when scaling in.
     * </p>
     * 
     * @return Indicates whether newly launched instances are protected from termination by Auto Scaling when scaling
     *         in.
     */
    public Boolean newInstancesProtectedFromScaleIn() {
        return newInstancesProtectedFromScaleIn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((autoScalingGroupName() == null) ? 0 : autoScalingGroupName().hashCode());
        hashCode = 31 * hashCode + ((autoScalingGroupARN() == null) ? 0 : autoScalingGroupARN().hashCode());
        hashCode = 31 * hashCode + ((launchConfigurationName() == null) ? 0 : launchConfigurationName().hashCode());
        hashCode = 31 * hashCode + ((minSize() == null) ? 0 : minSize().hashCode());
        hashCode = 31 * hashCode + ((maxSize() == null) ? 0 : maxSize().hashCode());
        hashCode = 31 * hashCode + ((desiredCapacity() == null) ? 0 : desiredCapacity().hashCode());
        hashCode = 31 * hashCode + ((defaultCooldown() == null) ? 0 : defaultCooldown().hashCode());
        hashCode = 31 * hashCode + ((availabilityZones() == null) ? 0 : availabilityZones().hashCode());
        hashCode = 31 * hashCode + ((loadBalancerNames() == null) ? 0 : loadBalancerNames().hashCode());
        hashCode = 31 * hashCode + ((targetGroupARNs() == null) ? 0 : targetGroupARNs().hashCode());
        hashCode = 31 * hashCode + ((healthCheckType() == null) ? 0 : healthCheckType().hashCode());
        hashCode = 31 * hashCode + ((healthCheckGracePeriod() == null) ? 0 : healthCheckGracePeriod().hashCode());
        hashCode = 31 * hashCode + ((instances() == null) ? 0 : instances().hashCode());
        hashCode = 31 * hashCode + ((createdTime() == null) ? 0 : createdTime().hashCode());
        hashCode = 31 * hashCode + ((suspendedProcesses() == null) ? 0 : suspendedProcesses().hashCode());
        hashCode = 31 * hashCode + ((placementGroup() == null) ? 0 : placementGroup().hashCode());
        hashCode = 31 * hashCode + ((vpcZoneIdentifier() == null) ? 0 : vpcZoneIdentifier().hashCode());
        hashCode = 31 * hashCode + ((enabledMetrics() == null) ? 0 : enabledMetrics().hashCode());
        hashCode = 31 * hashCode + ((status() == null) ? 0 : status().hashCode());
        hashCode = 31 * hashCode + ((tags() == null) ? 0 : tags().hashCode());
        hashCode = 31 * hashCode + ((terminationPolicies() == null) ? 0 : terminationPolicies().hashCode());
        hashCode = 31 * hashCode
                + ((newInstancesProtectedFromScaleIn() == null) ? 0 : newInstancesProtectedFromScaleIn().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoScalingGroup)) {
            return false;
        }
        AutoScalingGroup other = (AutoScalingGroup) obj;
        if (other.autoScalingGroupName() == null ^ this.autoScalingGroupName() == null) {
            return false;
        }
        if (other.autoScalingGroupName() != null && !other.autoScalingGroupName().equals(this.autoScalingGroupName())) {
            return false;
        }
        if (other.autoScalingGroupARN() == null ^ this.autoScalingGroupARN() == null) {
            return false;
        }
        if (other.autoScalingGroupARN() != null && !other.autoScalingGroupARN().equals(this.autoScalingGroupARN())) {
            return false;
        }
        if (other.launchConfigurationName() == null ^ this.launchConfigurationName() == null) {
            return false;
        }
        if (other.launchConfigurationName() != null && !other.launchConfigurationName().equals(this.launchConfigurationName())) {
            return false;
        }
        if (other.minSize() == null ^ this.minSize() == null) {
            return false;
        }
        if (other.minSize() != null && !other.minSize().equals(this.minSize())) {
            return false;
        }
        if (other.maxSize() == null ^ this.maxSize() == null) {
            return false;
        }
        if (other.maxSize() != null && !other.maxSize().equals(this.maxSize())) {
            return false;
        }
        if (other.desiredCapacity() == null ^ this.desiredCapacity() == null) {
            return false;
        }
        if (other.desiredCapacity() != null && !other.desiredCapacity().equals(this.desiredCapacity())) {
            return false;
        }
        if (other.defaultCooldown() == null ^ this.defaultCooldown() == null) {
            return false;
        }
        if (other.defaultCooldown() != null && !other.defaultCooldown().equals(this.defaultCooldown())) {
            return false;
        }
        if (other.availabilityZones() == null ^ this.availabilityZones() == null) {
            return false;
        }
        if (other.availabilityZones() != null && !other.availabilityZones().equals(this.availabilityZones())) {
            return false;
        }
        if (other.loadBalancerNames() == null ^ this.loadBalancerNames() == null) {
            return false;
        }
        if (other.loadBalancerNames() != null && !other.loadBalancerNames().equals(this.loadBalancerNames())) {
            return false;
        }
        if (other.targetGroupARNs() == null ^ this.targetGroupARNs() == null) {
            return false;
        }
        if (other.targetGroupARNs() != null && !other.targetGroupARNs().equals(this.targetGroupARNs())) {
            return false;
        }
        if (other.healthCheckType() == null ^ this.healthCheckType() == null) {
            return false;
        }
        if (other.healthCheckType() != null && !other.healthCheckType().equals(this.healthCheckType())) {
            return false;
        }
        if (other.healthCheckGracePeriod() == null ^ this.healthCheckGracePeriod() == null) {
            return false;
        }
        if (other.healthCheckGracePeriod() != null && !other.healthCheckGracePeriod().equals(this.healthCheckGracePeriod())) {
            return false;
        }
        if (other.instances() == null ^ this.instances() == null) {
            return false;
        }
        if (other.instances() != null && !other.instances().equals(this.instances())) {
            return false;
        }
        if (other.createdTime() == null ^ this.createdTime() == null) {
            return false;
        }
        if (other.createdTime() != null && !other.createdTime().equals(this.createdTime())) {
            return false;
        }
        if (other.suspendedProcesses() == null ^ this.suspendedProcesses() == null) {
            return false;
        }
        if (other.suspendedProcesses() != null && !other.suspendedProcesses().equals(this.suspendedProcesses())) {
            return false;
        }
        if (other.placementGroup() == null ^ this.placementGroup() == null) {
            return false;
        }
        if (other.placementGroup() != null && !other.placementGroup().equals(this.placementGroup())) {
            return false;
        }
        if (other.vpcZoneIdentifier() == null ^ this.vpcZoneIdentifier() == null) {
            return false;
        }
        if (other.vpcZoneIdentifier() != null && !other.vpcZoneIdentifier().equals(this.vpcZoneIdentifier())) {
            return false;
        }
        if (other.enabledMetrics() == null ^ this.enabledMetrics() == null) {
            return false;
        }
        if (other.enabledMetrics() != null && !other.enabledMetrics().equals(this.enabledMetrics())) {
            return false;
        }
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        if (other.status() != null && !other.status().equals(this.status())) {
            return false;
        }
        if (other.tags() == null ^ this.tags() == null) {
            return false;
        }
        if (other.tags() != null && !other.tags().equals(this.tags())) {
            return false;
        }
        if (other.terminationPolicies() == null ^ this.terminationPolicies() == null) {
            return false;
        }
        if (other.terminationPolicies() != null && !other.terminationPolicies().equals(this.terminationPolicies())) {
            return false;
        }
        if (other.newInstancesProtectedFromScaleIn() == null ^ this.newInstancesProtectedFromScaleIn() == null) {
            return false;
        }
        if (other.newInstancesProtectedFromScaleIn() != null
                && !other.newInstancesProtectedFromScaleIn().equals(this.newInstancesProtectedFromScaleIn())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (autoScalingGroupName() != null) {
            sb.append("AutoScalingGroupName: ").append(autoScalingGroupName()).append(",");
        }
        if (autoScalingGroupARN() != null) {
            sb.append("AutoScalingGroupARN: ").append(autoScalingGroupARN()).append(",");
        }
        if (launchConfigurationName() != null) {
            sb.append("LaunchConfigurationName: ").append(launchConfigurationName()).append(",");
        }
        if (minSize() != null) {
            sb.append("MinSize: ").append(minSize()).append(",");
        }
        if (maxSize() != null) {
            sb.append("MaxSize: ").append(maxSize()).append(",");
        }
        if (desiredCapacity() != null) {
            sb.append("DesiredCapacity: ").append(desiredCapacity()).append(",");
        }
        if (defaultCooldown() != null) {
            sb.append("DefaultCooldown: ").append(defaultCooldown()).append(",");
        }
        if (availabilityZones() != null) {
            sb.append("AvailabilityZones: ").append(availabilityZones()).append(",");
        }
        if (loadBalancerNames() != null) {
            sb.append("LoadBalancerNames: ").append(loadBalancerNames()).append(",");
        }
        if (targetGroupARNs() != null) {
            sb.append("TargetGroupARNs: ").append(targetGroupARNs()).append(",");
        }
        if (healthCheckType() != null) {
            sb.append("HealthCheckType: ").append(healthCheckType()).append(",");
        }
        if (healthCheckGracePeriod() != null) {
            sb.append("HealthCheckGracePeriod: ").append(healthCheckGracePeriod()).append(",");
        }
        if (instances() != null) {
            sb.append("Instances: ").append(instances()).append(",");
        }
        if (createdTime() != null) {
            sb.append("CreatedTime: ").append(createdTime()).append(",");
        }
        if (suspendedProcesses() != null) {
            sb.append("SuspendedProcesses: ").append(suspendedProcesses()).append(",");
        }
        if (placementGroup() != null) {
            sb.append("PlacementGroup: ").append(placementGroup()).append(",");
        }
        if (vpcZoneIdentifier() != null) {
            sb.append("VPCZoneIdentifier: ").append(vpcZoneIdentifier()).append(",");
        }
        if (enabledMetrics() != null) {
            sb.append("EnabledMetrics: ").append(enabledMetrics()).append(",");
        }
        if (status() != null) {
            sb.append("Status: ").append(status()).append(",");
        }
        if (tags() != null) {
            sb.append("Tags: ").append(tags()).append(",");
        }
        if (terminationPolicies() != null) {
            sb.append("TerminationPolicies: ").append(terminationPolicies()).append(",");
        }
        if (newInstancesProtectedFromScaleIn() != null) {
            sb.append("NewInstancesProtectedFromScaleIn: ").append(newInstancesProtectedFromScaleIn()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, AutoScalingGroup> {
        /**
         * <p>
         * The name of the group.
         * </p>
         * 
         * @param autoScalingGroupName
         *        The name of the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoScalingGroupName(String autoScalingGroupName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the group.
         * </p>
         * 
         * @param autoScalingGroupARN
         *        The Amazon Resource Name (ARN) of the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoScalingGroupARN(String autoScalingGroupARN);

        /**
         * <p>
         * The name of the associated launch configuration.
         * </p>
         * 
         * @param launchConfigurationName
         *        The name of the associated launch configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchConfigurationName(String launchConfigurationName);

        /**
         * <p>
         * The minimum size of the group.
         * </p>
         * 
         * @param minSize
         *        The minimum size of the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minSize(Integer minSize);

        /**
         * <p>
         * The maximum size of the group.
         * </p>
         * 
         * @param maxSize
         *        The maximum size of the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxSize(Integer maxSize);

        /**
         * <p>
         * The desired size of the group.
         * </p>
         * 
         * @param desiredCapacity
         *        The desired size of the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder desiredCapacity(Integer desiredCapacity);

        /**
         * <p>
         * The amount of time, in seconds, after a scaling activity completes before another scaling activity can start.
         * </p>
         * 
         * @param defaultCooldown
         *        The amount of time, in seconds, after a scaling activity completes before another scaling activity can
         *        start.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultCooldown(Integer defaultCooldown);

        /**
         * <p>
         * One or more Availability Zones for the group.
         * </p>
         * 
         * @param availabilityZones
         *        One or more Availability Zones for the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZones(Collection<String> availabilityZones);

        /**
         * <p>
         * One or more Availability Zones for the group.
         * </p>
         * 
         * @param availabilityZones
         *        One or more Availability Zones for the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZones(String... availabilityZones);

        /**
         * <p>
         * One or more load balancers associated with the group.
         * </p>
         * 
         * @param loadBalancerNames
         *        One or more load balancers associated with the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loadBalancerNames(Collection<String> loadBalancerNames);

        /**
         * <p>
         * One or more load balancers associated with the group.
         * </p>
         * 
         * @param loadBalancerNames
         *        One or more load balancers associated with the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loadBalancerNames(String... loadBalancerNames);

        /**
         * <p>
         * The Amazon Resource Names (ARN) of the target groups for your load balancer.
         * </p>
         * 
         * @param targetGroupARNs
         *        The Amazon Resource Names (ARN) of the target groups for your load balancer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetGroupARNs(Collection<String> targetGroupARNs);

        /**
         * <p>
         * The Amazon Resource Names (ARN) of the target groups for your load balancer.
         * </p>
         * 
         * @param targetGroupARNs
         *        The Amazon Resource Names (ARN) of the target groups for your load balancer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetGroupARNs(String... targetGroupARNs);

        /**
         * <p>
         * The service to use for the health checks. The valid values are <code>EC2</code> and <code>ELB</code>.
         * </p>
         * 
         * @param healthCheckType
         *        The service to use for the health checks. The valid values are <code>EC2</code> and <code>ELB</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder healthCheckType(String healthCheckType);

        /**
         * <p>
         * The amount of time, in seconds, that Auto Scaling waits before checking the health status of an EC2 instance
         * that has come into service.
         * </p>
         * 
         * @param healthCheckGracePeriod
         *        The amount of time, in seconds, that Auto Scaling waits before checking the health status of an EC2
         *        instance that has come into service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder healthCheckGracePeriod(Integer healthCheckGracePeriod);

        /**
         * <p>
         * The EC2 instances associated with the group.
         * </p>
         * 
         * @param instances
         *        The EC2 instances associated with the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instances(Collection<Instance> instances);

        /**
         * <p>
         * The EC2 instances associated with the group.
         * </p>
         * 
         * @param instances
         *        The EC2 instances associated with the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instances(Instance... instances);

        /**
         * <p>
         * The date and time the group was created.
         * </p>
         * 
         * @param createdTime
         *        The date and time the group was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTime(Instant createdTime);

        /**
         * <p>
         * The suspended processes associated with the group.
         * </p>
         * 
         * @param suspendedProcesses
         *        The suspended processes associated with the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder suspendedProcesses(Collection<SuspendedProcess> suspendedProcesses);

        /**
         * <p>
         * The suspended processes associated with the group.
         * </p>
         * 
         * @param suspendedProcesses
         *        The suspended processes associated with the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder suspendedProcesses(SuspendedProcess... suspendedProcesses);

        /**
         * <p>
         * The name of the placement group into which you'll launch your instances, if any. For more information, see <a
         * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html">Placement Groups</a> in the
         * <i>Amazon Elastic Compute Cloud User Guide</i>.
         * </p>
         * 
         * @param placementGroup
         *        The name of the placement group into which you'll launch your instances, if any. For more information,
         *        see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html">Placement
         *        Groups</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder placementGroup(String placementGroup);

        /**
         * <p>
         * One or more subnet IDs, if applicable, separated by commas.
         * </p>
         * <p>
         * If you specify <code>VPCZoneIdentifier</code> and <code>AvailabilityZones</code>, ensure that the
         * Availability Zones of the subnets match the values for <code>AvailabilityZones</code>.
         * </p>
         * 
         * @param vpcZoneIdentifier
         *        One or more subnet IDs, if applicable, separated by commas.</p>
         *        <p>
         *        If you specify <code>VPCZoneIdentifier</code> and <code>AvailabilityZones</code>, ensure that the
         *        Availability Zones of the subnets match the values for <code>AvailabilityZones</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcZoneIdentifier(String vpcZoneIdentifier);

        /**
         * <p>
         * The metrics enabled for the group.
         * </p>
         * 
         * @param enabledMetrics
         *        The metrics enabled for the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabledMetrics(Collection<EnabledMetric> enabledMetrics);

        /**
         * <p>
         * The metrics enabled for the group.
         * </p>
         * 
         * @param enabledMetrics
         *        The metrics enabled for the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabledMetrics(EnabledMetric... enabledMetrics);

        /**
         * <p>
         * The current state of the group when <a>DeleteAutoScalingGroup</a> is in progress.
         * </p>
         * 
         * @param status
         *        The current state of the group when <a>DeleteAutoScalingGroup</a> is in progress.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * The tags for the group.
         * </p>
         * 
         * @param tags
         *        The tags for the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<TagDescription> tags);

        /**
         * <p>
         * The tags for the group.
         * </p>
         * 
         * @param tags
         *        The tags for the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(TagDescription... tags);

        /**
         * <p>
         * The termination policies for the group.
         * </p>
         * 
         * @param terminationPolicies
         *        The termination policies for the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder terminationPolicies(Collection<String> terminationPolicies);

        /**
         * <p>
         * The termination policies for the group.
         * </p>
         * 
         * @param terminationPolicies
         *        The termination policies for the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder terminationPolicies(String... terminationPolicies);

        /**
         * <p>
         * Indicates whether newly launched instances are protected from termination by Auto Scaling when scaling in.
         * </p>
         * 
         * @param newInstancesProtectedFromScaleIn
         *        Indicates whether newly launched instances are protected from termination by Auto Scaling when scaling
         *        in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder newInstancesProtectedFromScaleIn(Boolean newInstancesProtectedFromScaleIn);
    }

    private static final class BuilderImpl implements Builder {
        private String autoScalingGroupName;

        private String autoScalingGroupARN;

        private String launchConfigurationName;

        private Integer minSize;

        private Integer maxSize;

        private Integer desiredCapacity;

        private Integer defaultCooldown;

        private List<String> availabilityZones;

        private List<String> loadBalancerNames;

        private List<String> targetGroupARNs;

        private String healthCheckType;

        private Integer healthCheckGracePeriod;

        private List<Instance> instances;

        private Instant createdTime;

        private List<SuspendedProcess> suspendedProcesses;

        private String placementGroup;

        private String vpcZoneIdentifier;

        private List<EnabledMetric> enabledMetrics;

        private String status;

        private List<TagDescription> tags;

        private List<String> terminationPolicies;

        private Boolean newInstancesProtectedFromScaleIn;

        private BuilderImpl() {
        }

        private BuilderImpl(AutoScalingGroup model) {
            setAutoScalingGroupName(model.autoScalingGroupName);
            setAutoScalingGroupARN(model.autoScalingGroupARN);
            setLaunchConfigurationName(model.launchConfigurationName);
            setMinSize(model.minSize);
            setMaxSize(model.maxSize);
            setDesiredCapacity(model.desiredCapacity);
            setDefaultCooldown(model.defaultCooldown);
            setAvailabilityZones(model.availabilityZones);
            setLoadBalancerNames(model.loadBalancerNames);
            setTargetGroupARNs(model.targetGroupARNs);
            setHealthCheckType(model.healthCheckType);
            setHealthCheckGracePeriod(model.healthCheckGracePeriod);
            setInstances(model.instances);
            setCreatedTime(model.createdTime);
            setSuspendedProcesses(model.suspendedProcesses);
            setPlacementGroup(model.placementGroup);
            setVPCZoneIdentifier(model.vpcZoneIdentifier);
            setEnabledMetrics(model.enabledMetrics);
            setStatus(model.status);
            setTags(model.tags);
            setTerminationPolicies(model.terminationPolicies);
            setNewInstancesProtectedFromScaleIn(model.newInstancesProtectedFromScaleIn);
        }

        public final String getAutoScalingGroupName() {
            return autoScalingGroupName;
        }

        @Override
        public final Builder autoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
            return this;
        }

        public final void setAutoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
        }

        public final String getAutoScalingGroupARN() {
            return autoScalingGroupARN;
        }

        @Override
        public final Builder autoScalingGroupARN(String autoScalingGroupARN) {
            this.autoScalingGroupARN = autoScalingGroupARN;
            return this;
        }

        public final void setAutoScalingGroupARN(String autoScalingGroupARN) {
            this.autoScalingGroupARN = autoScalingGroupARN;
        }

        public final String getLaunchConfigurationName() {
            return launchConfigurationName;
        }

        @Override
        public final Builder launchConfigurationName(String launchConfigurationName) {
            this.launchConfigurationName = launchConfigurationName;
            return this;
        }

        public final void setLaunchConfigurationName(String launchConfigurationName) {
            this.launchConfigurationName = launchConfigurationName;
        }

        public final Integer getMinSize() {
            return minSize;
        }

        @Override
        public final Builder minSize(Integer minSize) {
            this.minSize = minSize;
            return this;
        }

        public final void setMinSize(Integer minSize) {
            this.minSize = minSize;
        }

        public final Integer getMaxSize() {
            return maxSize;
        }

        @Override
        public final Builder maxSize(Integer maxSize) {
            this.maxSize = maxSize;
            return this;
        }

        public final void setMaxSize(Integer maxSize) {
            this.maxSize = maxSize;
        }

        public final Integer getDesiredCapacity() {
            return desiredCapacity;
        }

        @Override
        public final Builder desiredCapacity(Integer desiredCapacity) {
            this.desiredCapacity = desiredCapacity;
            return this;
        }

        public final void setDesiredCapacity(Integer desiredCapacity) {
            this.desiredCapacity = desiredCapacity;
        }

        public final Integer getDefaultCooldown() {
            return defaultCooldown;
        }

        @Override
        public final Builder defaultCooldown(Integer defaultCooldown) {
            this.defaultCooldown = defaultCooldown;
            return this;
        }

        public final void setDefaultCooldown(Integer defaultCooldown) {
            this.defaultCooldown = defaultCooldown;
        }

        public final Collection<String> getAvailabilityZones() {
            return availabilityZones;
        }

        @Override
        public final Builder availabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = AvailabilityZonesCopier.copy(availabilityZones);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availabilityZones(String... availabilityZones) {
            availabilityZones(Arrays.asList(availabilityZones));
            return this;
        }

        public final void setAvailabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = AvailabilityZonesCopier.copy(availabilityZones);
        }

        public final Collection<String> getLoadBalancerNames() {
            return loadBalancerNames;
        }

        @Override
        public final Builder loadBalancerNames(Collection<String> loadBalancerNames) {
            this.loadBalancerNames = LoadBalancerNamesCopier.copy(loadBalancerNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loadBalancerNames(String... loadBalancerNames) {
            loadBalancerNames(Arrays.asList(loadBalancerNames));
            return this;
        }

        public final void setLoadBalancerNames(Collection<String> loadBalancerNames) {
            this.loadBalancerNames = LoadBalancerNamesCopier.copy(loadBalancerNames);
        }

        public final Collection<String> getTargetGroupARNs() {
            return targetGroupARNs;
        }

        @Override
        public final Builder targetGroupARNs(Collection<String> targetGroupARNs) {
            this.targetGroupARNs = TargetGroupARNsCopier.copy(targetGroupARNs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetGroupARNs(String... targetGroupARNs) {
            targetGroupARNs(Arrays.asList(targetGroupARNs));
            return this;
        }

        public final void setTargetGroupARNs(Collection<String> targetGroupARNs) {
            this.targetGroupARNs = TargetGroupARNsCopier.copy(targetGroupARNs);
        }

        public final String getHealthCheckType() {
            return healthCheckType;
        }

        @Override
        public final Builder healthCheckType(String healthCheckType) {
            this.healthCheckType = healthCheckType;
            return this;
        }

        public final void setHealthCheckType(String healthCheckType) {
            this.healthCheckType = healthCheckType;
        }

        public final Integer getHealthCheckGracePeriod() {
            return healthCheckGracePeriod;
        }

        @Override
        public final Builder healthCheckGracePeriod(Integer healthCheckGracePeriod) {
            this.healthCheckGracePeriod = healthCheckGracePeriod;
            return this;
        }

        public final void setHealthCheckGracePeriod(Integer healthCheckGracePeriod) {
            this.healthCheckGracePeriod = healthCheckGracePeriod;
        }

        public final Collection<Instance> getInstances() {
            return instances;
        }

        @Override
        public final Builder instances(Collection<Instance> instances) {
            this.instances = InstancesCopier.copy(instances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instances(Instance... instances) {
            instances(Arrays.asList(instances));
            return this;
        }

        public final void setInstances(Collection<Instance> instances) {
            this.instances = InstancesCopier.copy(instances);
        }

        public final Instant getCreatedTime() {
            return createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        public final Collection<SuspendedProcess> getSuspendedProcesses() {
            return suspendedProcesses;
        }

        @Override
        public final Builder suspendedProcesses(Collection<SuspendedProcess> suspendedProcesses) {
            this.suspendedProcesses = SuspendedProcessesCopier.copy(suspendedProcesses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder suspendedProcesses(SuspendedProcess... suspendedProcesses) {
            suspendedProcesses(Arrays.asList(suspendedProcesses));
            return this;
        }

        public final void setSuspendedProcesses(Collection<SuspendedProcess> suspendedProcesses) {
            this.suspendedProcesses = SuspendedProcessesCopier.copy(suspendedProcesses);
        }

        public final String getPlacementGroup() {
            return placementGroup;
        }

        @Override
        public final Builder placementGroup(String placementGroup) {
            this.placementGroup = placementGroup;
            return this;
        }

        public final void setPlacementGroup(String placementGroup) {
            this.placementGroup = placementGroup;
        }

        public final String getVPCZoneIdentifier() {
            return vpcZoneIdentifier;
        }

        @Override
        public final Builder vpcZoneIdentifier(String vpcZoneIdentifier) {
            this.vpcZoneIdentifier = vpcZoneIdentifier;
            return this;
        }

        public final void setVPCZoneIdentifier(String vpcZoneIdentifier) {
            this.vpcZoneIdentifier = vpcZoneIdentifier;
        }

        public final Collection<EnabledMetric> getEnabledMetrics() {
            return enabledMetrics;
        }

        @Override
        public final Builder enabledMetrics(Collection<EnabledMetric> enabledMetrics) {
            this.enabledMetrics = EnabledMetricsCopier.copy(enabledMetrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder enabledMetrics(EnabledMetric... enabledMetrics) {
            enabledMetrics(Arrays.asList(enabledMetrics));
            return this;
        }

        public final void setEnabledMetrics(Collection<EnabledMetric> enabledMetrics) {
            this.enabledMetrics = EnabledMetricsCopier.copy(enabledMetrics);
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Collection<TagDescription> getTags() {
            return tags;
        }

        @Override
        public final Builder tags(Collection<TagDescription> tags) {
            this.tags = TagDescriptionListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(TagDescription... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        public final void setTags(Collection<TagDescription> tags) {
            this.tags = TagDescriptionListCopier.copy(tags);
        }

        public final Collection<String> getTerminationPolicies() {
            return terminationPolicies;
        }

        @Override
        public final Builder terminationPolicies(Collection<String> terminationPolicies) {
            this.terminationPolicies = TerminationPoliciesCopier.copy(terminationPolicies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder terminationPolicies(String... terminationPolicies) {
            terminationPolicies(Arrays.asList(terminationPolicies));
            return this;
        }

        public final void setTerminationPolicies(Collection<String> terminationPolicies) {
            this.terminationPolicies = TerminationPoliciesCopier.copy(terminationPolicies);
        }

        public final Boolean getNewInstancesProtectedFromScaleIn() {
            return newInstancesProtectedFromScaleIn;
        }

        @Override
        public final Builder newInstancesProtectedFromScaleIn(Boolean newInstancesProtectedFromScaleIn) {
            this.newInstancesProtectedFromScaleIn = newInstancesProtectedFromScaleIn;
            return this;
        }

        public final void setNewInstancesProtectedFromScaleIn(Boolean newInstancesProtectedFromScaleIn) {
            this.newInstancesProtectedFromScaleIn = newInstancesProtectedFromScaleIn;
        }

        @Override
        public AutoScalingGroup build() {
            return new AutoScalingGroup(this);
        }
    }
}
