/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.autoscaling.model.ProcessType;
import software.amazon.awssdk.services.autoscaling.model.ProcessesCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeScalingProcessTypesResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeScalingProcessTypesResponse> {
    private final List<ProcessType> processes;

    private DescribeScalingProcessTypesResponse(BuilderImpl builder) {
        this.processes = builder.processes;
    }

    public List<ProcessType> processes() {
        return this.processes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.processes() == null ? 0 : this.processes().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeScalingProcessTypesResponse)) {
            return false;
        }
        DescribeScalingProcessTypesResponse other = (DescribeScalingProcessTypesResponse)((Object)obj);
        if (other.processes() == null ^ this.processes() == null) {
            return false;
        }
        return other.processes() == null || other.processes().equals(this.processes());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.processes() != null) {
            sb.append("Processes: ").append(this.processes()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<ProcessType> processes;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeScalingProcessTypesResponse model) {
            this.setProcesses(model.processes);
        }

        public final Collection<ProcessType> getProcesses() {
            return this.processes;
        }

        @Override
        public final Builder processes(Collection<ProcessType> processes) {
            this.processes = ProcessesCopier.copy(processes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder processes(ProcessType ... processes) {
            this.processes(Arrays.asList(processes));
            return this;
        }

        public final void setProcesses(Collection<ProcessType> processes) {
            this.processes = ProcessesCopier.copy(processes);
        }

        public DescribeScalingProcessTypesResponse build() {
            return new DescribeScalingProcessTypesResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeScalingProcessTypesResponse> {
        public Builder processes(Collection<ProcessType> var1);

        public Builder processes(ProcessType ... var1);
    }
}

