/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.transform;

import javax.annotation.Generated;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.services.autoscaling.model.*;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.util.StringUtils;

/**
 * CompleteLifecycleActionRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class CompleteLifecycleActionRequestMarshaller implements
        Marshaller<Request<CompleteLifecycleActionRequest>, CompleteLifecycleActionRequest> {

    public Request<CompleteLifecycleActionRequest> marshall(CompleteLifecycleActionRequest completeLifecycleActionRequest) {

        if (completeLifecycleActionRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<CompleteLifecycleActionRequest> request = new DefaultRequest<CompleteLifecycleActionRequest>(
                completeLifecycleActionRequest, "AutoScalingClient");
        request.addParameter("Action", "CompleteLifecycleAction");
        request.addParameter("Version", "2011-01-01");
        request.setHttpMethod(HttpMethodName.POST);

        if (completeLifecycleActionRequest.lifecycleHookName() != null) {
            request.addParameter("LifecycleHookName", StringUtils.fromString(completeLifecycleActionRequest.lifecycleHookName()));
        }

        if (completeLifecycleActionRequest.autoScalingGroupName() != null) {
            request.addParameter("AutoScalingGroupName",
                    StringUtils.fromString(completeLifecycleActionRequest.autoScalingGroupName()));
        }

        if (completeLifecycleActionRequest.lifecycleActionToken() != null) {
            request.addParameter("LifecycleActionToken",
                    StringUtils.fromString(completeLifecycleActionRequest.lifecycleActionToken()));
        }

        if (completeLifecycleActionRequest.lifecycleActionResult() != null) {
            request.addParameter("LifecycleActionResult",
                    StringUtils.fromString(completeLifecycleActionRequest.lifecycleActionResult()));
        }

        if (completeLifecycleActionRequest.instanceId() != null) {
            request.addParameter("InstanceId", StringUtils.fromString(completeLifecycleActionRequest.instanceId()));
        }

        return request;
    }

}
