/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class TerminateInstanceInAutoScalingGroupRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<TerminateInstanceInAutoScalingGroupRequest.Builder, TerminateInstanceInAutoScalingGroupRequest> {
    private final String instanceId;

    private final Boolean shouldDecrementDesiredCapacity;

    private TerminateInstanceInAutoScalingGroupRequest(BuilderImpl builder) {
        this.instanceId = builder.instanceId;
        this.shouldDecrementDesiredCapacity = builder.shouldDecrementDesiredCapacity;
    }

    /**
     * <p>
     * The ID of the instance.
     * </p>
     * 
     * @return The ID of the instance.
     */
    public String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * If <code>true</code>, terminating the instance also decrements the size of the Auto Scaling group.
     * </p>
     * 
     * @return If <code>true</code>, terminating the instance also decrements the size of the Auto Scaling group.
     */
    public Boolean shouldDecrementDesiredCapacity() {
        return shouldDecrementDesiredCapacity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((instanceId() == null) ? 0 : instanceId().hashCode());
        hashCode = 31 * hashCode + ((shouldDecrementDesiredCapacity() == null) ? 0 : shouldDecrementDesiredCapacity().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TerminateInstanceInAutoScalingGroupRequest)) {
            return false;
        }
        TerminateInstanceInAutoScalingGroupRequest other = (TerminateInstanceInAutoScalingGroupRequest) obj;
        if (other.instanceId() == null ^ this.instanceId() == null) {
            return false;
        }
        if (other.instanceId() != null && !other.instanceId().equals(this.instanceId())) {
            return false;
        }
        if (other.shouldDecrementDesiredCapacity() == null ^ this.shouldDecrementDesiredCapacity() == null) {
            return false;
        }
        if (other.shouldDecrementDesiredCapacity() != null
                && !other.shouldDecrementDesiredCapacity().equals(this.shouldDecrementDesiredCapacity())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (instanceId() != null) {
            sb.append("InstanceId: ").append(instanceId()).append(",");
        }
        if (shouldDecrementDesiredCapacity() != null) {
            sb.append("ShouldDecrementDesiredCapacity: ").append(shouldDecrementDesiredCapacity()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, TerminateInstanceInAutoScalingGroupRequest> {
        /**
         * <p>
         * The ID of the instance.
         * </p>
         * 
         * @param instanceId
         *        The ID of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * If <code>true</code>, terminating the instance also decrements the size of the Auto Scaling group.
         * </p>
         * 
         * @param shouldDecrementDesiredCapacity
         *        If <code>true</code>, terminating the instance also decrements the size of the Auto Scaling group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shouldDecrementDesiredCapacity(Boolean shouldDecrementDesiredCapacity);
    }

    private static final class BuilderImpl implements Builder {
        private String instanceId;

        private Boolean shouldDecrementDesiredCapacity;

        private BuilderImpl() {
        }

        private BuilderImpl(TerminateInstanceInAutoScalingGroupRequest model) {
            setInstanceId(model.instanceId);
            setShouldDecrementDesiredCapacity(model.shouldDecrementDesiredCapacity);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final Boolean getShouldDecrementDesiredCapacity() {
            return shouldDecrementDesiredCapacity;
        }

        @Override
        public final Builder shouldDecrementDesiredCapacity(Boolean shouldDecrementDesiredCapacity) {
            this.shouldDecrementDesiredCapacity = shouldDecrementDesiredCapacity;
            return this;
        }

        public final void setShouldDecrementDesiredCapacity(Boolean shouldDecrementDesiredCapacity) {
            this.shouldDecrementDesiredCapacity = shouldDecrementDesiredCapacity;
        }

        @Override
        public TerminateInstanceInAutoScalingGroupRequest build() {
            return new TerminateInstanceInAutoScalingGroupRequest(this);
        }
    }
}
