/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class SetDesiredCapacityRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<SetDesiredCapacityRequest.Builder, SetDesiredCapacityRequest> {
    private final String autoScalingGroupName;

    private final Integer desiredCapacity;

    private final Boolean honorCooldown;

    private SetDesiredCapacityRequest(BuilderImpl builder) {
        this.autoScalingGroupName = builder.autoScalingGroupName;
        this.desiredCapacity = builder.desiredCapacity;
        this.honorCooldown = builder.honorCooldown;
    }

    /**
     * <p>
     * The name of the Auto Scaling group.
     * </p>
     * 
     * @return The name of the Auto Scaling group.
     */
    public String autoScalingGroupName() {
        return autoScalingGroupName;
    }

    /**
     * <p>
     * The number of EC2 instances that should be running in the Auto Scaling group.
     * </p>
     * 
     * @return The number of EC2 instances that should be running in the Auto Scaling group.
     */
    public Integer desiredCapacity() {
        return desiredCapacity;
    }

    /**
     * <p>
     * By default, <code>SetDesiredCapacity</code> overrides any cooldown period associated with the Auto Scaling group.
     * Specify <code>True</code> to make Auto Scaling to wait for the cool-down period associated with the Auto Scaling
     * group to complete before initiating a scaling activity to set your Auto Scaling group to its new capacity.
     * </p>
     * 
     * @return By default, <code>SetDesiredCapacity</code> overrides any cooldown period associated with the Auto
     *         Scaling group. Specify <code>True</code> to make Auto Scaling to wait for the cool-down period associated
     *         with the Auto Scaling group to complete before initiating a scaling activity to set your Auto Scaling
     *         group to its new capacity.
     */
    public Boolean honorCooldown() {
        return honorCooldown;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((autoScalingGroupName() == null) ? 0 : autoScalingGroupName().hashCode());
        hashCode = 31 * hashCode + ((desiredCapacity() == null) ? 0 : desiredCapacity().hashCode());
        hashCode = 31 * hashCode + ((honorCooldown() == null) ? 0 : honorCooldown().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetDesiredCapacityRequest)) {
            return false;
        }
        SetDesiredCapacityRequest other = (SetDesiredCapacityRequest) obj;
        if (other.autoScalingGroupName() == null ^ this.autoScalingGroupName() == null) {
            return false;
        }
        if (other.autoScalingGroupName() != null && !other.autoScalingGroupName().equals(this.autoScalingGroupName())) {
            return false;
        }
        if (other.desiredCapacity() == null ^ this.desiredCapacity() == null) {
            return false;
        }
        if (other.desiredCapacity() != null && !other.desiredCapacity().equals(this.desiredCapacity())) {
            return false;
        }
        if (other.honorCooldown() == null ^ this.honorCooldown() == null) {
            return false;
        }
        if (other.honorCooldown() != null && !other.honorCooldown().equals(this.honorCooldown())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (autoScalingGroupName() != null) {
            sb.append("AutoScalingGroupName: ").append(autoScalingGroupName()).append(",");
        }
        if (desiredCapacity() != null) {
            sb.append("DesiredCapacity: ").append(desiredCapacity()).append(",");
        }
        if (honorCooldown() != null) {
            sb.append("HonorCooldown: ").append(honorCooldown()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, SetDesiredCapacityRequest> {
        /**
         * <p>
         * The name of the Auto Scaling group.
         * </p>
         * 
         * @param autoScalingGroupName
         *        The name of the Auto Scaling group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoScalingGroupName(String autoScalingGroupName);

        /**
         * <p>
         * The number of EC2 instances that should be running in the Auto Scaling group.
         * </p>
         * 
         * @param desiredCapacity
         *        The number of EC2 instances that should be running in the Auto Scaling group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder desiredCapacity(Integer desiredCapacity);

        /**
         * <p>
         * By default, <code>SetDesiredCapacity</code> overrides any cooldown period associated with the Auto Scaling
         * group. Specify <code>True</code> to make Auto Scaling to wait for the cool-down period associated with the
         * Auto Scaling group to complete before initiating a scaling activity to set your Auto Scaling group to its new
         * capacity.
         * </p>
         * 
         * @param honorCooldown
         *        By default, <code>SetDesiredCapacity</code> overrides any cooldown period associated with the Auto
         *        Scaling group. Specify <code>True</code> to make Auto Scaling to wait for the cool-down period
         *        associated with the Auto Scaling group to complete before initiating a scaling activity to set your
         *        Auto Scaling group to its new capacity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder honorCooldown(Boolean honorCooldown);
    }

    private static final class BuilderImpl implements Builder {
        private String autoScalingGroupName;

        private Integer desiredCapacity;

        private Boolean honorCooldown;

        private BuilderImpl() {
        }

        private BuilderImpl(SetDesiredCapacityRequest model) {
            setAutoScalingGroupName(model.autoScalingGroupName);
            setDesiredCapacity(model.desiredCapacity);
            setHonorCooldown(model.honorCooldown);
        }

        public final String getAutoScalingGroupName() {
            return autoScalingGroupName;
        }

        @Override
        public final Builder autoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
            return this;
        }

        public final void setAutoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
        }

        public final Integer getDesiredCapacity() {
            return desiredCapacity;
        }

        @Override
        public final Builder desiredCapacity(Integer desiredCapacity) {
            this.desiredCapacity = desiredCapacity;
            return this;
        }

        public final void setDesiredCapacity(Integer desiredCapacity) {
            this.desiredCapacity = desiredCapacity;
        }

        public final Boolean getHonorCooldown() {
            return honorCooldown;
        }

        @Override
        public final Builder honorCooldown(Boolean honorCooldown) {
            this.honorCooldown = honorCooldown;
            return this;
        }

        public final void setHonorCooldown(Boolean honorCooldown) {
            this.honorCooldown = honorCooldown;
        }

        @Override
        public SetDesiredCapacityRequest build() {
            return new SetDesiredCapacityRequest(this);
        }
    }
}
