/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class RecordLifecycleActionHeartbeatRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<RecordLifecycleActionHeartbeatRequest.Builder, RecordLifecycleActionHeartbeatRequest> {
    private final String lifecycleHookName;

    private final String autoScalingGroupName;

    private final String lifecycleActionToken;

    private final String instanceId;

    private RecordLifecycleActionHeartbeatRequest(BuilderImpl builder) {
        this.lifecycleHookName = builder.lifecycleHookName;
        this.autoScalingGroupName = builder.autoScalingGroupName;
        this.lifecycleActionToken = builder.lifecycleActionToken;
        this.instanceId = builder.instanceId;
    }

    /**
     * <p>
     * The name of the lifecycle hook.
     * </p>
     * 
     * @return The name of the lifecycle hook.
     */
    public String lifecycleHookName() {
        return lifecycleHookName;
    }

    /**
     * <p>
     * The name of the Auto Scaling group for the hook.
     * </p>
     * 
     * @return The name of the Auto Scaling group for the hook.
     */
    public String autoScalingGroupName() {
        return autoScalingGroupName;
    }

    /**
     * <p>
     * A token that uniquely identifies a specific lifecycle action associated with an instance. Auto Scaling sends this
     * token to the notification target you specified when you created the lifecycle hook.
     * </p>
     * 
     * @return A token that uniquely identifies a specific lifecycle action associated with an instance. Auto Scaling
     *         sends this token to the notification target you specified when you created the lifecycle hook.
     */
    public String lifecycleActionToken() {
        return lifecycleActionToken;
    }

    /**
     * <p>
     * The ID of the instance.
     * </p>
     * 
     * @return The ID of the instance.
     */
    public String instanceId() {
        return instanceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((lifecycleHookName() == null) ? 0 : lifecycleHookName().hashCode());
        hashCode = 31 * hashCode + ((autoScalingGroupName() == null) ? 0 : autoScalingGroupName().hashCode());
        hashCode = 31 * hashCode + ((lifecycleActionToken() == null) ? 0 : lifecycleActionToken().hashCode());
        hashCode = 31 * hashCode + ((instanceId() == null) ? 0 : instanceId().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecordLifecycleActionHeartbeatRequest)) {
            return false;
        }
        RecordLifecycleActionHeartbeatRequest other = (RecordLifecycleActionHeartbeatRequest) obj;
        if (other.lifecycleHookName() == null ^ this.lifecycleHookName() == null) {
            return false;
        }
        if (other.lifecycleHookName() != null && !other.lifecycleHookName().equals(this.lifecycleHookName())) {
            return false;
        }
        if (other.autoScalingGroupName() == null ^ this.autoScalingGroupName() == null) {
            return false;
        }
        if (other.autoScalingGroupName() != null && !other.autoScalingGroupName().equals(this.autoScalingGroupName())) {
            return false;
        }
        if (other.lifecycleActionToken() == null ^ this.lifecycleActionToken() == null) {
            return false;
        }
        if (other.lifecycleActionToken() != null && !other.lifecycleActionToken().equals(this.lifecycleActionToken())) {
            return false;
        }
        if (other.instanceId() == null ^ this.instanceId() == null) {
            return false;
        }
        if (other.instanceId() != null && !other.instanceId().equals(this.instanceId())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (lifecycleHookName() != null) {
            sb.append("LifecycleHookName: ").append(lifecycleHookName()).append(",");
        }
        if (autoScalingGroupName() != null) {
            sb.append("AutoScalingGroupName: ").append(autoScalingGroupName()).append(",");
        }
        if (lifecycleActionToken() != null) {
            sb.append("LifecycleActionToken: ").append(lifecycleActionToken()).append(",");
        }
        if (instanceId() != null) {
            sb.append("InstanceId: ").append(instanceId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, RecordLifecycleActionHeartbeatRequest> {
        /**
         * <p>
         * The name of the lifecycle hook.
         * </p>
         * 
         * @param lifecycleHookName
         *        The name of the lifecycle hook.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lifecycleHookName(String lifecycleHookName);

        /**
         * <p>
         * The name of the Auto Scaling group for the hook.
         * </p>
         * 
         * @param autoScalingGroupName
         *        The name of the Auto Scaling group for the hook.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoScalingGroupName(String autoScalingGroupName);

        /**
         * <p>
         * A token that uniquely identifies a specific lifecycle action associated with an instance. Auto Scaling sends
         * this token to the notification target you specified when you created the lifecycle hook.
         * </p>
         * 
         * @param lifecycleActionToken
         *        A token that uniquely identifies a specific lifecycle action associated with an instance. Auto Scaling
         *        sends this token to the notification target you specified when you created the lifecycle hook.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lifecycleActionToken(String lifecycleActionToken);

        /**
         * <p>
         * The ID of the instance.
         * </p>
         * 
         * @param instanceId
         *        The ID of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);
    }

    private static final class BuilderImpl implements Builder {
        private String lifecycleHookName;

        private String autoScalingGroupName;

        private String lifecycleActionToken;

        private String instanceId;

        private BuilderImpl() {
        }

        private BuilderImpl(RecordLifecycleActionHeartbeatRequest model) {
            setLifecycleHookName(model.lifecycleHookName);
            setAutoScalingGroupName(model.autoScalingGroupName);
            setLifecycleActionToken(model.lifecycleActionToken);
            setInstanceId(model.instanceId);
        }

        public final String getLifecycleHookName() {
            return lifecycleHookName;
        }

        @Override
        public final Builder lifecycleHookName(String lifecycleHookName) {
            this.lifecycleHookName = lifecycleHookName;
            return this;
        }

        public final void setLifecycleHookName(String lifecycleHookName) {
            this.lifecycleHookName = lifecycleHookName;
        }

        public final String getAutoScalingGroupName() {
            return autoScalingGroupName;
        }

        @Override
        public final Builder autoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
            return this;
        }

        public final void setAutoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
        }

        public final String getLifecycleActionToken() {
            return lifecycleActionToken;
        }

        @Override
        public final Builder lifecycleActionToken(String lifecycleActionToken) {
            this.lifecycleActionToken = lifecycleActionToken;
            return this;
        }

        public final void setLifecycleActionToken(String lifecycleActionToken) {
            this.lifecycleActionToken = lifecycleActionToken;
        }

        public final String getInstanceId() {
            return instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public RecordLifecycleActionHeartbeatRequest build() {
            return new RecordLifecycleActionHeartbeatRequest(this);
        }
    }
}
