/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class PutLifecycleHookRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<PutLifecycleHookRequest.Builder, PutLifecycleHookRequest> {
    private final String lifecycleHookName;

    private final String autoScalingGroupName;

    private final String lifecycleTransition;

    private final String roleARN;

    private final String notificationTargetARN;

    private final String notificationMetadata;

    private final Integer heartbeatTimeout;

    private final String defaultResult;

    private PutLifecycleHookRequest(BuilderImpl builder) {
        this.lifecycleHookName = builder.lifecycleHookName;
        this.autoScalingGroupName = builder.autoScalingGroupName;
        this.lifecycleTransition = builder.lifecycleTransition;
        this.roleARN = builder.roleARN;
        this.notificationTargetARN = builder.notificationTargetARN;
        this.notificationMetadata = builder.notificationMetadata;
        this.heartbeatTimeout = builder.heartbeatTimeout;
        this.defaultResult = builder.defaultResult;
    }

    /**
     * <p>
     * The name of the lifecycle hook.
     * </p>
     * 
     * @return The name of the lifecycle hook.
     */
    public String lifecycleHookName() {
        return lifecycleHookName;
    }

    /**
     * <p>
     * The name of the Auto Scaling group to which you want to assign the lifecycle hook.
     * </p>
     * 
     * @return The name of the Auto Scaling group to which you want to assign the lifecycle hook.
     */
    public String autoScalingGroupName() {
        return autoScalingGroupName;
    }

    /**
     * <p>
     * The instance state to which you want to attach the lifecycle hook. For a list of lifecycle hook types, see
     * <a>DescribeLifecycleHookTypes</a>.
     * </p>
     * <p>
     * This parameter is required for new lifecycle hooks, but optional when updating existing hooks.
     * </p>
     * 
     * @return The instance state to which you want to attach the lifecycle hook. For a list of lifecycle hook types,
     *         see <a>DescribeLifecycleHookTypes</a>.</p>
     *         <p>
     *         This parameter is required for new lifecycle hooks, but optional when updating existing hooks.
     */
    public String lifecycleTransition() {
        return lifecycleTransition;
    }

    /**
     * <p>
     * The ARN of the IAM role that allows the Auto Scaling group to publish to the specified notification target.
     * </p>
     * <p>
     * This parameter is required for new lifecycle hooks, but optional when updating existing hooks.
     * </p>
     * 
     * @return The ARN of the IAM role that allows the Auto Scaling group to publish to the specified notification
     *         target.</p>
     *         <p>
     *         This parameter is required for new lifecycle hooks, but optional when updating existing hooks.
     */
    public String roleARN() {
        return roleARN;
    }

    /**
     * <p>
     * The ARN of the notification target that Auto Scaling will use to notify you when an instance is in the transition
     * state for the lifecycle hook. This target can be either an SQS queue or an SNS topic. If you specify an empty
     * string, this overrides the current ARN.
     * </p>
     * <p>
     * This operation uses the JSON format when sending notifications to an Amazon SQS queue, and an email key/value
     * pair format when sending notifications to an Amazon SNS topic.
     * </p>
     * <p>
     * When you specify a notification target, Auto Scaling sends it a test message. Test messages contains the
     * following additional key/value pair: <code>"Event": "autoscaling:TEST_NOTIFICATION"</code>.
     * </p>
     * 
     * @return The ARN of the notification target that Auto Scaling will use to notify you when an instance is in the
     *         transition state for the lifecycle hook. This target can be either an SQS queue or an SNS topic. If you
     *         specify an empty string, this overrides the current ARN.</p>
     *         <p>
     *         This operation uses the JSON format when sending notifications to an Amazon SQS queue, and an email
     *         key/value pair format when sending notifications to an Amazon SNS topic.
     *         </p>
     *         <p>
     *         When you specify a notification target, Auto Scaling sends it a test message. Test messages contains the
     *         following additional key/value pair: <code>"Event": "autoscaling:TEST_NOTIFICATION"</code>.
     */
    public String notificationTargetARN() {
        return notificationTargetARN;
    }

    /**
     * <p>
     * Contains additional information that you want to include any time Auto Scaling sends a message to the
     * notification target.
     * </p>
     * 
     * @return Contains additional information that you want to include any time Auto Scaling sends a message to the
     *         notification target.
     */
    public String notificationMetadata() {
        return notificationMetadata;
    }

    /**
     * <p>
     * The amount of time, in seconds, that can elapse before the lifecycle hook times out. When the lifecycle hook
     * times out, Auto Scaling performs the default action. You can prevent the lifecycle hook from timing out by
     * calling <a>RecordLifecycleActionHeartbeat</a>. The default is 3600 seconds (1 hour).
     * </p>
     * 
     * @return The amount of time, in seconds, that can elapse before the lifecycle hook times out. When the lifecycle
     *         hook times out, Auto Scaling performs the default action. You can prevent the lifecycle hook from timing
     *         out by calling <a>RecordLifecycleActionHeartbeat</a>. The default is 3600 seconds (1 hour).
     */
    public Integer heartbeatTimeout() {
        return heartbeatTimeout;
    }

    /**
     * <p>
     * Defines the action the Auto Scaling group should take when the lifecycle hook timeout elapses or if an unexpected
     * failure occurs. This parameter can be either <code>CONTINUE</code> or <code>ABANDON</code>. The default value is
     * <code>ABANDON</code>.
     * </p>
     * 
     * @return Defines the action the Auto Scaling group should take when the lifecycle hook timeout elapses or if an
     *         unexpected failure occurs. This parameter can be either <code>CONTINUE</code> or <code>ABANDON</code>.
     *         The default value is <code>ABANDON</code>.
     */
    public String defaultResult() {
        return defaultResult;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((lifecycleHookName() == null) ? 0 : lifecycleHookName().hashCode());
        hashCode = 31 * hashCode + ((autoScalingGroupName() == null) ? 0 : autoScalingGroupName().hashCode());
        hashCode = 31 * hashCode + ((lifecycleTransition() == null) ? 0 : lifecycleTransition().hashCode());
        hashCode = 31 * hashCode + ((roleARN() == null) ? 0 : roleARN().hashCode());
        hashCode = 31 * hashCode + ((notificationTargetARN() == null) ? 0 : notificationTargetARN().hashCode());
        hashCode = 31 * hashCode + ((notificationMetadata() == null) ? 0 : notificationMetadata().hashCode());
        hashCode = 31 * hashCode + ((heartbeatTimeout() == null) ? 0 : heartbeatTimeout().hashCode());
        hashCode = 31 * hashCode + ((defaultResult() == null) ? 0 : defaultResult().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutLifecycleHookRequest)) {
            return false;
        }
        PutLifecycleHookRequest other = (PutLifecycleHookRequest) obj;
        if (other.lifecycleHookName() == null ^ this.lifecycleHookName() == null) {
            return false;
        }
        if (other.lifecycleHookName() != null && !other.lifecycleHookName().equals(this.lifecycleHookName())) {
            return false;
        }
        if (other.autoScalingGroupName() == null ^ this.autoScalingGroupName() == null) {
            return false;
        }
        if (other.autoScalingGroupName() != null && !other.autoScalingGroupName().equals(this.autoScalingGroupName())) {
            return false;
        }
        if (other.lifecycleTransition() == null ^ this.lifecycleTransition() == null) {
            return false;
        }
        if (other.lifecycleTransition() != null && !other.lifecycleTransition().equals(this.lifecycleTransition())) {
            return false;
        }
        if (other.roleARN() == null ^ this.roleARN() == null) {
            return false;
        }
        if (other.roleARN() != null && !other.roleARN().equals(this.roleARN())) {
            return false;
        }
        if (other.notificationTargetARN() == null ^ this.notificationTargetARN() == null) {
            return false;
        }
        if (other.notificationTargetARN() != null && !other.notificationTargetARN().equals(this.notificationTargetARN())) {
            return false;
        }
        if (other.notificationMetadata() == null ^ this.notificationMetadata() == null) {
            return false;
        }
        if (other.notificationMetadata() != null && !other.notificationMetadata().equals(this.notificationMetadata())) {
            return false;
        }
        if (other.heartbeatTimeout() == null ^ this.heartbeatTimeout() == null) {
            return false;
        }
        if (other.heartbeatTimeout() != null && !other.heartbeatTimeout().equals(this.heartbeatTimeout())) {
            return false;
        }
        if (other.defaultResult() == null ^ this.defaultResult() == null) {
            return false;
        }
        if (other.defaultResult() != null && !other.defaultResult().equals(this.defaultResult())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (lifecycleHookName() != null) {
            sb.append("LifecycleHookName: ").append(lifecycleHookName()).append(",");
        }
        if (autoScalingGroupName() != null) {
            sb.append("AutoScalingGroupName: ").append(autoScalingGroupName()).append(",");
        }
        if (lifecycleTransition() != null) {
            sb.append("LifecycleTransition: ").append(lifecycleTransition()).append(",");
        }
        if (roleARN() != null) {
            sb.append("RoleARN: ").append(roleARN()).append(",");
        }
        if (notificationTargetARN() != null) {
            sb.append("NotificationTargetARN: ").append(notificationTargetARN()).append(",");
        }
        if (notificationMetadata() != null) {
            sb.append("NotificationMetadata: ").append(notificationMetadata()).append(",");
        }
        if (heartbeatTimeout() != null) {
            sb.append("HeartbeatTimeout: ").append(heartbeatTimeout()).append(",");
        }
        if (defaultResult() != null) {
            sb.append("DefaultResult: ").append(defaultResult()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, PutLifecycleHookRequest> {
        /**
         * <p>
         * The name of the lifecycle hook.
         * </p>
         * 
         * @param lifecycleHookName
         *        The name of the lifecycle hook.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lifecycleHookName(String lifecycleHookName);

        /**
         * <p>
         * The name of the Auto Scaling group to which you want to assign the lifecycle hook.
         * </p>
         * 
         * @param autoScalingGroupName
         *        The name of the Auto Scaling group to which you want to assign the lifecycle hook.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoScalingGroupName(String autoScalingGroupName);

        /**
         * <p>
         * The instance state to which you want to attach the lifecycle hook. For a list of lifecycle hook types, see
         * <a>DescribeLifecycleHookTypes</a>.
         * </p>
         * <p>
         * This parameter is required for new lifecycle hooks, but optional when updating existing hooks.
         * </p>
         * 
         * @param lifecycleTransition
         *        The instance state to which you want to attach the lifecycle hook. For a list of lifecycle hook types,
         *        see <a>DescribeLifecycleHookTypes</a>.</p>
         *        <p>
         *        This parameter is required for new lifecycle hooks, but optional when updating existing hooks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lifecycleTransition(String lifecycleTransition);

        /**
         * <p>
         * The ARN of the IAM role that allows the Auto Scaling group to publish to the specified notification target.
         * </p>
         * <p>
         * This parameter is required for new lifecycle hooks, but optional when updating existing hooks.
         * </p>
         * 
         * @param roleARN
         *        The ARN of the IAM role that allows the Auto Scaling group to publish to the specified notification
         *        target.</p>
         *        <p>
         *        This parameter is required for new lifecycle hooks, but optional when updating existing hooks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleARN(String roleARN);

        /**
         * <p>
         * The ARN of the notification target that Auto Scaling will use to notify you when an instance is in the
         * transition state for the lifecycle hook. This target can be either an SQS queue or an SNS topic. If you
         * specify an empty string, this overrides the current ARN.
         * </p>
         * <p>
         * This operation uses the JSON format when sending notifications to an Amazon SQS queue, and an email key/value
         * pair format when sending notifications to an Amazon SNS topic.
         * </p>
         * <p>
         * When you specify a notification target, Auto Scaling sends it a test message. Test messages contains the
         * following additional key/value pair: <code>"Event": "autoscaling:TEST_NOTIFICATION"</code>.
         * </p>
         * 
         * @param notificationTargetARN
         *        The ARN of the notification target that Auto Scaling will use to notify you when an instance is in the
         *        transition state for the lifecycle hook. This target can be either an SQS queue or an SNS topic. If
         *        you specify an empty string, this overrides the current ARN.</p>
         *        <p>
         *        This operation uses the JSON format when sending notifications to an Amazon SQS queue, and an email
         *        key/value pair format when sending notifications to an Amazon SNS topic.
         *        </p>
         *        <p>
         *        When you specify a notification target, Auto Scaling sends it a test message. Test messages contains
         *        the following additional key/value pair: <code>"Event": "autoscaling:TEST_NOTIFICATION"</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notificationTargetARN(String notificationTargetARN);

        /**
         * <p>
         * Contains additional information that you want to include any time Auto Scaling sends a message to the
         * notification target.
         * </p>
         * 
         * @param notificationMetadata
         *        Contains additional information that you want to include any time Auto Scaling sends a message to the
         *        notification target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notificationMetadata(String notificationMetadata);

        /**
         * <p>
         * The amount of time, in seconds, that can elapse before the lifecycle hook times out. When the lifecycle hook
         * times out, Auto Scaling performs the default action. You can prevent the lifecycle hook from timing out by
         * calling <a>RecordLifecycleActionHeartbeat</a>. The default is 3600 seconds (1 hour).
         * </p>
         * 
         * @param heartbeatTimeout
         *        The amount of time, in seconds, that can elapse before the lifecycle hook times out. When the
         *        lifecycle hook times out, Auto Scaling performs the default action. You can prevent the lifecycle hook
         *        from timing out by calling <a>RecordLifecycleActionHeartbeat</a>. The default is 3600 seconds (1
         *        hour).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder heartbeatTimeout(Integer heartbeatTimeout);

        /**
         * <p>
         * Defines the action the Auto Scaling group should take when the lifecycle hook timeout elapses or if an
         * unexpected failure occurs. This parameter can be either <code>CONTINUE</code> or <code>ABANDON</code>. The
         * default value is <code>ABANDON</code>.
         * </p>
         * 
         * @param defaultResult
         *        Defines the action the Auto Scaling group should take when the lifecycle hook timeout elapses or if an
         *        unexpected failure occurs. This parameter can be either <code>CONTINUE</code> or <code>ABANDON</code>.
         *        The default value is <code>ABANDON</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultResult(String defaultResult);
    }

    private static final class BuilderImpl implements Builder {
        private String lifecycleHookName;

        private String autoScalingGroupName;

        private String lifecycleTransition;

        private String roleARN;

        private String notificationTargetARN;

        private String notificationMetadata;

        private Integer heartbeatTimeout;

        private String defaultResult;

        private BuilderImpl() {
        }

        private BuilderImpl(PutLifecycleHookRequest model) {
            setLifecycleHookName(model.lifecycleHookName);
            setAutoScalingGroupName(model.autoScalingGroupName);
            setLifecycleTransition(model.lifecycleTransition);
            setRoleARN(model.roleARN);
            setNotificationTargetARN(model.notificationTargetARN);
            setNotificationMetadata(model.notificationMetadata);
            setHeartbeatTimeout(model.heartbeatTimeout);
            setDefaultResult(model.defaultResult);
        }

        public final String getLifecycleHookName() {
            return lifecycleHookName;
        }

        @Override
        public final Builder lifecycleHookName(String lifecycleHookName) {
            this.lifecycleHookName = lifecycleHookName;
            return this;
        }

        public final void setLifecycleHookName(String lifecycleHookName) {
            this.lifecycleHookName = lifecycleHookName;
        }

        public final String getAutoScalingGroupName() {
            return autoScalingGroupName;
        }

        @Override
        public final Builder autoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
            return this;
        }

        public final void setAutoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
        }

        public final String getLifecycleTransition() {
            return lifecycleTransition;
        }

        @Override
        public final Builder lifecycleTransition(String lifecycleTransition) {
            this.lifecycleTransition = lifecycleTransition;
            return this;
        }

        public final void setLifecycleTransition(String lifecycleTransition) {
            this.lifecycleTransition = lifecycleTransition;
        }

        public final String getRoleARN() {
            return roleARN;
        }

        @Override
        public final Builder roleARN(String roleARN) {
            this.roleARN = roleARN;
            return this;
        }

        public final void setRoleARN(String roleARN) {
            this.roleARN = roleARN;
        }

        public final String getNotificationTargetARN() {
            return notificationTargetARN;
        }

        @Override
        public final Builder notificationTargetARN(String notificationTargetARN) {
            this.notificationTargetARN = notificationTargetARN;
            return this;
        }

        public final void setNotificationTargetARN(String notificationTargetARN) {
            this.notificationTargetARN = notificationTargetARN;
        }

        public final String getNotificationMetadata() {
            return notificationMetadata;
        }

        @Override
        public final Builder notificationMetadata(String notificationMetadata) {
            this.notificationMetadata = notificationMetadata;
            return this;
        }

        public final void setNotificationMetadata(String notificationMetadata) {
            this.notificationMetadata = notificationMetadata;
        }

        public final Integer getHeartbeatTimeout() {
            return heartbeatTimeout;
        }

        @Override
        public final Builder heartbeatTimeout(Integer heartbeatTimeout) {
            this.heartbeatTimeout = heartbeatTimeout;
            return this;
        }

        public final void setHeartbeatTimeout(Integer heartbeatTimeout) {
            this.heartbeatTimeout = heartbeatTimeout;
        }

        public final String getDefaultResult() {
            return defaultResult;
        }

        @Override
        public final Builder defaultResult(String defaultResult) {
            this.defaultResult = defaultResult;
            return this;
        }

        public final void setDefaultResult(String defaultResult) {
            this.defaultResult = defaultResult;
        }

        @Override
        public PutLifecycleHookRequest build() {
            return new PutLifecycleHookRequest(this);
        }
    }
}
