/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeScalingActivitiesRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<DescribeScalingActivitiesRequest.Builder, DescribeScalingActivitiesRequest> {
    private final List<String> activityIds;

    private final String autoScalingGroupName;

    private final Integer maxRecords;

    private final String nextToken;

    private DescribeScalingActivitiesRequest(BuilderImpl builder) {
        this.activityIds = builder.activityIds;
        this.autoScalingGroupName = builder.autoScalingGroupName;
        this.maxRecords = builder.maxRecords;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The activity IDs of the desired scaling activities. If you omit this parameter, all activities for the past six
     * weeks are described. If you specify an Auto Scaling group, the results are limited to that group. The list of
     * requested activities cannot contain more than 50 items. If unknown activities are requested, they are ignored
     * with no error.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The activity IDs of the desired scaling activities. If you omit this parameter, all activities for the
     *         past six weeks are described. If you specify an Auto Scaling group, the results are limited to that
     *         group. The list of requested activities cannot contain more than 50 items. If unknown activities are
     *         requested, they are ignored with no error.
     */
    public List<String> activityIds() {
        return activityIds;
    }

    /**
     * <p>
     * The name of the group.
     * </p>
     * 
     * @return The name of the group.
     */
    public String autoScalingGroupName() {
        return autoScalingGroupName;
    }

    /**
     * <p>
     * The maximum number of items to return with this call. The default value is 100.
     * </p>
     * 
     * @return The maximum number of items to return with this call. The default value is 100.
     */
    public Integer maxRecords() {
        return maxRecords;
    }

    /**
     * <p>
     * The token for the next set of items to return. (You received this token from a previous call.)
     * </p>
     * 
     * @return The token for the next set of items to return. (You received this token from a previous call.)
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((activityIds() == null) ? 0 : activityIds().hashCode());
        hashCode = 31 * hashCode + ((autoScalingGroupName() == null) ? 0 : autoScalingGroupName().hashCode());
        hashCode = 31 * hashCode + ((maxRecords() == null) ? 0 : maxRecords().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeScalingActivitiesRequest)) {
            return false;
        }
        DescribeScalingActivitiesRequest other = (DescribeScalingActivitiesRequest) obj;
        if (other.activityIds() == null ^ this.activityIds() == null) {
            return false;
        }
        if (other.activityIds() != null && !other.activityIds().equals(this.activityIds())) {
            return false;
        }
        if (other.autoScalingGroupName() == null ^ this.autoScalingGroupName() == null) {
            return false;
        }
        if (other.autoScalingGroupName() != null && !other.autoScalingGroupName().equals(this.autoScalingGroupName())) {
            return false;
        }
        if (other.maxRecords() == null ^ this.maxRecords() == null) {
            return false;
        }
        if (other.maxRecords() != null && !other.maxRecords().equals(this.maxRecords())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (activityIds() != null) {
            sb.append("ActivityIds: ").append(activityIds()).append(",");
        }
        if (autoScalingGroupName() != null) {
            sb.append("AutoScalingGroupName: ").append(autoScalingGroupName()).append(",");
        }
        if (maxRecords() != null) {
            sb.append("MaxRecords: ").append(maxRecords()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeScalingActivitiesRequest> {
        /**
         * <p>
         * The activity IDs of the desired scaling activities. If you omit this parameter, all activities for the past
         * six weeks are described. If you specify an Auto Scaling group, the results are limited to that group. The
         * list of requested activities cannot contain more than 50 items. If unknown activities are requested, they are
         * ignored with no error.
         * </p>
         * 
         * @param activityIds
         *        The activity IDs of the desired scaling activities. If you omit this parameter, all activities for the
         *        past six weeks are described. If you specify an Auto Scaling group, the results are limited to that
         *        group. The list of requested activities cannot contain more than 50 items. If unknown activities are
         *        requested, they are ignored with no error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activityIds(Collection<String> activityIds);

        /**
         * <p>
         * The activity IDs of the desired scaling activities. If you omit this parameter, all activities for the past
         * six weeks are described. If you specify an Auto Scaling group, the results are limited to that group. The
         * list of requested activities cannot contain more than 50 items. If unknown activities are requested, they are
         * ignored with no error.
         * </p>
         * 
         * @param activityIds
         *        The activity IDs of the desired scaling activities. If you omit this parameter, all activities for the
         *        past six weeks are described. If you specify an Auto Scaling group, the results are limited to that
         *        group. The list of requested activities cannot contain more than 50 items. If unknown activities are
         *        requested, they are ignored with no error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activityIds(String... activityIds);

        /**
         * <p>
         * The name of the group.
         * </p>
         * 
         * @param autoScalingGroupName
         *        The name of the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoScalingGroupName(String autoScalingGroupName);

        /**
         * <p>
         * The maximum number of items to return with this call. The default value is 100.
         * </p>
         * 
         * @param maxRecords
         *        The maximum number of items to return with this call. The default value is 100.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxRecords(Integer maxRecords);

        /**
         * <p>
         * The token for the next set of items to return. (You received this token from a previous call.)
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of items to return. (You received this token from a previous call.)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    private static final class BuilderImpl implements Builder {
        private List<String> activityIds;

        private String autoScalingGroupName;

        private Integer maxRecords;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeScalingActivitiesRequest model) {
            setActivityIds(model.activityIds);
            setAutoScalingGroupName(model.autoScalingGroupName);
            setMaxRecords(model.maxRecords);
            setNextToken(model.nextToken);
        }

        public final Collection<String> getActivityIds() {
            return activityIds;
        }

        @Override
        public final Builder activityIds(Collection<String> activityIds) {
            this.activityIds = ActivityIdsCopier.copy(activityIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder activityIds(String... activityIds) {
            activityIds(Arrays.asList(activityIds));
            return this;
        }

        public final void setActivityIds(Collection<String> activityIds) {
            this.activityIds = ActivityIdsCopier.copy(activityIds);
        }

        public final String getAutoScalingGroupName() {
            return autoScalingGroupName;
        }

        @Override
        public final Builder autoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
            return this;
        }

        public final void setAutoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
        }

        public final Integer getMaxRecords() {
            return maxRecords;
        }

        @Override
        public final Builder maxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
            return this;
        }

        public final void setMaxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeScalingActivitiesRequest build() {
            return new DescribeScalingActivitiesRequest(this);
        }
    }
}
