/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeLoadBalancerTargetGroupsResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DescribeLoadBalancerTargetGroupsResponse.Builder, DescribeLoadBalancerTargetGroupsResponse> {
    private final List<LoadBalancerTargetGroupState> loadBalancerTargetGroups;

    private final String nextToken;

    private DescribeLoadBalancerTargetGroupsResponse(BuilderImpl builder) {
        this.loadBalancerTargetGroups = builder.loadBalancerTargetGroups;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * Information about the target groups.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about the target groups.
     */
    public List<LoadBalancerTargetGroupState> loadBalancerTargetGroups() {
        return loadBalancerTargetGroups;
    }

    /**
     * <p>
     * The token to use when requesting the next set of items. If there are no additional items to return, the string is
     * empty.
     * </p>
     * 
     * @return The token to use when requesting the next set of items. If there are no additional items to return, the
     *         string is empty.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((loadBalancerTargetGroups() == null) ? 0 : loadBalancerTargetGroups().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLoadBalancerTargetGroupsResponse)) {
            return false;
        }
        DescribeLoadBalancerTargetGroupsResponse other = (DescribeLoadBalancerTargetGroupsResponse) obj;
        if (other.loadBalancerTargetGroups() == null ^ this.loadBalancerTargetGroups() == null) {
            return false;
        }
        if (other.loadBalancerTargetGroups() != null && !other.loadBalancerTargetGroups().equals(this.loadBalancerTargetGroups())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (loadBalancerTargetGroups() != null) {
            sb.append("LoadBalancerTargetGroups: ").append(loadBalancerTargetGroups()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeLoadBalancerTargetGroupsResponse> {
        /**
         * <p>
         * Information about the target groups.
         * </p>
         * 
         * @param loadBalancerTargetGroups
         *        Information about the target groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loadBalancerTargetGroups(Collection<LoadBalancerTargetGroupState> loadBalancerTargetGroups);

        /**
         * <p>
         * Information about the target groups.
         * </p>
         * 
         * @param loadBalancerTargetGroups
         *        Information about the target groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loadBalancerTargetGroups(LoadBalancerTargetGroupState... loadBalancerTargetGroups);

        /**
         * <p>
         * The token to use when requesting the next set of items. If there are no additional items to return, the
         * string is empty.
         * </p>
         * 
         * @param nextToken
         *        The token to use when requesting the next set of items. If there are no additional items to return,
         *        the string is empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    private static final class BuilderImpl implements Builder {
        private List<LoadBalancerTargetGroupState> loadBalancerTargetGroups;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLoadBalancerTargetGroupsResponse model) {
            setLoadBalancerTargetGroups(model.loadBalancerTargetGroups);
            setNextToken(model.nextToken);
        }

        public final Collection<LoadBalancerTargetGroupState> getLoadBalancerTargetGroups() {
            return loadBalancerTargetGroups;
        }

        @Override
        public final Builder loadBalancerTargetGroups(Collection<LoadBalancerTargetGroupState> loadBalancerTargetGroups) {
            this.loadBalancerTargetGroups = LoadBalancerTargetGroupStatesCopier.copy(loadBalancerTargetGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loadBalancerTargetGroups(LoadBalancerTargetGroupState... loadBalancerTargetGroups) {
            loadBalancerTargetGroups(Arrays.asList(loadBalancerTargetGroups));
            return this;
        }

        public final void setLoadBalancerTargetGroups(Collection<LoadBalancerTargetGroupState> loadBalancerTargetGroups) {
            this.loadBalancerTargetGroups = LoadBalancerTargetGroupStatesCopier.copy(loadBalancerTargetGroups);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeLoadBalancerTargetGroupsResponse build() {
            return new DescribeLoadBalancerTargetGroupsResponse(this);
        }
    }
}
