/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateLaunchConfigurationRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<CreateLaunchConfigurationRequest.Builder, CreateLaunchConfigurationRequest> {
    private final String launchConfigurationName;

    private final String imageId;

    private final String keyName;

    private final List<String> securityGroups;

    private final String classicLinkVPCId;

    private final List<String> classicLinkVPCSecurityGroups;

    private final String userData;

    private final String instanceId;

    private final String instanceType;

    private final String kernelId;

    private final String ramdiskId;

    private final List<BlockDeviceMapping> blockDeviceMappings;

    private final InstanceMonitoring instanceMonitoring;

    private final String spotPrice;

    private final String iamInstanceProfile;

    private final Boolean ebsOptimized;

    private final Boolean associatePublicIpAddress;

    private final String placementTenancy;

    private CreateLaunchConfigurationRequest(BuilderImpl builder) {
        this.launchConfigurationName = builder.launchConfigurationName;
        this.imageId = builder.imageId;
        this.keyName = builder.keyName;
        this.securityGroups = builder.securityGroups;
        this.classicLinkVPCId = builder.classicLinkVPCId;
        this.classicLinkVPCSecurityGroups = builder.classicLinkVPCSecurityGroups;
        this.userData = builder.userData;
        this.instanceId = builder.instanceId;
        this.instanceType = builder.instanceType;
        this.kernelId = builder.kernelId;
        this.ramdiskId = builder.ramdiskId;
        this.blockDeviceMappings = builder.blockDeviceMappings;
        this.instanceMonitoring = builder.instanceMonitoring;
        this.spotPrice = builder.spotPrice;
        this.iamInstanceProfile = builder.iamInstanceProfile;
        this.ebsOptimized = builder.ebsOptimized;
        this.associatePublicIpAddress = builder.associatePublicIpAddress;
        this.placementTenancy = builder.placementTenancy;
    }

    /**
     * <p>
     * The name of the launch configuration. This name must be unique within the scope of your AWS account.
     * </p>
     * 
     * @return The name of the launch configuration. This name must be unique within the scope of your AWS account.
     */
    public String launchConfigurationName() {
        return launchConfigurationName;
    }

    /**
     * <p>
     * The ID of the Amazon Machine Image (AMI) to use to launch your EC2 instances.
     * </p>
     * <p>
     * If you do not specify <code>InstanceId</code>, you must specify <code>ImageId</code>.
     * </p>
     * <p>
     * For more information, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/finding-an-ami.html">Finding an AMI</a> in the <i>Amazon
     * Elastic Compute Cloud User Guide</i>.
     * </p>
     * 
     * @return The ID of the Amazon Machine Image (AMI) to use to launch your EC2 instances.</p>
     *         <p>
     *         If you do not specify <code>InstanceId</code>, you must specify <code>ImageId</code>.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/finding-an-ami.html">Finding an AMI</a> in the
     *         <i>Amazon Elastic Compute Cloud User Guide</i>.
     */
    public String imageId() {
        return imageId;
    }

    /**
     * <p>
     * The name of the key pair. For more information, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html">Amazon EC2 Key Pairs</a> in the
     * <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * 
     * @return The name of the key pair. For more information, see <a
     *         href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html">Amazon EC2 Key Pairs</a> in
     *         the <i>Amazon Elastic Compute Cloud User Guide</i>.
     */
    public String keyName() {
        return keyName;
    }

    /**
     * <p>
     * One or more security groups with which to associate the instances.
     * </p>
     * <p>
     * If your instances are launched in EC2-Classic, you can either specify security group names or the security group
     * IDs. For more information about security groups for EC2-Classic, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-network-security.html">Amazon EC2 Security
     * Groups</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * <p>
     * If your instances are launched into a VPC, specify security group IDs. For more information, see <a
     * href="http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_SecurityGroups.html">Security Groups for Your
     * VPC</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more security groups with which to associate the instances.</p>
     *         <p>
     *         If your instances are launched in EC2-Classic, you can either specify security group names or the
     *         security group IDs. For more information about security groups for EC2-Classic, see <a
     *         href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-network-security.html">Amazon EC2 Security
     *         Groups</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     *         </p>
     *         <p>
     *         If your instances are launched into a VPC, specify security group IDs. For more information, see <a
     *         href="http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_SecurityGroups.html">Security Groups for
     *         Your VPC</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.
     */
    public List<String> securityGroups() {
        return securityGroups;
    }

    /**
     * <p>
     * The ID of a ClassicLink-enabled VPC to link your EC2-Classic instances to. This parameter is supported only if
     * you are launching EC2-Classic instances. For more information, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-classiclink.html">ClassicLink</a> in the <i>Amazon
     * Elastic Compute Cloud User Guide</i>.
     * </p>
     * 
     * @return The ID of a ClassicLink-enabled VPC to link your EC2-Classic instances to. This parameter is supported
     *         only if you are launching EC2-Classic instances. For more information, see <a
     *         href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-classiclink.html">ClassicLink</a> in the
     *         <i>Amazon Elastic Compute Cloud User Guide</i>.
     */
    public String classicLinkVPCId() {
        return classicLinkVPCId;
    }

    /**
     * <p>
     * The IDs of one or more security groups for the specified ClassicLink-enabled VPC. This parameter is required if
     * you specify a ClassicLink-enabled VPC, and is not supported otherwise. For more information, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-classiclink.html">ClassicLink</a> in the <i>Amazon
     * Elastic Compute Cloud User Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The IDs of one or more security groups for the specified ClassicLink-enabled VPC. This parameter is
     *         required if you specify a ClassicLink-enabled VPC, and is not supported otherwise. For more information,
     *         see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-classiclink.html">ClassicLink</a> in
     *         the <i>Amazon Elastic Compute Cloud User Guide</i>.
     */
    public List<String> classicLinkVPCSecurityGroups() {
        return classicLinkVPCSecurityGroups;
    }

    /**
     * <p>
     * The user data to make available to the launched EC2 instances. For more information, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-metadata.html">Instance Metadata and User
     * Data</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * 
     * @return The user data to make available to the launched EC2 instances. For more information, see <a
     *         href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-metadata.html">Instance Metadata
     *         and User Data</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     */
    public String userData() {
        return userData;
    }

    /**
     * <p>
     * The ID of the instance to use to create the launch configuration. The new launch configuration derives attributes
     * from the instance, with the exception of the block device mapping.
     * </p>
     * <p>
     * If you do not specify <code>InstanceId</code>, you must specify both <code>ImageId</code> and
     * <code>InstanceType</code>.
     * </p>
     * <p>
     * To create a launch configuration with a block device mapping or override any other instance attributes, specify
     * them as part of the same request.
     * </p>
     * <p>
     * For more information, see <a
     * href="http://docs.aws.amazon.com/autoscaling/latest/userguide/create-lc-with-instanceID.html">Create a Launch
     * Configuration Using an EC2 Instance</a> in the <i>Auto Scaling User Guide</i>.
     * </p>
     * 
     * @return The ID of the instance to use to create the launch configuration. The new launch configuration derives
     *         attributes from the instance, with the exception of the block device mapping.</p>
     *         <p>
     *         If you do not specify <code>InstanceId</code>, you must specify both <code>ImageId</code> and
     *         <code>InstanceType</code>.
     *         </p>
     *         <p>
     *         To create a launch configuration with a block device mapping or override any other instance attributes,
     *         specify them as part of the same request.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="http://docs.aws.amazon.com/autoscaling/latest/userguide/create-lc-with-instanceID.html">Create a
     *         Launch Configuration Using an EC2 Instance</a> in the <i>Auto Scaling User Guide</i>.
     */
    public String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The instance type of the EC2 instance.
     * </p>
     * <p>
     * If you do not specify <code>InstanceId</code>, you must specify <code>InstanceType</code>.
     * </p>
     * <p>
     * For information about available instance types, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#AvailableInstanceTypes">Available
     * Instance Types</a> in the <i>Amazon Elastic Compute Cloud User Guide.</i>
     * </p>
     * 
     * @return The instance type of the EC2 instance.</p>
     *         <p>
     *         If you do not specify <code>InstanceId</code>, you must specify <code>InstanceType</code>.
     *         </p>
     *         <p>
     *         For information about available instance types, see <a
     *         href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#AvailableInstanceTypes"
     *         >Available Instance Types</a> in the <i>Amazon Elastic Compute Cloud User Guide.</i>
     */
    public String instanceType() {
        return instanceType;
    }

    /**
     * <p>
     * The ID of the kernel associated with the AMI.
     * </p>
     * 
     * @return The ID of the kernel associated with the AMI.
     */
    public String kernelId() {
        return kernelId;
    }

    /**
     * <p>
     * The ID of the RAM disk associated with the AMI.
     * </p>
     * 
     * @return The ID of the RAM disk associated with the AMI.
     */
    public String ramdiskId() {
        return ramdiskId;
    }

    /**
     * <p>
     * One or more mappings that specify how block devices are exposed to the instance. For more information, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/block-device-mapping-concepts.html">Block Device
     * Mapping</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more mappings that specify how block devices are exposed to the instance. For more information,
     *         see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/block-device-mapping-concepts.html">Block
     *         Device Mapping</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     */
    public List<BlockDeviceMapping> blockDeviceMappings() {
        return blockDeviceMappings;
    }

    /**
     * <p>
     * Enables detailed monitoring (<code>true</code>) or basic monitoring (<code>false</code>) for the Auto Scaling
     * instances. The default is <code>true</code>.
     * </p>
     * 
     * @return Enables detailed monitoring (<code>true</code>) or basic monitoring (<code>false</code>) for the Auto
     *         Scaling instances. The default is <code>true</code>.
     */
    public InstanceMonitoring instanceMonitoring() {
        return instanceMonitoring;
    }

    /**
     * <p>
     * The maximum hourly price to be paid for any Spot Instance launched to fulfill the request. Spot Instances are
     * launched when the price you specify exceeds the current Spot market price. For more information, see <a
     * href="http://docs.aws.amazon.com/autoscaling/latest/userguide/US-SpotInstances.html">Launching Spot Instances in
     * Your Auto Scaling Group</a> in the <i>Auto Scaling User Guide</i>.
     * </p>
     * 
     * @return The maximum hourly price to be paid for any Spot Instance launched to fulfill the request. Spot Instances
     *         are launched when the price you specify exceeds the current Spot market price. For more information, see
     *         <a href="http://docs.aws.amazon.com/autoscaling/latest/userguide/US-SpotInstances.html">Launching Spot
     *         Instances in Your Auto Scaling Group</a> in the <i>Auto Scaling User Guide</i>.
     */
    public String spotPrice() {
        return spotPrice;
    }

    /**
     * <p>
     * The name or the Amazon Resource Name (ARN) of the instance profile associated with the IAM role for the instance.
     * </p>
     * <p>
     * EC2 instances launched with an IAM role will automatically have AWS security credentials available. You can use
     * IAM roles with Auto Scaling to automatically enable applications running on your EC2 instances to securely access
     * other AWS resources. For more information, see <a
     * href="http://docs.aws.amazon.com/autoscaling/latest/userguide/us-iam-role.html">Launch Auto Scaling Instances
     * with an IAM Role</a> in the <i>Auto Scaling User Guide</i>.
     * </p>
     * 
     * @return The name or the Amazon Resource Name (ARN) of the instance profile associated with the IAM role for the
     *         instance.</p>
     *         <p>
     *         EC2 instances launched with an IAM role will automatically have AWS security credentials available. You
     *         can use IAM roles with Auto Scaling to automatically enable applications running on your EC2 instances to
     *         securely access other AWS resources. For more information, see <a
     *         href="http://docs.aws.amazon.com/autoscaling/latest/userguide/us-iam-role.html">Launch Auto Scaling
     *         Instances with an IAM Role</a> in the <i>Auto Scaling User Guide</i>.
     */
    public String iamInstanceProfile() {
        return iamInstanceProfile;
    }

    /**
     * <p>
     * Indicates whether the instance is optimized for Amazon EBS I/O. By default, the instance is not optimized for EBS
     * I/O. The optimization provides dedicated throughput to Amazon EBS and an optimized configuration stack to provide
     * optimal I/O performance. This optimization is not available with all instance types. Additional usage charges
     * apply. For more information, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSOptimized.html">Amazon EBS-Optimized Instances</a> in
     * the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * 
     * @return Indicates whether the instance is optimized for Amazon EBS I/O. By default, the instance is not optimized
     *         for EBS I/O. The optimization provides dedicated throughput to Amazon EBS and an optimized configuration
     *         stack to provide optimal I/O performance. This optimization is not available with all instance types.
     *         Additional usage charges apply. For more information, see <a
     *         href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSOptimized.html">Amazon EBS-Optimized
     *         Instances</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     */
    public Boolean ebsOptimized() {
        return ebsOptimized;
    }

    /**
     * <p>
     * Used for groups that launch instances into a virtual private cloud (VPC). Specifies whether to assign a public IP
     * address to each instance. For more information, see <a
     * href="http://docs.aws.amazon.com/autoscaling/latest/userguide/asg-in-vpc.html">Launching Auto Scaling Instances
     * in a VPC</a> in the <i>Auto Scaling User Guide</i>.
     * </p>
     * <p>
     * If you specify this parameter, be sure to specify at least one subnet when you create your group.
     * </p>
     * <p>
     * Default: If the instance is launched into a default subnet, the default is <code>true</code>. If the instance is
     * launched into a nondefault subnet, the default is <code>false</code>. For more information, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-supported-platforms.html">Supported Platforms</a> in
     * the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * 
     * @return Used for groups that launch instances into a virtual private cloud (VPC). Specifies whether to assign a
     *         public IP address to each instance. For more information, see <a
     *         href="http://docs.aws.amazon.com/autoscaling/latest/userguide/asg-in-vpc.html">Launching Auto Scaling
     *         Instances in a VPC</a> in the <i>Auto Scaling User Guide</i>.</p>
     *         <p>
     *         If you specify this parameter, be sure to specify at least one subnet when you create your group.
     *         </p>
     *         <p>
     *         Default: If the instance is launched into a default subnet, the default is <code>true</code>. If the
     *         instance is launched into a nondefault subnet, the default is <code>false</code>. For more information,
     *         see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-supported-platforms.html">Supported
     *         Platforms</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     */
    public Boolean associatePublicIpAddress() {
        return associatePublicIpAddress;
    }

    /**
     * <p>
     * The tenancy of the instance. An instance with a tenancy of <code>dedicated</code> runs on single-tenant hardware
     * and can only be launched into a VPC.
     * </p>
     * <p>
     * You must set the value of this parameter to <code>dedicated</code> if want to launch Dedicated Instances into a
     * shared tenancy VPC (VPC with instance placement tenancy attribute set to <code>default</code>).
     * </p>
     * <p>
     * If you specify this parameter, be sure to specify at least one subnet when you create your group.
     * </p>
     * <p>
     * For more information, see <a
     * href="http://docs.aws.amazon.com/autoscaling/latest/userguide/asg-in-vpc.html">Launching Auto Scaling Instances
     * in a VPC</a> in the <i>Auto Scaling User Guide</i>.
     * </p>
     * <p>
     * Valid values: <code>default</code> | <code>dedicated</code>
     * </p>
     * 
     * @return The tenancy of the instance. An instance with a tenancy of <code>dedicated</code> runs on single-tenant
     *         hardware and can only be launched into a VPC.</p>
     *         <p>
     *         You must set the value of this parameter to <code>dedicated</code> if want to launch Dedicated Instances
     *         into a shared tenancy VPC (VPC with instance placement tenancy attribute set to <code>default</code>).
     *         </p>
     *         <p>
     *         If you specify this parameter, be sure to specify at least one subnet when you create your group.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="http://docs.aws.amazon.com/autoscaling/latest/userguide/asg-in-vpc.html">Launching Auto Scaling
     *         Instances in a VPC</a> in the <i>Auto Scaling User Guide</i>.
     *         </p>
     *         <p>
     *         Valid values: <code>default</code> | <code>dedicated</code>
     */
    public String placementTenancy() {
        return placementTenancy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((launchConfigurationName() == null) ? 0 : launchConfigurationName().hashCode());
        hashCode = 31 * hashCode + ((imageId() == null) ? 0 : imageId().hashCode());
        hashCode = 31 * hashCode + ((keyName() == null) ? 0 : keyName().hashCode());
        hashCode = 31 * hashCode + ((securityGroups() == null) ? 0 : securityGroups().hashCode());
        hashCode = 31 * hashCode + ((classicLinkVPCId() == null) ? 0 : classicLinkVPCId().hashCode());
        hashCode = 31 * hashCode + ((classicLinkVPCSecurityGroups() == null) ? 0 : classicLinkVPCSecurityGroups().hashCode());
        hashCode = 31 * hashCode + ((userData() == null) ? 0 : userData().hashCode());
        hashCode = 31 * hashCode + ((instanceId() == null) ? 0 : instanceId().hashCode());
        hashCode = 31 * hashCode + ((instanceType() == null) ? 0 : instanceType().hashCode());
        hashCode = 31 * hashCode + ((kernelId() == null) ? 0 : kernelId().hashCode());
        hashCode = 31 * hashCode + ((ramdiskId() == null) ? 0 : ramdiskId().hashCode());
        hashCode = 31 * hashCode + ((blockDeviceMappings() == null) ? 0 : blockDeviceMappings().hashCode());
        hashCode = 31 * hashCode + ((instanceMonitoring() == null) ? 0 : instanceMonitoring().hashCode());
        hashCode = 31 * hashCode + ((spotPrice() == null) ? 0 : spotPrice().hashCode());
        hashCode = 31 * hashCode + ((iamInstanceProfile() == null) ? 0 : iamInstanceProfile().hashCode());
        hashCode = 31 * hashCode + ((ebsOptimized() == null) ? 0 : ebsOptimized().hashCode());
        hashCode = 31 * hashCode + ((associatePublicIpAddress() == null) ? 0 : associatePublicIpAddress().hashCode());
        hashCode = 31 * hashCode + ((placementTenancy() == null) ? 0 : placementTenancy().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLaunchConfigurationRequest)) {
            return false;
        }
        CreateLaunchConfigurationRequest other = (CreateLaunchConfigurationRequest) obj;
        if (other.launchConfigurationName() == null ^ this.launchConfigurationName() == null) {
            return false;
        }
        if (other.launchConfigurationName() != null && !other.launchConfigurationName().equals(this.launchConfigurationName())) {
            return false;
        }
        if (other.imageId() == null ^ this.imageId() == null) {
            return false;
        }
        if (other.imageId() != null && !other.imageId().equals(this.imageId())) {
            return false;
        }
        if (other.keyName() == null ^ this.keyName() == null) {
            return false;
        }
        if (other.keyName() != null && !other.keyName().equals(this.keyName())) {
            return false;
        }
        if (other.securityGroups() == null ^ this.securityGroups() == null) {
            return false;
        }
        if (other.securityGroups() != null && !other.securityGroups().equals(this.securityGroups())) {
            return false;
        }
        if (other.classicLinkVPCId() == null ^ this.classicLinkVPCId() == null) {
            return false;
        }
        if (other.classicLinkVPCId() != null && !other.classicLinkVPCId().equals(this.classicLinkVPCId())) {
            return false;
        }
        if (other.classicLinkVPCSecurityGroups() == null ^ this.classicLinkVPCSecurityGroups() == null) {
            return false;
        }
        if (other.classicLinkVPCSecurityGroups() != null
                && !other.classicLinkVPCSecurityGroups().equals(this.classicLinkVPCSecurityGroups())) {
            return false;
        }
        if (other.userData() == null ^ this.userData() == null) {
            return false;
        }
        if (other.userData() != null && !other.userData().equals(this.userData())) {
            return false;
        }
        if (other.instanceId() == null ^ this.instanceId() == null) {
            return false;
        }
        if (other.instanceId() != null && !other.instanceId().equals(this.instanceId())) {
            return false;
        }
        if (other.instanceType() == null ^ this.instanceType() == null) {
            return false;
        }
        if (other.instanceType() != null && !other.instanceType().equals(this.instanceType())) {
            return false;
        }
        if (other.kernelId() == null ^ this.kernelId() == null) {
            return false;
        }
        if (other.kernelId() != null && !other.kernelId().equals(this.kernelId())) {
            return false;
        }
        if (other.ramdiskId() == null ^ this.ramdiskId() == null) {
            return false;
        }
        if (other.ramdiskId() != null && !other.ramdiskId().equals(this.ramdiskId())) {
            return false;
        }
        if (other.blockDeviceMappings() == null ^ this.blockDeviceMappings() == null) {
            return false;
        }
        if (other.blockDeviceMappings() != null && !other.blockDeviceMappings().equals(this.blockDeviceMappings())) {
            return false;
        }
        if (other.instanceMonitoring() == null ^ this.instanceMonitoring() == null) {
            return false;
        }
        if (other.instanceMonitoring() != null && !other.instanceMonitoring().equals(this.instanceMonitoring())) {
            return false;
        }
        if (other.spotPrice() == null ^ this.spotPrice() == null) {
            return false;
        }
        if (other.spotPrice() != null && !other.spotPrice().equals(this.spotPrice())) {
            return false;
        }
        if (other.iamInstanceProfile() == null ^ this.iamInstanceProfile() == null) {
            return false;
        }
        if (other.iamInstanceProfile() != null && !other.iamInstanceProfile().equals(this.iamInstanceProfile())) {
            return false;
        }
        if (other.ebsOptimized() == null ^ this.ebsOptimized() == null) {
            return false;
        }
        if (other.ebsOptimized() != null && !other.ebsOptimized().equals(this.ebsOptimized())) {
            return false;
        }
        if (other.associatePublicIpAddress() == null ^ this.associatePublicIpAddress() == null) {
            return false;
        }
        if (other.associatePublicIpAddress() != null && !other.associatePublicIpAddress().equals(this.associatePublicIpAddress())) {
            return false;
        }
        if (other.placementTenancy() == null ^ this.placementTenancy() == null) {
            return false;
        }
        if (other.placementTenancy() != null && !other.placementTenancy().equals(this.placementTenancy())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (launchConfigurationName() != null) {
            sb.append("LaunchConfigurationName: ").append(launchConfigurationName()).append(",");
        }
        if (imageId() != null) {
            sb.append("ImageId: ").append(imageId()).append(",");
        }
        if (keyName() != null) {
            sb.append("KeyName: ").append(keyName()).append(",");
        }
        if (securityGroups() != null) {
            sb.append("SecurityGroups: ").append(securityGroups()).append(",");
        }
        if (classicLinkVPCId() != null) {
            sb.append("ClassicLinkVPCId: ").append(classicLinkVPCId()).append(",");
        }
        if (classicLinkVPCSecurityGroups() != null) {
            sb.append("ClassicLinkVPCSecurityGroups: ").append(classicLinkVPCSecurityGroups()).append(",");
        }
        if (userData() != null) {
            sb.append("UserData: ").append(userData()).append(",");
        }
        if (instanceId() != null) {
            sb.append("InstanceId: ").append(instanceId()).append(",");
        }
        if (instanceType() != null) {
            sb.append("InstanceType: ").append(instanceType()).append(",");
        }
        if (kernelId() != null) {
            sb.append("KernelId: ").append(kernelId()).append(",");
        }
        if (ramdiskId() != null) {
            sb.append("RamdiskId: ").append(ramdiskId()).append(",");
        }
        if (blockDeviceMappings() != null) {
            sb.append("BlockDeviceMappings: ").append(blockDeviceMappings()).append(",");
        }
        if (instanceMonitoring() != null) {
            sb.append("InstanceMonitoring: ").append(instanceMonitoring()).append(",");
        }
        if (spotPrice() != null) {
            sb.append("SpotPrice: ").append(spotPrice()).append(",");
        }
        if (iamInstanceProfile() != null) {
            sb.append("IamInstanceProfile: ").append(iamInstanceProfile()).append(",");
        }
        if (ebsOptimized() != null) {
            sb.append("EbsOptimized: ").append(ebsOptimized()).append(",");
        }
        if (associatePublicIpAddress() != null) {
            sb.append("AssociatePublicIpAddress: ").append(associatePublicIpAddress()).append(",");
        }
        if (placementTenancy() != null) {
            sb.append("PlacementTenancy: ").append(placementTenancy()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, CreateLaunchConfigurationRequest> {
        /**
         * <p>
         * The name of the launch configuration. This name must be unique within the scope of your AWS account.
         * </p>
         * 
         * @param launchConfigurationName
         *        The name of the launch configuration. This name must be unique within the scope of your AWS account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchConfigurationName(String launchConfigurationName);

        /**
         * <p>
         * The ID of the Amazon Machine Image (AMI) to use to launch your EC2 instances.
         * </p>
         * <p>
         * If you do not specify <code>InstanceId</code>, you must specify <code>ImageId</code>.
         * </p>
         * <p>
         * For more information, see <a
         * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/finding-an-ami.html">Finding an AMI</a> in the
         * <i>Amazon Elastic Compute Cloud User Guide</i>.
         * </p>
         * 
         * @param imageId
         *        The ID of the Amazon Machine Image (AMI) to use to launch your EC2 instances.</p>
         *        <p>
         *        If you do not specify <code>InstanceId</code>, you must specify <code>ImageId</code>.
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/finding-an-ami.html">Finding an AMI</a> in
         *        the <i>Amazon Elastic Compute Cloud User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageId(String imageId);

        /**
         * <p>
         * The name of the key pair. For more information, see <a
         * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html">Amazon EC2 Key Pairs</a> in the
         * <i>Amazon Elastic Compute Cloud User Guide</i>.
         * </p>
         * 
         * @param keyName
         *        The name of the key pair. For more information, see <a
         *        href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html">Amazon EC2 Key Pairs</a>
         *        in the <i>Amazon Elastic Compute Cloud User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyName(String keyName);

        /**
         * <p>
         * One or more security groups with which to associate the instances.
         * </p>
         * <p>
         * If your instances are launched in EC2-Classic, you can either specify security group names or the security
         * group IDs. For more information about security groups for EC2-Classic, see <a
         * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-network-security.html">Amazon EC2 Security
         * Groups</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
         * </p>
         * <p>
         * If your instances are launched into a VPC, specify security group IDs. For more information, see <a
         * href="http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_SecurityGroups.html">Security Groups for Your
         * VPC</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.
         * </p>
         * 
         * @param securityGroups
         *        One or more security groups with which to associate the instances.</p>
         *        <p>
         *        If your instances are launched in EC2-Classic, you can either specify security group names or the
         *        security group IDs. For more information about security groups for EC2-Classic, see <a
         *        href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-network-security.html">Amazon EC2
         *        Security Groups</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
         *        </p>
         *        <p>
         *        If your instances are launched into a VPC, specify security group IDs. For more information, see <a
         *        href="http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_SecurityGroups.html">Security Groups
         *        for Your VPC</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroups(Collection<String> securityGroups);

        /**
         * <p>
         * One or more security groups with which to associate the instances.
         * </p>
         * <p>
         * If your instances are launched in EC2-Classic, you can either specify security group names or the security
         * group IDs. For more information about security groups for EC2-Classic, see <a
         * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-network-security.html">Amazon EC2 Security
         * Groups</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
         * </p>
         * <p>
         * If your instances are launched into a VPC, specify security group IDs. For more information, see <a
         * href="http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_SecurityGroups.html">Security Groups for Your
         * VPC</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.
         * </p>
         * 
         * @param securityGroups
         *        One or more security groups with which to associate the instances.</p>
         *        <p>
         *        If your instances are launched in EC2-Classic, you can either specify security group names or the
         *        security group IDs. For more information about security groups for EC2-Classic, see <a
         *        href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-network-security.html">Amazon EC2
         *        Security Groups</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
         *        </p>
         *        <p>
         *        If your instances are launched into a VPC, specify security group IDs. For more information, see <a
         *        href="http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_SecurityGroups.html">Security Groups
         *        for Your VPC</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroups(String... securityGroups);

        /**
         * <p>
         * The ID of a ClassicLink-enabled VPC to link your EC2-Classic instances to. This parameter is supported only
         * if you are launching EC2-Classic instances. For more information, see <a
         * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-classiclink.html">ClassicLink</a> in the
         * <i>Amazon Elastic Compute Cloud User Guide</i>.
         * </p>
         * 
         * @param classicLinkVPCId
         *        The ID of a ClassicLink-enabled VPC to link your EC2-Classic instances to. This parameter is supported
         *        only if you are launching EC2-Classic instances. For more information, see <a
         *        href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-classiclink.html">ClassicLink</a> in the
         *        <i>Amazon Elastic Compute Cloud User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder classicLinkVPCId(String classicLinkVPCId);

        /**
         * <p>
         * The IDs of one or more security groups for the specified ClassicLink-enabled VPC. This parameter is required
         * if you specify a ClassicLink-enabled VPC, and is not supported otherwise. For more information, see <a
         * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-classiclink.html">ClassicLink</a> in the
         * <i>Amazon Elastic Compute Cloud User Guide</i>.
         * </p>
         * 
         * @param classicLinkVPCSecurityGroups
         *        The IDs of one or more security groups for the specified ClassicLink-enabled VPC. This parameter is
         *        required if you specify a ClassicLink-enabled VPC, and is not supported otherwise. For more
         *        information, see <a
         *        href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-classiclink.html">ClassicLink</a> in the
         *        <i>Amazon Elastic Compute Cloud User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder classicLinkVPCSecurityGroups(Collection<String> classicLinkVPCSecurityGroups);

        /**
         * <p>
         * The IDs of one or more security groups for the specified ClassicLink-enabled VPC. This parameter is required
         * if you specify a ClassicLink-enabled VPC, and is not supported otherwise. For more information, see <a
         * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-classiclink.html">ClassicLink</a> in the
         * <i>Amazon Elastic Compute Cloud User Guide</i>.
         * </p>
         * 
         * @param classicLinkVPCSecurityGroups
         *        The IDs of one or more security groups for the specified ClassicLink-enabled VPC. This parameter is
         *        required if you specify a ClassicLink-enabled VPC, and is not supported otherwise. For more
         *        information, see <a
         *        href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-classiclink.html">ClassicLink</a> in the
         *        <i>Amazon Elastic Compute Cloud User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder classicLinkVPCSecurityGroups(String... classicLinkVPCSecurityGroups);

        /**
         * <p>
         * The user data to make available to the launched EC2 instances. For more information, see <a
         * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-metadata.html">Instance Metadata and
         * User Data</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
         * </p>
         * 
         * @param userData
         *        The user data to make available to the launched EC2 instances. For more information, see <a
         *        href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-metadata.html">Instance Metadata
         *        and User Data</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userData(String userData);

        /**
         * <p>
         * The ID of the instance to use to create the launch configuration. The new launch configuration derives
         * attributes from the instance, with the exception of the block device mapping.
         * </p>
         * <p>
         * If you do not specify <code>InstanceId</code>, you must specify both <code>ImageId</code> and
         * <code>InstanceType</code>.
         * </p>
         * <p>
         * To create a launch configuration with a block device mapping or override any other instance attributes,
         * specify them as part of the same request.
         * </p>
         * <p>
         * For more information, see <a
         * href="http://docs.aws.amazon.com/autoscaling/latest/userguide/create-lc-with-instanceID.html">Create a Launch
         * Configuration Using an EC2 Instance</a> in the <i>Auto Scaling User Guide</i>.
         * </p>
         * 
         * @param instanceId
         *        The ID of the instance to use to create the launch configuration. The new launch configuration derives
         *        attributes from the instance, with the exception of the block device mapping.</p>
         *        <p>
         *        If you do not specify <code>InstanceId</code>, you must specify both <code>ImageId</code> and
         *        <code>InstanceType</code>.
         *        </p>
         *        <p>
         *        To create a launch configuration with a block device mapping or override any other instance
         *        attributes, specify them as part of the same request.
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="http://docs.aws.amazon.com/autoscaling/latest/userguide/create-lc-with-instanceID.html">Create a
         *        Launch Configuration Using an EC2 Instance</a> in the <i>Auto Scaling User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The instance type of the EC2 instance.
         * </p>
         * <p>
         * If you do not specify <code>InstanceId</code>, you must specify <code>InstanceType</code>.
         * </p>
         * <p>
         * For information about available instance types, see <a
         * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#AvailableInstanceTypes"
         * >Available Instance Types</a> in the <i>Amazon Elastic Compute Cloud User Guide.</i>
         * </p>
         * 
         * @param instanceType
         *        The instance type of the EC2 instance.</p>
         *        <p>
         *        If you do not specify <code>InstanceId</code>, you must specify <code>InstanceType</code>.
         *        </p>
         *        <p>
         *        For information about available instance types, see <a
         *        href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#AvailableInstanceTypes"
         *        >Available Instance Types</a> in the <i>Amazon Elastic Compute Cloud User Guide.</i>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * The ID of the kernel associated with the AMI.
         * </p>
         * 
         * @param kernelId
         *        The ID of the kernel associated with the AMI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kernelId(String kernelId);

        /**
         * <p>
         * The ID of the RAM disk associated with the AMI.
         * </p>
         * 
         * @param ramdiskId
         *        The ID of the RAM disk associated with the AMI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ramdiskId(String ramdiskId);

        /**
         * <p>
         * One or more mappings that specify how block devices are exposed to the instance. For more information, see <a
         * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/block-device-mapping-concepts.html">Block Device
         * Mapping</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
         * </p>
         * 
         * @param blockDeviceMappings
         *        One or more mappings that specify how block devices are exposed to the instance. For more information,
         *        see <a
         *        href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/block-device-mapping-concepts.html">Block
         *        Device Mapping</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockDeviceMappings(Collection<BlockDeviceMapping> blockDeviceMappings);

        /**
         * <p>
         * One or more mappings that specify how block devices are exposed to the instance. For more information, see <a
         * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/block-device-mapping-concepts.html">Block Device
         * Mapping</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
         * </p>
         * 
         * @param blockDeviceMappings
         *        One or more mappings that specify how block devices are exposed to the instance. For more information,
         *        see <a
         *        href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/block-device-mapping-concepts.html">Block
         *        Device Mapping</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockDeviceMappings(BlockDeviceMapping... blockDeviceMappings);

        /**
         * <p>
         * Enables detailed monitoring (<code>true</code>) or basic monitoring (<code>false</code>) for the Auto Scaling
         * instances. The default is <code>true</code>.
         * </p>
         * 
         * @param instanceMonitoring
         *        Enables detailed monitoring (<code>true</code>) or basic monitoring (<code>false</code>) for the Auto
         *        Scaling instances. The default is <code>true</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceMonitoring(InstanceMonitoring instanceMonitoring);

        /**
         * <p>
         * The maximum hourly price to be paid for any Spot Instance launched to fulfill the request. Spot Instances are
         * launched when the price you specify exceeds the current Spot market price. For more information, see <a
         * href="http://docs.aws.amazon.com/autoscaling/latest/userguide/US-SpotInstances.html">Launching Spot Instances
         * in Your Auto Scaling Group</a> in the <i>Auto Scaling User Guide</i>.
         * </p>
         * 
         * @param spotPrice
         *        The maximum hourly price to be paid for any Spot Instance launched to fulfill the request. Spot
         *        Instances are launched when the price you specify exceeds the current Spot market price. For more
         *        information, see <a
         *        href="http://docs.aws.amazon.com/autoscaling/latest/userguide/US-SpotInstances.html">Launching Spot
         *        Instances in Your Auto Scaling Group</a> in the <i>Auto Scaling User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spotPrice(String spotPrice);

        /**
         * <p>
         * The name or the Amazon Resource Name (ARN) of the instance profile associated with the IAM role for the
         * instance.
         * </p>
         * <p>
         * EC2 instances launched with an IAM role will automatically have AWS security credentials available. You can
         * use IAM roles with Auto Scaling to automatically enable applications running on your EC2 instances to
         * securely access other AWS resources. For more information, see <a
         * href="http://docs.aws.amazon.com/autoscaling/latest/userguide/us-iam-role.html">Launch Auto Scaling Instances
         * with an IAM Role</a> in the <i>Auto Scaling User Guide</i>.
         * </p>
         * 
         * @param iamInstanceProfile
         *        The name or the Amazon Resource Name (ARN) of the instance profile associated with the IAM role for
         *        the instance.</p>
         *        <p>
         *        EC2 instances launched with an IAM role will automatically have AWS security credentials available.
         *        You can use IAM roles with Auto Scaling to automatically enable applications running on your EC2
         *        instances to securely access other AWS resources. For more information, see <a
         *        href="http://docs.aws.amazon.com/autoscaling/latest/userguide/us-iam-role.html">Launch Auto Scaling
         *        Instances with an IAM Role</a> in the <i>Auto Scaling User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamInstanceProfile(String iamInstanceProfile);

        /**
         * <p>
         * Indicates whether the instance is optimized for Amazon EBS I/O. By default, the instance is not optimized for
         * EBS I/O. The optimization provides dedicated throughput to Amazon EBS and an optimized configuration stack to
         * provide optimal I/O performance. This optimization is not available with all instance types. Additional usage
         * charges apply. For more information, see <a
         * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSOptimized.html">Amazon EBS-Optimized
         * Instances</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
         * </p>
         * 
         * @param ebsOptimized
         *        Indicates whether the instance is optimized for Amazon EBS I/O. By default, the instance is not
         *        optimized for EBS I/O. The optimization provides dedicated throughput to Amazon EBS and an optimized
         *        configuration stack to provide optimal I/O performance. This optimization is not available with all
         *        instance types. Additional usage charges apply. For more information, see <a
         *        href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSOptimized.html">Amazon EBS-Optimized
         *        Instances</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ebsOptimized(Boolean ebsOptimized);

        /**
         * <p>
         * Used for groups that launch instances into a virtual private cloud (VPC). Specifies whether to assign a
         * public IP address to each instance. For more information, see <a
         * href="http://docs.aws.amazon.com/autoscaling/latest/userguide/asg-in-vpc.html">Launching Auto Scaling
         * Instances in a VPC</a> in the <i>Auto Scaling User Guide</i>.
         * </p>
         * <p>
         * If you specify this parameter, be sure to specify at least one subnet when you create your group.
         * </p>
         * <p>
         * Default: If the instance is launched into a default subnet, the default is <code>true</code>. If the instance
         * is launched into a nondefault subnet, the default is <code>false</code>. For more information, see <a
         * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-supported-platforms.html">Supported
         * Platforms</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
         * </p>
         * 
         * @param associatePublicIpAddress
         *        Used for groups that launch instances into a virtual private cloud (VPC). Specifies whether to assign
         *        a public IP address to each instance. For more information, see <a
         *        href="http://docs.aws.amazon.com/autoscaling/latest/userguide/asg-in-vpc.html">Launching Auto Scaling
         *        Instances in a VPC</a> in the <i>Auto Scaling User Guide</i>.</p>
         *        <p>
         *        If you specify this parameter, be sure to specify at least one subnet when you create your group.
         *        </p>
         *        <p>
         *        Default: If the instance is launched into a default subnet, the default is <code>true</code>. If the
         *        instance is launched into a nondefault subnet, the default is <code>false</code>. For more
         *        information, see <a
         *        href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-supported-platforms.html">Supported
         *        Platforms</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associatePublicIpAddress(Boolean associatePublicIpAddress);

        /**
         * <p>
         * The tenancy of the instance. An instance with a tenancy of <code>dedicated</code> runs on single-tenant
         * hardware and can only be launched into a VPC.
         * </p>
         * <p>
         * You must set the value of this parameter to <code>dedicated</code> if want to launch Dedicated Instances into
         * a shared tenancy VPC (VPC with instance placement tenancy attribute set to <code>default</code>).
         * </p>
         * <p>
         * If you specify this parameter, be sure to specify at least one subnet when you create your group.
         * </p>
         * <p>
         * For more information, see <a
         * href="http://docs.aws.amazon.com/autoscaling/latest/userguide/asg-in-vpc.html">Launching Auto Scaling
         * Instances in a VPC</a> in the <i>Auto Scaling User Guide</i>.
         * </p>
         * <p>
         * Valid values: <code>default</code> | <code>dedicated</code>
         * </p>
         * 
         * @param placementTenancy
         *        The tenancy of the instance. An instance with a tenancy of <code>dedicated</code> runs on
         *        single-tenant hardware and can only be launched into a VPC.</p>
         *        <p>
         *        You must set the value of this parameter to <code>dedicated</code> if want to launch Dedicated
         *        Instances into a shared tenancy VPC (VPC with instance placement tenancy attribute set to
         *        <code>default</code>).
         *        </p>
         *        <p>
         *        If you specify this parameter, be sure to specify at least one subnet when you create your group.
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="http://docs.aws.amazon.com/autoscaling/latest/userguide/asg-in-vpc.html">Launching Auto Scaling
         *        Instances in a VPC</a> in the <i>Auto Scaling User Guide</i>.
         *        </p>
         *        <p>
         *        Valid values: <code>default</code> | <code>dedicated</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder placementTenancy(String placementTenancy);
    }

    private static final class BuilderImpl implements Builder {
        private String launchConfigurationName;

        private String imageId;

        private String keyName;

        private List<String> securityGroups;

        private String classicLinkVPCId;

        private List<String> classicLinkVPCSecurityGroups;

        private String userData;

        private String instanceId;

        private String instanceType;

        private String kernelId;

        private String ramdiskId;

        private List<BlockDeviceMapping> blockDeviceMappings;

        private InstanceMonitoring instanceMonitoring;

        private String spotPrice;

        private String iamInstanceProfile;

        private Boolean ebsOptimized;

        private Boolean associatePublicIpAddress;

        private String placementTenancy;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateLaunchConfigurationRequest model) {
            setLaunchConfigurationName(model.launchConfigurationName);
            setImageId(model.imageId);
            setKeyName(model.keyName);
            setSecurityGroups(model.securityGroups);
            setClassicLinkVPCId(model.classicLinkVPCId);
            setClassicLinkVPCSecurityGroups(model.classicLinkVPCSecurityGroups);
            setUserData(model.userData);
            setInstanceId(model.instanceId);
            setInstanceType(model.instanceType);
            setKernelId(model.kernelId);
            setRamdiskId(model.ramdiskId);
            setBlockDeviceMappings(model.blockDeviceMappings);
            setInstanceMonitoring(model.instanceMonitoring);
            setSpotPrice(model.spotPrice);
            setIamInstanceProfile(model.iamInstanceProfile);
            setEbsOptimized(model.ebsOptimized);
            setAssociatePublicIpAddress(model.associatePublicIpAddress);
            setPlacementTenancy(model.placementTenancy);
        }

        public final String getLaunchConfigurationName() {
            return launchConfigurationName;
        }

        @Override
        public final Builder launchConfigurationName(String launchConfigurationName) {
            this.launchConfigurationName = launchConfigurationName;
            return this;
        }

        public final void setLaunchConfigurationName(String launchConfigurationName) {
            this.launchConfigurationName = launchConfigurationName;
        }

        public final String getImageId() {
            return imageId;
        }

        @Override
        public final Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public final void setImageId(String imageId) {
            this.imageId = imageId;
        }

        public final String getKeyName() {
            return keyName;
        }

        @Override
        public final Builder keyName(String keyName) {
            this.keyName = keyName;
            return this;
        }

        public final void setKeyName(String keyName) {
            this.keyName = keyName;
        }

        public final Collection<String> getSecurityGroups() {
            return securityGroups;
        }

        @Override
        public final Builder securityGroups(Collection<String> securityGroups) {
            this.securityGroups = SecurityGroupsCopier.copy(securityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroups(String... securityGroups) {
            securityGroups(Arrays.asList(securityGroups));
            return this;
        }

        public final void setSecurityGroups(Collection<String> securityGroups) {
            this.securityGroups = SecurityGroupsCopier.copy(securityGroups);
        }

        public final String getClassicLinkVPCId() {
            return classicLinkVPCId;
        }

        @Override
        public final Builder classicLinkVPCId(String classicLinkVPCId) {
            this.classicLinkVPCId = classicLinkVPCId;
            return this;
        }

        public final void setClassicLinkVPCId(String classicLinkVPCId) {
            this.classicLinkVPCId = classicLinkVPCId;
        }

        public final Collection<String> getClassicLinkVPCSecurityGroups() {
            return classicLinkVPCSecurityGroups;
        }

        @Override
        public final Builder classicLinkVPCSecurityGroups(Collection<String> classicLinkVPCSecurityGroups) {
            this.classicLinkVPCSecurityGroups = ClassicLinkVPCSecurityGroupsCopier.copy(classicLinkVPCSecurityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder classicLinkVPCSecurityGroups(String... classicLinkVPCSecurityGroups) {
            classicLinkVPCSecurityGroups(Arrays.asList(classicLinkVPCSecurityGroups));
            return this;
        }

        public final void setClassicLinkVPCSecurityGroups(Collection<String> classicLinkVPCSecurityGroups) {
            this.classicLinkVPCSecurityGroups = ClassicLinkVPCSecurityGroupsCopier.copy(classicLinkVPCSecurityGroups);
        }

        public final String getUserData() {
            return userData;
        }

        @Override
        public final Builder userData(String userData) {
            this.userData = userData;
            return this;
        }

        public final void setUserData(String userData) {
            this.userData = userData;
        }

        public final String getInstanceId() {
            return instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getInstanceType() {
            return instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final String getKernelId() {
            return kernelId;
        }

        @Override
        public final Builder kernelId(String kernelId) {
            this.kernelId = kernelId;
            return this;
        }

        public final void setKernelId(String kernelId) {
            this.kernelId = kernelId;
        }

        public final String getRamdiskId() {
            return ramdiskId;
        }

        @Override
        public final Builder ramdiskId(String ramdiskId) {
            this.ramdiskId = ramdiskId;
            return this;
        }

        public final void setRamdiskId(String ramdiskId) {
            this.ramdiskId = ramdiskId;
        }

        public final Collection<BlockDeviceMapping> getBlockDeviceMappings() {
            return blockDeviceMappings;
        }

        @Override
        public final Builder blockDeviceMappings(Collection<BlockDeviceMapping> blockDeviceMappings) {
            this.blockDeviceMappings = BlockDeviceMappingsCopier.copy(blockDeviceMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockDeviceMappings(BlockDeviceMapping... blockDeviceMappings) {
            blockDeviceMappings(Arrays.asList(blockDeviceMappings));
            return this;
        }

        public final void setBlockDeviceMappings(Collection<BlockDeviceMapping> blockDeviceMappings) {
            this.blockDeviceMappings = BlockDeviceMappingsCopier.copy(blockDeviceMappings);
        }

        public final InstanceMonitoring getInstanceMonitoring() {
            return instanceMonitoring;
        }

        @Override
        public final Builder instanceMonitoring(InstanceMonitoring instanceMonitoring) {
            this.instanceMonitoring = instanceMonitoring;
            return this;
        }

        public final void setInstanceMonitoring(InstanceMonitoring instanceMonitoring) {
            this.instanceMonitoring = instanceMonitoring;
        }

        public final String getSpotPrice() {
            return spotPrice;
        }

        @Override
        public final Builder spotPrice(String spotPrice) {
            this.spotPrice = spotPrice;
            return this;
        }

        public final void setSpotPrice(String spotPrice) {
            this.spotPrice = spotPrice;
        }

        public final String getIamInstanceProfile() {
            return iamInstanceProfile;
        }

        @Override
        public final Builder iamInstanceProfile(String iamInstanceProfile) {
            this.iamInstanceProfile = iamInstanceProfile;
            return this;
        }

        public final void setIamInstanceProfile(String iamInstanceProfile) {
            this.iamInstanceProfile = iamInstanceProfile;
        }

        public final Boolean getEbsOptimized() {
            return ebsOptimized;
        }

        @Override
        public final Builder ebsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
            return this;
        }

        public final void setEbsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
        }

        public final Boolean getAssociatePublicIpAddress() {
            return associatePublicIpAddress;
        }

        @Override
        public final Builder associatePublicIpAddress(Boolean associatePublicIpAddress) {
            this.associatePublicIpAddress = associatePublicIpAddress;
            return this;
        }

        public final void setAssociatePublicIpAddress(Boolean associatePublicIpAddress) {
            this.associatePublicIpAddress = associatePublicIpAddress;
        }

        public final String getPlacementTenancy() {
            return placementTenancy;
        }

        @Override
        public final Builder placementTenancy(String placementTenancy) {
            this.placementTenancy = placementTenancy;
            return this;
        }

        public final void setPlacementTenancy(String placementTenancy) {
            this.placementTenancy = placementTenancy;
        }

        @Override
        public CreateLaunchConfigurationRequest build() {
            return new CreateLaunchConfigurationRequest(this);
        }
    }
}
