/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.autoscaling.model.ScheduledActionNamesCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeScheduledActionsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeScheduledActionsRequest> {
    private final String autoScalingGroupName;
    private final List<String> scheduledActionNames;
    private final Instant startTime;
    private final Instant endTime;
    private final String nextToken;
    private final Integer maxRecords;

    private DescribeScheduledActionsRequest(BuilderImpl builder) {
        this.autoScalingGroupName = builder.autoScalingGroupName;
        this.scheduledActionNames = builder.scheduledActionNames;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.nextToken = builder.nextToken;
        this.maxRecords = builder.maxRecords;
    }

    public String autoScalingGroupName() {
        return this.autoScalingGroupName;
    }

    public List<String> scheduledActionNames() {
        return this.scheduledActionNames;
    }

    public Instant startTime() {
        return this.startTime;
    }

    public Instant endTime() {
        return this.endTime;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Integer maxRecords() {
        return this.maxRecords;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.autoScalingGroupName() == null ? 0 : this.autoScalingGroupName().hashCode());
        hashCode = 31 * hashCode + (this.scheduledActionNames() == null ? 0 : this.scheduledActionNames().hashCode());
        hashCode = 31 * hashCode + (this.startTime() == null ? 0 : this.startTime().hashCode());
        hashCode = 31 * hashCode + (this.endTime() == null ? 0 : this.endTime().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        hashCode = 31 * hashCode + (this.maxRecords() == null ? 0 : this.maxRecords().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeScheduledActionsRequest)) {
            return false;
        }
        DescribeScheduledActionsRequest other = (DescribeScheduledActionsRequest)((Object)obj);
        if (other.autoScalingGroupName() == null ^ this.autoScalingGroupName() == null) {
            return false;
        }
        if (other.autoScalingGroupName() != null && !other.autoScalingGroupName().equals(this.autoScalingGroupName())) {
            return false;
        }
        if (other.scheduledActionNames() == null ^ this.scheduledActionNames() == null) {
            return false;
        }
        if (other.scheduledActionNames() != null && !other.scheduledActionNames().equals(this.scheduledActionNames())) {
            return false;
        }
        if (other.startTime() == null ^ this.startTime() == null) {
            return false;
        }
        if (other.startTime() != null && !other.startTime().equals(this.startTime())) {
            return false;
        }
        if (other.endTime() == null ^ this.endTime() == null) {
            return false;
        }
        if (other.endTime() != null && !other.endTime().equals(this.endTime())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        if (other.maxRecords() == null ^ this.maxRecords() == null) {
            return false;
        }
        return other.maxRecords() == null || other.maxRecords().equals(this.maxRecords());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.autoScalingGroupName() != null) {
            sb.append("AutoScalingGroupName: ").append(this.autoScalingGroupName()).append(",");
        }
        if (this.scheduledActionNames() != null) {
            sb.append("ScheduledActionNames: ").append(this.scheduledActionNames()).append(",");
        }
        if (this.startTime() != null) {
            sb.append("StartTime: ").append(this.startTime()).append(",");
        }
        if (this.endTime() != null) {
            sb.append("EndTime: ").append(this.endTime()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (this.maxRecords() != null) {
            sb.append("MaxRecords: ").append(this.maxRecords()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String autoScalingGroupName;
        private List<String> scheduledActionNames;
        private Instant startTime;
        private Instant endTime;
        private String nextToken;
        private Integer maxRecords;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeScheduledActionsRequest model) {
            this.setAutoScalingGroupName(model.autoScalingGroupName);
            this.setScheduledActionNames(model.scheduledActionNames);
            this.setStartTime(model.startTime);
            this.setEndTime(model.endTime);
            this.setNextToken(model.nextToken);
            this.setMaxRecords(model.maxRecords);
        }

        public final String getAutoScalingGroupName() {
            return this.autoScalingGroupName;
        }

        @Override
        public final Builder autoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
            return this;
        }

        public final void setAutoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
        }

        public final Collection<String> getScheduledActionNames() {
            return this.scheduledActionNames;
        }

        @Override
        public final Builder scheduledActionNames(Collection<String> scheduledActionNames) {
            this.scheduledActionNames = ScheduledActionNamesCopier.copy(scheduledActionNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scheduledActionNames(String ... scheduledActionNames) {
            this.scheduledActionNames(Arrays.asList(scheduledActionNames));
            return this;
        }

        public final void setScheduledActionNames(Collection<String> scheduledActionNames) {
            this.scheduledActionNames = ScheduledActionNamesCopier.copy(scheduledActionNames);
        }

        @SafeVarargs
        public final void setScheduledActionNames(String ... scheduledActionNames) {
            this.scheduledActionNames(Arrays.asList(scheduledActionNames));
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxRecords() {
            return this.maxRecords;
        }

        @Override
        public final Builder maxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
            return this;
        }

        public final void setMaxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
        }

        public DescribeScheduledActionsRequest build() {
            return new DescribeScheduledActionsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeScheduledActionsRequest> {
        public Builder autoScalingGroupName(String var1);

        public Builder scheduledActionNames(Collection<String> var1);

        public Builder scheduledActionNames(String ... var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder nextToken(String var1);

        public Builder maxRecords(Integer var1);
    }
}

