/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.autoscaling.model.LifecycleHookNamesCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeLifecycleHooksRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeLifecycleHooksRequest> {
    private final String autoScalingGroupName;
    private final List<String> lifecycleHookNames;

    private DescribeLifecycleHooksRequest(BuilderImpl builder) {
        this.autoScalingGroupName = builder.autoScalingGroupName;
        this.lifecycleHookNames = builder.lifecycleHookNames;
    }

    public String autoScalingGroupName() {
        return this.autoScalingGroupName;
    }

    public List<String> lifecycleHookNames() {
        return this.lifecycleHookNames;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.autoScalingGroupName() == null ? 0 : this.autoScalingGroupName().hashCode());
        hashCode = 31 * hashCode + (this.lifecycleHookNames() == null ? 0 : this.lifecycleHookNames().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLifecycleHooksRequest)) {
            return false;
        }
        DescribeLifecycleHooksRequest other = (DescribeLifecycleHooksRequest)((Object)obj);
        if (other.autoScalingGroupName() == null ^ this.autoScalingGroupName() == null) {
            return false;
        }
        if (other.autoScalingGroupName() != null && !other.autoScalingGroupName().equals(this.autoScalingGroupName())) {
            return false;
        }
        if (other.lifecycleHookNames() == null ^ this.lifecycleHookNames() == null) {
            return false;
        }
        return other.lifecycleHookNames() == null || other.lifecycleHookNames().equals(this.lifecycleHookNames());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.autoScalingGroupName() != null) {
            sb.append("AutoScalingGroupName: ").append(this.autoScalingGroupName()).append(",");
        }
        if (this.lifecycleHookNames() != null) {
            sb.append("LifecycleHookNames: ").append(this.lifecycleHookNames()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String autoScalingGroupName;
        private List<String> lifecycleHookNames;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLifecycleHooksRequest model) {
            this.setAutoScalingGroupName(model.autoScalingGroupName);
            this.setLifecycleHookNames(model.lifecycleHookNames);
        }

        public final String getAutoScalingGroupName() {
            return this.autoScalingGroupName;
        }

        @Override
        public final Builder autoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
            return this;
        }

        public final void setAutoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
        }

        public final Collection<String> getLifecycleHookNames() {
            return this.lifecycleHookNames;
        }

        @Override
        public final Builder lifecycleHookNames(Collection<String> lifecycleHookNames) {
            this.lifecycleHookNames = LifecycleHookNamesCopier.copy(lifecycleHookNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lifecycleHookNames(String ... lifecycleHookNames) {
            this.lifecycleHookNames(Arrays.asList(lifecycleHookNames));
            return this;
        }

        public final void setLifecycleHookNames(Collection<String> lifecycleHookNames) {
            this.lifecycleHookNames = LifecycleHookNamesCopier.copy(lifecycleHookNames);
        }

        @SafeVarargs
        public final void setLifecycleHookNames(String ... lifecycleHookNames) {
            this.lifecycleHookNames(Arrays.asList(lifecycleHookNames));
        }

        public DescribeLifecycleHooksRequest build() {
            return new DescribeLifecycleHooksRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeLifecycleHooksRequest> {
        public Builder autoScalingGroupName(String var1);

        public Builder lifecycleHookNames(Collection<String> var1);

        public Builder lifecycleHookNames(String ... var1);
    }
}

