/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.autoscaling.model.AutoScalingInstanceDetails;
import software.amazon.awssdk.services.autoscaling.model.AutoScalingInstancesCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeAutoScalingInstancesResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeAutoScalingInstancesResponse> {
    private final List<AutoScalingInstanceDetails> autoScalingInstances;
    private final String nextToken;

    private DescribeAutoScalingInstancesResponse(BuilderImpl builder) {
        this.autoScalingInstances = builder.autoScalingInstances;
        this.nextToken = builder.nextToken;
    }

    public List<AutoScalingInstanceDetails> autoScalingInstances() {
        return this.autoScalingInstances;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.autoScalingInstances() == null ? 0 : this.autoScalingInstances().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAutoScalingInstancesResponse)) {
            return false;
        }
        DescribeAutoScalingInstancesResponse other = (DescribeAutoScalingInstancesResponse)((Object)obj);
        if (other.autoScalingInstances() == null ^ this.autoScalingInstances() == null) {
            return false;
        }
        if (other.autoScalingInstances() != null && !other.autoScalingInstances().equals(this.autoScalingInstances())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.autoScalingInstances() != null) {
            sb.append("AutoScalingInstances: ").append(this.autoScalingInstances()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<AutoScalingInstanceDetails> autoScalingInstances;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAutoScalingInstancesResponse model) {
            this.setAutoScalingInstances(model.autoScalingInstances);
            this.setNextToken(model.nextToken);
        }

        public final Collection<AutoScalingInstanceDetails> getAutoScalingInstances() {
            return this.autoScalingInstances;
        }

        @Override
        public final Builder autoScalingInstances(Collection<AutoScalingInstanceDetails> autoScalingInstances) {
            this.autoScalingInstances = AutoScalingInstancesCopier.copy(autoScalingInstances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder autoScalingInstances(AutoScalingInstanceDetails ... autoScalingInstances) {
            this.autoScalingInstances(Arrays.asList(autoScalingInstances));
            return this;
        }

        public final void setAutoScalingInstances(Collection<AutoScalingInstanceDetails> autoScalingInstances) {
            this.autoScalingInstances = AutoScalingInstancesCopier.copy(autoScalingInstances);
        }

        @SafeVarargs
        public final void setAutoScalingInstances(AutoScalingInstanceDetails ... autoScalingInstances) {
            this.autoScalingInstances(Arrays.asList(autoScalingInstances));
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public DescribeAutoScalingInstancesResponse build() {
            return new DescribeAutoScalingInstancesResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeAutoScalingInstancesResponse> {
        public Builder autoScalingInstances(Collection<AutoScalingInstanceDetails> var1);

        public Builder autoScalingInstances(AutoScalingInstanceDetails ... var1);

        public Builder nextToken(String var1);
    }
}

