/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.autoscaling.model.*;
import software.amazon.awssdk.runtime.transform.Unmarshaller;

import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * ScalingPolicy StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class ScalingPolicyUnmarshaller implements Unmarshaller<ScalingPolicy, StaxUnmarshallerContext> {

    public ScalingPolicy unmarshall(StaxUnmarshallerContext context) throws Exception {
        ScalingPolicy.Builder scalingPolicy = ScalingPolicy.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        java.util.List<StepAdjustment> stepAdjustments = null;
        java.util.List<Alarm> alarms = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                scalingPolicy.stepAdjustments(stepAdjustments);
                scalingPolicy.alarms(alarms);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("AutoScalingGroupName", targetDepth)) {
                    scalingPolicy.autoScalingGroupName(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("PolicyName", targetDepth)) {
                    scalingPolicy.policyName(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("PolicyARN", targetDepth)) {
                    scalingPolicy.policyARN(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("PolicyType", targetDepth)) {
                    scalingPolicy.policyType(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("AdjustmentType", targetDepth)) {
                    scalingPolicy.adjustmentType(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("MinAdjustmentStep", targetDepth)) {
                    scalingPolicy.minAdjustmentStep(IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("MinAdjustmentMagnitude", targetDepth)) {
                    scalingPolicy.minAdjustmentMagnitude(IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("ScalingAdjustment", targetDepth)) {
                    scalingPolicy.scalingAdjustment(IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("Cooldown", targetDepth)) {
                    scalingPolicy.cooldown(IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("StepAdjustments", targetDepth)) {
                    stepAdjustments = new ArrayList<StepAdjustment>();
                    continue;
                }

                if (context.testExpression("StepAdjustments/member", targetDepth)) {
                    stepAdjustments.add(StepAdjustmentUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("MetricAggregationType", targetDepth)) {
                    scalingPolicy.metricAggregationType(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("EstimatedInstanceWarmup", targetDepth)) {
                    scalingPolicy.estimatedInstanceWarmup(IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("Alarms", targetDepth)) {
                    alarms = new ArrayList<Alarm>();
                    continue;
                }

                if (context.testExpression("Alarms/member", targetDepth)) {
                    alarms.add(AlarmUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    scalingPolicy.stepAdjustments(stepAdjustments);
                    scalingPolicy.alarms(alarms);
                    break;
                }
            }
        }
        return scalingPolicy.build();
    }

    private static ScalingPolicyUnmarshaller INSTANCE;

    public static ScalingPolicyUnmarshaller getInstance() {
        if (INSTANCE == null)
            INSTANCE = new ScalingPolicyUnmarshaller();
        return INSTANCE;
    }
}
